#include "ISHLight.h"
#include "Log.h"

struct light_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned int lux;
} __attribute__ ((packed));

struct light_aware {
        int64_t timestamp;
        unsigned int lux;
} __attribute__ ((packed));

ISHLight::ISHLight(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHLight::ISHLight(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHLight::~ISHLight()
{

}

void ISHLight::initialize()
{

        if (information.scale_android.size() == 1) {
                scaleX = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scaleX);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
        }
}

size_t ISHLight::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct light_raw);

        if (bufSize % sizeof(struct light_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct light_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct light_aware));

        const struct light_raw *light = reinterpret_cast<const struct light_raw *>(buf);
        struct light_aware *aware = reinterpret_cast<struct light_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = light[i].timestamp * US_TO_NS;
                aware[i].lux = light[i].lux;
        }

        return count * sizeof(struct light_aware);
}

size_t ISHLight::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct light_raw);

        if (bufSize % sizeof(struct light_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct light_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct light_raw *light = reinterpret_cast<const struct light_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = light[i].timestamp * US_TO_NS;
                mEvents[i].light = light[i].lux * scaleX;
        }
        return count;
}
