#include "ISHMagneticField.h"
#include "Log.h"

struct magnetic_field_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned char accuracy;
        unsigned short cuntom_usage;
} __attribute__ ((packed));

struct magnetic_field_aware {
        int64_t timestamp;
        int x;
        int y;
        int z;
        unsigned char accuracy;
} __attribute__ ((packed));

ISHMagneticField::ISHMagneticField(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHMagneticField::ISHMagneticField(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHMagneticField::~ISHMagneticField()
{

}

void ISHMagneticField::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHMagneticField::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct magnetic_field_raw);

        if (bufSize % sizeof(struct magnetic_field_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct magnetic_field_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct magnetic_field_aware));

        const struct magnetic_field_raw *magnetic_field = reinterpret_cast<const struct magnetic_field_raw *>(buf);
        struct magnetic_field_aware *aware = reinterpret_cast<struct magnetic_field_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = magnetic_field[i].timestamp * US_TO_NS;
                aware[i].x = magnetic_field[i].x;
                aware[i].y = magnetic_field[i].y;
                aware[i].z = magnetic_field[i].z;
                aware[i].accuracy = magnetic_field[i].accuracy;
        }

        return count * sizeof(struct magnetic_field_aware);
}

size_t ISHMagneticField::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct magnetic_field_raw);

        if (bufSize % sizeof(struct magnetic_field_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct magnetic_field_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct magnetic_field_raw *mag = reinterpret_cast<const struct magnetic_field_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = mag[i].timestamp * US_TO_NS;
                mEvents[i].magnetic.x = mag[i].x * scaleX;
                mEvents[i].magnetic.y = mag[i].y * scaleY;
                mEvents[i].magnetic.z = mag[i].z * scaleZ;
                mEvents[i].magnetic.status = mag[i].accuracy; // this map may changed
        }

        return count;
}
