#include "ISHMagneticFieldUncalibrated.h"
#include "Log.h"

// LUID: 0242000000000000

struct magnetic_field_uncalibrated_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x_uncalibrated;
        int x_calibrated;
        int y_uncalibrated;
        int y_calibrated;
        int z_uncalibrated;
        int z_calibrated;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct magnetic_field_uncalibrated_data {
        int64_t timestamp;
        int64_t timestamp0;
        int x_uncalibrated;
        int x_calibrated;
        int y_uncalibrated;
        int y_calibrated;
        int z_uncalibrated;
        int z_calibrated;
} __attribute__ ((packed));

ISHMagneticFieldUncalibrated::ISHMagneticFieldUncalibrated(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHMagneticFieldUncalibrated::ISHMagneticFieldUncalibrated(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHMagneticFieldUncalibrated::~ISHMagneticFieldUncalibrated()
{

}

void ISHMagneticFieldUncalibrated::initialize()
{
        if (information.scale_android.size() == 6) {
                for (int i = 0; i < 6; i++) {
                        scale[i] = information.scale_android[i];
                }
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f %f %f %f", __FUNCTION__, __LINE__, scale[0], scale[1], scale[2], scale[3], scale[4], scale[5]);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                for (int i = 0; i < 6; i++) {
                        scale[i] = 1.0;
                }
        }
}

size_t ISHMagneticFieldUncalibrated::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct magnetic_field_uncalibrated_raw);

        if (bufSize % sizeof(struct magnetic_field_uncalibrated_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct magnetic_field_uncalibrated_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct magnetic_field_uncalibrated_raw *mag = reinterpret_cast<const struct magnetic_field_uncalibrated_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = mag[i].timestamp * US_TO_NS;
                mEvents[i].uncalibrated_magnetic.x_uncalib = mag[i].x_uncalibrated * scale[0];
                mEvents[i].uncalibrated_magnetic.y_uncalib = mag[i].y_uncalibrated * scale[1];
                mEvents[i].uncalibrated_magnetic.z_uncalib = mag[i].z_uncalibrated * scale[2];
                mEvents[i].uncalibrated_magnetic.x_bias = (mag[i].x_uncalibrated - mag[i].x_calibrated) * scale[3];
                mEvents[i].uncalibrated_magnetic.y_bias = (mag[i].y_uncalibrated - mag[i].y_calibrated) * scale[4];
                mEvents[i].uncalibrated_magnetic.z_bias = (mag[i].z_uncalibrated - mag[i].z_calibrated) * scale[5];
        }

        return count;
}
