#include "ISHMoveDetector.h"
#include "Log.h"

// LUID: 0204000000000000

struct move_detector_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char state;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct move_detector_aware {
        int64_t timestamp;
        unsigned char state;
} __attribute__ ((packed));

ISHMoveDetector::ISHMoveDetector(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHMoveDetector::ISHMoveDetector(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHMoveDetector::~ISHMoveDetector()
{

}

void ISHMoveDetector::initialize()
{
}

size_t ISHMoveDetector::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct move_detector_raw);

        if (bufSize % sizeof(struct move_detector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct move_detector_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct move_detector_aware));

        const struct move_detector_raw *move_detector = reinterpret_cast<const struct move_detector_raw *>(buf);
        struct move_detector_aware *aware = reinterpret_cast<struct move_detector_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = move_detector[i].timestamp * US_TO_NS;
                aware[i].state = move_detector[i].state;
        }

        return count * sizeof(struct move_detector_aware);
}

size_t ISHMoveDetector::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct move_detector_raw);

        if (bufSize % sizeof(struct move_detector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct move_detector_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct move_detector_raw *move_detector = reinterpret_cast<const struct move_detector_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = move_detector[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = move_detector[i].state;
        }

        return count;
}
