#include "ISHPanZoom.h"
#include "Log.h"

// LUID: 0212000000000000

struct pan_zoom_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int deltaX;
        int deltaY;
        unsigned short custom_usage;
}__attribute__ ((packed));

struct pan_zoom_aware {
        int64_t timestamp;
        int deltaX;
        int deltaY;
}__attribute__ ((packed));

ISHPanZoom::ISHPanZoom(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHPanZoom::ISHPanZoom(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHPanZoom::~ISHPanZoom()
{

}

void ISHPanZoom::initialize()
{
}

size_t ISHPanZoom::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pan_zoom_raw);

        if (bufSize % sizeof(struct pan_zoom_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pan_zoom_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct pan_zoom_aware));

        const struct pan_zoom_raw *pan_zoom = reinterpret_cast<const struct pan_zoom_raw *>(buf);
        struct pan_zoom_aware *aware = reinterpret_cast<struct pan_zoom_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = pan_zoom[i].timestamp * US_TO_NS;
                aware[i].deltaX = pan_zoom[i].deltaX;
                aware[i].deltaY = pan_zoom[i].deltaY;
        }

        return count * sizeof(struct pan_zoom_aware);
}

size_t ISHPanZoom::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pan_zoom_raw);

        if (bufSize % sizeof(struct pan_zoom_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pan_zoom_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct pan_zoom_raw *pz = reinterpret_cast<const struct pan_zoom_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = pz[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = pz[i].deltaX;
                mEvents[i].data[1] = pz[i].deltaY;
        }

        return count;
}
