#include "ISHPhysicalAccelerometer.h"
#include "Log.h"

struct physical_accelerometer_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned short custom_usage;
} __attribute__ ((packed));

ISHPhysicalAccelerometer::ISHPhysicalAccelerometer(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHPhysicalAccelerometer::ISHPhysicalAccelerometer(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHPhysicalAccelerometer::~ISHPhysicalAccelerometer()
{

}

void ISHPhysicalAccelerometer::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHPhysicalAccelerometer::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct physical_accelerometer_raw);

        if (bufSize % sizeof(struct physical_accelerometer_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct physical_accelerometer_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct physical_accelerometer_raw *physical_accel = reinterpret_cast<const struct physical_accelerometer_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = physical_accel[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = physical_accel[i].x * scaleX;
                mEvents[i].data[1] = physical_accel[i].y * scaleY;
                mEvents[i].data[2] = physical_accel[i].z * scaleZ;
        }

        return count;
}
