#include "ISHPhysicalActivity.h"
#include "Log.h"

struct physical_activity_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int values[7];
        unsigned short custom_usage;
} __attribute__ ((packed));

struct physical_activity_aware {
        int64_t timestamp;
        int values[7];
} __attribute__ ((packed));

ISHPhysicalActivity::ISHPhysicalActivity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHPhysicalActivity::ISHPhysicalActivity(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHPhysicalActivity::~ISHPhysicalActivity()
{

}

void ISHPhysicalActivity::initialize()
{

}

size_t ISHPhysicalActivity::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct physical_activity_raw);

        if (bufSize % sizeof(struct physical_activity_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct physical_activity_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct physical_activity_aware));

        const struct physical_activity_raw *physical_activity = reinterpret_cast<const struct physical_activity_raw *>(buf);
        struct physical_activity_aware *aware = reinterpret_cast<struct physical_activity_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = physical_activity[i].timestamp * US_TO_NS;
                for (int j = 0; j < 7; j++)
                        aware[i].values[j] = physical_activity[i].values[j];
        }

        return count * sizeof(struct physical_activity_aware);
}

size_t ISHPhysicalActivity::convertToEvent(const char * buf, size_t bufSize)
{
        //Todo: implement the function
        return 0;
}
