#include "ISHProximity.h"
#include "Log.h"

// sc_sensor_type: 0x04B1

struct proximity_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint16_t distance;
} __attribute__ ((packed));

struct proximity_aware {
        int64_t timestamp;
        uint8_t distance;
} __attribute__ ((packed));

ISHProximity::ISHProximity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHProximity::ISHProximity(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHProximity::~ISHProximity()
{

}

void ISHProximity::initialize()
{
        if (information.scale_android.size() == 1) {
                scale = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scale);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scale = 1.0;
        }
}

size_t ISHProximity::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct proximity_raw);

        if (bufSize % sizeof(struct proximity_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct proximity_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct proximity_aware));

        const struct proximity_raw *proximity = reinterpret_cast<const struct proximity_raw *>(buf);
        struct proximity_aware *aware = reinterpret_cast<struct proximity_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = proximity[i].timestamp * US_TO_NS;
                aware[i].distance = proximity[i].distance;
        }

        return count * sizeof(struct proximity_aware);
}

size_t ISHProximity::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct proximity_raw);

        if (bufSize % sizeof(struct proximity_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct proximity_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct proximity_raw *distance = reinterpret_cast<const struct proximity_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = distance[i].timestamp * US_TO_NS;
                mEvents[i].distance = (!distance[i].distance) * scale;
        }

        return count;
}
