#include "ISHRGB.h"
#include "Log.h"

// sc_sensor_type: 0x251

struct _rgb_data_t {
        int64_t timestamp;
        int64_t timestamp0;
	uint32_t r;
	uint32_t g;
	uint32_t b;
} __attribute__ ((packed));

ISHRGB::ISHRGB(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHRGB::ISHRGB(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHRGB::~ISHRGB()
{

}

void ISHRGB::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleR = information.scale_android[0];
                scaleG = information.scale_android[1];
                scaleB = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleR, scaleG, scaleB);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleR = 1.0e-6;
                scaleG = 1.0e-6;
                scaleB = 1.0e-6;
        }
}

size_t ISHRGB::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct _rgb_data_t);

        if (bufSize % sizeof(struct _rgb_data_t) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct _rgb_data_t));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct _rgb_data_t *rgb = reinterpret_cast<const struct _rgb_data_t *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = rgb[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = rgb[i].r * scaleR;
                mEvents[i].data[1] = rgb[i].g * scaleG;
                mEvents[i].data[2] = rgb[i].b * scaleB;
        }

        return count;
}
