#include "ISHSAR.h"
#include "Log.h"

// LUID: 0266000E00000002

struct sar_raw {
        int64_t timestamp;
        int64_t timestamp0;
        char near;
        unsigned short custom_usage;
} __attribute__ ((packed));

ISHSAR::ISHSAR(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHSAR::ISHSAR(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHSAR::~ISHSAR()
{

}

void ISHSAR::initialize()
{

        if (information.scale_android.size() == 1) {
                scaleX = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scaleX);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
        }
}

size_t ISHSAR::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct sar_raw);

        if (bufSize % sizeof(struct sar_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct sar_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct sar_raw *sar = reinterpret_cast<const struct sar_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = sar[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = (!sar[i].near) * scaleX;
        }

        return count;
}
