#include "ISHShake.h"
#include "Log.h"

// LUID: 0233000000000000

struct shake_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char shake;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct shake_aware {
        int64_t timestamp;
        unsigned char shake;
} __attribute__ ((packed));

ISHShake::ISHShake(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHShake::ISHShake(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHShake::~ISHShake()
{

}

void ISHShake::initialize()
{
}

size_t ISHShake::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct shake_raw);

        if (bufSize % sizeof(struct shake_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct shake_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct shake_aware));

        const struct shake_raw *shake = reinterpret_cast<const struct shake_raw *>(buf);
        struct shake_aware *aware = reinterpret_cast<struct shake_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = shake[i].timestamp * US_TO_NS;
                aware[i].shake = shake[i].shake;
        }

        return count * sizeof(struct shake_aware);
}

size_t ISHShake::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct shake_raw);

        if (bufSize % sizeof(struct shake_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct shake_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct shake_raw *shake = reinterpret_cast<const struct shake_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = shake[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = shake[i].shake;
        }

        return count;
}
