#include "ISHSignificantMotion.h"
#include "Log.h"

// LUID: 0236000000000000
struct significant_motion_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint8_t motion;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct significant_motion_aware {
        int64_t timestamp;
        uint8_t motion;
} __attribute__ ((packed));

ISHSignificantMotion::ISHSignificantMotion(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHSignificantMotion::ISHSignificantMotion(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHSignificantMotion::~ISHSignificantMotion()
{

}

void ISHSignificantMotion::initialize()
{

}

size_t ISHSignificantMotion::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct significant_motion_raw);

        if (bufSize % sizeof(struct significant_motion_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct significant_motion_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct significant_motion_aware));

        const struct significant_motion_raw *motion = reinterpret_cast<const struct significant_motion_raw *>(buf);
        struct significant_motion_aware *aware = reinterpret_cast<struct significant_motion_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = motion[i].timestamp * US_TO_NS;
                aware[i].motion = motion[i].motion;
        }

        return count * sizeof(struct significant_motion_aware);
}

size_t ISHSignificantMotion::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct significant_motion_raw);

        if (bufSize % sizeof(struct significant_motion_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct significant_motion_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct significant_motion_raw *motion = reinterpret_cast<const struct significant_motion_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = motion[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = motion[i].motion;
        }

        return count;
}
