#include "ISHTerminal.h"
#include "Log.h"

// LUID: 0205000000000000

#define SENSOR_EVENT_TYPE_TERMINAL_FACE_UP              (1)
#define SENSOR_EVENT_TYPE_TERMINAL_FACE_DOWN            (2)
#define SENSOR_EVENT_TYPE_TERMINAL_PORTRAIT_UP          (3)
#define SENSOR_EVENT_TYPE_TERMINAL_PORTRAIT_DOWN        (4)
#define SENSOR_EVENT_TYPE_TERMINAL_HORIZONTAL_UP        (5)
#define SENSOR_EVENT_TYPE_TERMINAL_HORIZONTAL_DOWN      (6)
#define SENSOR_EVENT_TYPE_TERMINAL_UNKNOWN              (7)

struct terminal_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char state;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct terminal_aware {
        int64_t timestamp;
        unsigned char state;
} __attribute__ ((packed));

ISHTerminal::ISHTerminal(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHTerminal::ISHTerminal(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHTerminal::~ISHTerminal()
{

}

void ISHTerminal::initialize()
{
}

size_t ISHTerminal::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct terminal_raw);

        if (bufSize % sizeof(struct terminal_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct terminal_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct terminal_aware));

        const struct terminal_raw *terminal = reinterpret_cast<const struct terminal_raw *>(buf);
        struct terminal_aware *aware = reinterpret_cast<struct terminal_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = terminal[i].timestamp * US_TO_NS;
                aware[i].state = terminal[i].state;
        }

        return count * sizeof(struct terminal_aware);
}

size_t ISHTerminal::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct terminal_raw);

        if (bufSize % sizeof(struct terminal_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct terminal_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct terminal_raw *terminal = reinterpret_cast<const struct terminal_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = terminal[i].timestamp * US_TO_NS;
                switch (terminal[i].state) {
                case 0:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_PORTRAIT_UP;
                        break;
                case 1:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_HORIZONTAL_UP;
                        break;
                case 2:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_PORTRAIT_DOWN;
                        break;
                case 3:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_HORIZONTAL_DOWN;
                        break;
                case 4:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_FACE_UP;
                        break;
                case 5:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_FACE_DOWN;
                        break;
                default:
                        mEvents[i].data[0] = SENSOR_EVENT_TYPE_TERMINAL_UNKNOWN;
                        break;
                }
        }

        return count;
}
