#include "ISHTiltDetector.h"
#include "Log.h"

// LUID: 0214000000000000

struct tilt_detector_raw {
        int64_t timestamp;
        int64_t timestamp0;
        char tilt;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct tilt_detector_aware {
        int64_t timestamp;
        char tilt;
} __attribute__ ((packed));

ISHTiltDetector::ISHTiltDetector(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHTiltDetector::ISHTiltDetector(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHTiltDetector::~ISHTiltDetector()
{

}

void ISHTiltDetector::initialize()
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

size_t ISHTiltDetector::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct tilt_detector_raw);

        if (bufSize % sizeof(struct tilt_detector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct tilt_detector_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct tilt_detector_aware));

        const struct tilt_detector_raw *tilt_detector = reinterpret_cast<const struct tilt_detector_raw *>(buf);
        struct tilt_detector_aware *aware = reinterpret_cast<struct tilt_detector_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = tilt_detector[i].timestamp * US_TO_NS;
                aware[i].tilt = tilt_detector[i].tilt;
        }

        return count * sizeof(struct tilt_detector_aware);
}

size_t ISHTiltDetector::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct tilt_detector_raw);

        if (bufSize % sizeof(struct tilt_detector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct tilt_detector_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct tilt_detector_raw *tilt_detector = reinterpret_cast<const struct tilt_detector_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = tilt_detector[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = 1.0;
        }
        return count;
}
