#include "ISHWakeGesture.h"
#include "Log.h"

// LUID: 0211000000000000 lift sensor
struct wake_gesture_raw {
        int64_t timestamp;
        int64_t timestamp0;
        char look;
        char vertical;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct wake_gesture_data {
        int64_t timestamp;
        int64_t timestamp0;
        char look;
        char vertical;
} __attribute__ ((packed));

ISHWakeGesture::ISHWakeGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHWakeGesture::ISHWakeGesture(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHWakeGesture::~ISHWakeGesture()
{

}

void ISHWakeGesture::initialize()
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

size_t ISHWakeGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct wake_gesture_raw);
        size_t num = 0;

        if (bufSize % sizeof(struct wake_gesture_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct wake_gesture_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct wake_gesture_raw *wake = reinterpret_cast<const struct wake_gesture_raw *>(buf);
        for (int i = 0; i < count; i++) {
                if ((wake[i].look != 0) || (wake[i].vertical != 0)) {
                        mEvents[i].timestamp = wake[i].timestamp * US_TO_NS;
                        mEvents[i].data[0] = 1.0;
                        num++;
                }
        }
        return num;
}
