/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHGyroscope.h"
#include "Log.h"

struct gyro_raw_data {
        int64_t ts;
        short x;
        short y;
        short z;
        unsigned char reserved[2];
} __attribute__ ((packed));

PSHGyroscope::PSHGyroscope(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
 :PSHSensor(device, information, data, service)
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

PSHGyroscope::~PSHGyroscope()
{

}

size_t PSHGyroscope::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gyro_raw_data);

        if (bufSize % sizeof(struct gyro_raw_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gyro_raw_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct gyro_raw_data *gyro = reinterpret_cast<const struct gyro_raw_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = gyro[i].ts;
                mEvents[i].gyro.x = gyro[i].x * scaleX;
                mEvents[i].gyro.y = gyro[i].y * scaleY;
                mEvents[i].gyro.z = gyro[i].z * scaleZ;
                mEvents[i].gyro.status = SENSOR_STATUS_ACCURACY_HIGH;
        }
        return count;
}
