/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHWakeGesture.h"
#include "Log.h"

#define STAP_MAX_LEVEL          5
#define STAP_MIN_LEVEL          -5
#define STAP_MAX_MASK           3
#define STAP_MIN_MASK           1

// simple tapping property
#define STAP_PROP_CLSMASK 101
#define STAP_PROP_LEVEL 102

struct stap_property {
        unsigned char type;
        int value;
}__attribute__ ((packed));

struct stap_data {
        int64_t ts;
        short stap;
} __attribute__ ((packed));

PSHWakeGesture::PSHWakeGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
        :PSHSensor(device, information, data, service)
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

PSHWakeGesture::~PSHWakeGesture()
{

}

bool PSHWakeGesture::startStreaming(Session * session, int64_t samplingPeriodUs, int64_t maxReportLatencyUs)
{
        struct stap_property property = { STAP_PROP_CLSMASK, 2 };
        setProperty(session, &property, sizeof(property));

        property.type = STAP_PROP_LEVEL;
        property.value = STAP_MIN_LEVEL;
        setProperty(session, &property, sizeof(property));

        return PSHSensor::startStreaming(session, samplingPeriodUs, maxReportLatencyUs);
}

size_t PSHWakeGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct stap_data);

        if (bufSize % sizeof(struct stap_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct stap_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct stap_data *tapping = reinterpret_cast<const struct stap_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = tapping[i].ts;
                mEvents[i].data[0] = 1.0;
        }
        return count;
}
