# -*- coding: utf-8 -*-
# Copyright (C) 2005 Tiago Cogumbreiro <cogumbreiro@users.sf.net>
# $Id: components.py 570 2005-09-09 19:28:26Z cogumbreiro $

#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:
#
#The above copyright notice and this permission notice shall be included in
#all copies or substantial portions of the Software.
#
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#SOFTWARE.

import weakref

void_method = lambda self: None
void_func = lambda *args: None

def getRootComponent(component):
    """
    This is a helper function that tranverses the component tree upwards.
    """
    while component.parent is not None:
        component = component.parent
    return component



class Component (object):
    """
    A Component is an object that is structured in a hierarchical model.
    It is constructed upon runtime from the root to its children. To define
    a Component you have to define a list of subcomponents, these are usually
    classes of this type.
    They define a method called '_init' that is called in the constructor.
    It also contains a '_components' protected variable that holds a list of its
    children components.
    """
    
    def __init__ (self, parent = None):
        self.__parent = parent is not None and weakref.ref (parent) or void_func
        # Maintain components reference
        self._components = []
        for component in self.components:
            self._components.append (component(self))
        
        for attr, component in self.namedComponents.iteritems ():
            setattr (self, attr, component(self))
        self._init ()
    
    def _init (self):
        """Override this method which is called in the constructor."""
    
    def getParent (self):
        return self.__parent ()
        
    parent = property (getParent)
    
    components = ()
    namedComponents = {}

