/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCCommon.h

Description:

    This file defines class IPCCommon.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCCOMMON_H_
#define IPCCOMMON_H_

#include "CommonMessage.h"

namespace IPCAPI
{
//---Teacher App bus parameters
#define TEACHER_APP_BUS_NAME "ses.teacher.app"
#define TEACHER_APP_BUS_TYPE "ses.teacherapp.type"
#define TEACHER_APP_BUS_MATCH "type='signal',interface='ses.teacherdaemon.type'"

//---Teacher Daemon bus parameters
#define TEACHER_DAEMON_BUS_NAME "ses.teacher.daemon"
#define TEACHER_DAEMON_BUS_TYPE "ses.teacherdaemon.type"
#define TEACHER_DAEMON_BUS_MATCH "type='signal',interface='ses.teacherapp.type'"

//---Student Daemon bus parameters
#define STUDENT_DAEMON_BUS_NAME "ses.student.daemon"
#define STUDENT_DAEMON_BUS_TYPE "ses.studentdaemon.type"
#define STUDENT_DAEMON_BUS_MATCH "type='signal',interface='ses.studentapp.type'"

//---Student App bus parameters
#define STUDENT_APP_BUS_NAME "ses.student.app"
#define STUDENT_APP_BUS_TYPE "ses.studentapp.type"
#define STUDENT_APP_BUS_MATCH "type='signal',interface='ses.studentdaemon.type'"

enum ClientType
{
	SES_API_FOR_UNKNOWN = -1,
	SES_API_FOR_TEACHER_APP = 0,
	SES_API_FOR_STUDENT_APP = 1,
	SES_API_FOR_TEACHER_DAEMON = 2,
	SES_API_FOR_STUDENT_DAEMON = 3
};

}

#endif /*IPCCOMMON_H_*/
