/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          IPCTeacherAPI.h

Description:

    This file defines class IPCTeacherAPI.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Sheng Lijie 2008/9/16

  =====================================================================

****************************************************************************/

#ifndef IPCTEACHERAPI_H_
#define IPCTEACHERAPI_H_

#include <string>
#include <list>
#include "IPCCommon.h"
#include "IPCAPIBase.h"
#include "IntfData.h"
#include "LockScheduleData.h"

namespace IPCAPI
{
class IIPCTeacherAPICallback;
class TeacherMessageNotify;

class IPCTeacherAPI: public IPCAPIBase
{
private:
	IIPCTeacherAPICallback* m_callbackObj;
	TeacherMessageNotify* m_MessageNotify;
private:
	APIResult Initialize();
	APIResult UnInitialize();
public:
	IPCTeacherAPI();
	~IPCTeacherAPI();

	//Async
	APIResult SearchProgram(std::string targetFolder, int& OID, int Option = PROGRAMSEARCH_APPEND);
	APIResult ManualLockRemotStudent(std::string studentID, std::string lockPolicy);
	APIResult ManualUnlockRemoteStudent(std::string studentID);
	APIResult ControlNewStudentConnect(std::string studentID, bool allow);
	APIResult KickOffStudent(std::string studentID);
	APIResult DeploySchedulePolicy(std::string studentID,	std::string schedulePolicyXM);
//	APIResult DeployTabNavPolicy(std::string studentID, std::string tabNavPolicyXML);
	APIResult PostMessage(int MessageID, std::string Message);

	//New method for future.
	APIResult ManualLockRemotStudent(std::list<std::string> studentIDList, std::string lockPolicy);
	APIResult ManualUnlockRemoteStudent(std::list<std::string> studentIDList);
	APIResult DeploySchedulePolicy(std::list<std::string> studentIDList,std::string schedulePolicyXML,int& OID);
	APIResult DeployTabNavPolicy(std::list<std::string> studentIDList, std::string schedulePolicyXML, std::string tabNavPolicyXML, int& OID);
	APIResult KickOffStudent(std::list<std::string> studentIDList);
	APIResult KickOffAllStudent();

	//Sync
	APIResult StartController(int& errCode);
	APIResult StopController(int& errCode);
	APIResult GetStudentList(std::list<StudentInfo_t>& StudentList, int& errCode);
	APIResult CancelOperation(int OID, int& errCode);
	APIResult UpdateTeacherInfo(std::string teacherInfoXML, int& errCode);
	APIResult GetStudentStatus(std::string studentID, StudentInfo_t& StudentInfo, int& errCode);
	APIResult VerifyCertificate(std::string path, int& errCode);
	APIResult VerifyPassword(std::string path, std::string Password, int& errCode);
	APIResult ImportCertificate(std::string Path, int& errCode);
	APIResult ChangePassword(std::string OldPassword, std::string NewPassword,	int& errCode);
	APIResult GetStudentLockPolicy(std::string studentID, LibSESData::CLockScheduleData& LockSchedule, int& errCode);

	//Discarded
	APIResult VerifyPassword(std::string Password, int& errCode);
	APIResult VerifyCertificate(int& errCode);
	///////////////////////////////////////////////////////////

	//Function Method
	APIResult DoAction(std::string strName, std::string inArgs,
			std::string& outArgs);
	APIResult RegisterCallBack(IIPCTeacherAPICallback* callbackObj);
	APIResult UnRegisterCallBack();
};

}

#endif /*IPCTEACHERAPI_H_*/
