/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved.



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS.


File Name:          LibSESDataCommon.h

Description:

    This file defines constant value.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Jin Xin    2008/9/16

  =====================================================================

****************************************************************************/

#ifndef LIBSESDATACOMMON_H_
#define LIBSESDATACOMMON_H_

#include <string>

namespace LibSESData {

	// Error Code
	const int LIBSESDATA_SUCCESS = 0;
	const int LIBSESDATA_FAILURE = -1;
	const int LIBSESDATA_INVALID_ARGS = -2;

	//SES config file path
	const std::string CONFIG_FILE_DIR 	= "/etc/SES/";
	const std::string CLASS_GROUP		= "ClassGroup.xml";
	const std::string DEFAULT_CONFIG	= "DefaultConfig.xml";
	const std::string FAVORITE			= "Favorite.xml";
	const std::string LOCK_SCHEDULE		= "LockSchedule.xml";
	const std::string SEARCH_RESULT		= "SearchResult.xml";
	const std::string SES_SYSTEM_SETTING	= "SESSystemSetting.xml";
	const std::string SES_THEME				= "SESTheme.xml";
	const std::string STUDENT_INFO		= "StudentInfo.xml";
	const std::string TAB_NAVIGATION	= "TabNavigation.xml";
	const std::string TEACHER_INFO		= "TeacherInfo.xml";
	const std::string POLICYSETTING		= "PolicySettingData.xml";
	const std::string TEACHERPOLICYSETTING		= "TeacherPolicySettingData.xml";


	//Shell lock status flag file
	const std::string SES_LOCK_STATUS_FLAG_FILE = "SES.lock";

	//SES bin path
	const std::string SES_BIN_PATH = "/usr/bin/SES/";
	const std::string SES_BIN_TABNAVIGATION = "TabNavigation";
	const std::string SES_BIN_TEACHER_SELECTION = "TeacherSelection";
	const std::string SES_BIN_STUDENT_INFO = "StudentInformation";
	const std::string SES_BIN_FAVORITE_EDITOR = "TabNaviFavoriteEditor";
	const std::string SES_BIN_ADMINISTRATOR_TOOLS = "";
	const std::string SES_BIN_THEME_SETTING = "TabNaviUISetting";
	const std::string SES_BIN_TASK_MANAGER = "TaskManager";
	const std::string SES_BIN_ABOUT = "About";
	const std::string SES_BIN_SESSWITCHAPP = "SESSwitchApp";
	const std::string SES_BIN_VOLUMECONTROLLER = "VolumeController";

	//TODO Add Other bin path
	const std::string SES_BIN_TASK_SWITCH = "TaskSwitch";
	const std::string SES_BIN_SHELL_CONTROLLER = "ShellController";
	const std::string SES_BIN_CALENDAR = "SESCalendar";
	const std::string SES_BIN_ADMIN_SETTING = "AdministrativeSettings";
	const std::string SES_BIN_CA_TOOL = "CAToolsWindow";
	const std::string SES_BIN_ADMINPWDCONFIRM = "AdminPwdConfirm";
	const std::string SES_BIN_FADEOUT_MAKER = "FadeoutMaker";

	// SES lib name
	const std::string SES_LIB_DATA = "libSESData";
	const std::string SES_LIB_GUI = "libSESGUI";

	//Local dir
	const std::string LOCALEDIR = "/usr/share/locale/";

	//resource path
	const std::string SES_RESOURCE_PATH = CONFIG_FILE_DIR + "res/";
	const std::string SES_RESOURCE_IMAGE_PATH = CONFIG_FILE_DIR + "image/";
	const std::string SES_RESOURCE_THEME_PATH = CONFIG_FILE_DIR + "theme/";
	const std::string SES_RESOURCE_THEME_BACKGROUND_PATH = "Images/";
	const std::string SES_RESOURCE_FILE = "/gtkrc";
	const std::string SES_HELP_PATH = "/usr/share/doc/SES/";

	// user manule
	const std::string SES_TAB_NAVI_HELP = "Intel_CMPC3.0_TabNavigation_UserManual.pdf";
	const std::string SES_ADMIN_SETTING_HELP = "Intel_CMPC3.0_AdminSettings_UserManual.pdf";
	const std::string SES_SHELL_CONTROLLER_HELP = "Intel_CMPC3.0_Shell_Controller_UserManual.pdf";

	const std::string SES_IMAGE_APP_DEFAULT_ICON = SES_RESOURCE_IMAGE_PATH + "gui_default_app.png";
	const std::string SES_SHELL_CONTROLLER_ICON = SES_RESOURCE_IMAGE_PATH + "shellcontroller_main.png";
	const std::string SES_ADMIN_TOOL_ICON		= SES_RESOURCE_IMAGE_PATH + "admintool_main.png";
	const std::string SES_TASK_MANAGER_ICON		= SES_RESOURCE_IMAGE_PATH + "taskmanager_main.png";
	const std::string SES_TASK_MANAGER_ENDPROC_ICON		= SES_RESOURCE_IMAGE_PATH + "taskmanager_endproc.png";
	const std::string SES_CATOOL_ICON			= SES_RESOURCE_IMAGE_PATH + "catool_main.png";
	const std::string SES_SWITCHAPPLET_ICON = SES_RESOURCE_IMAGE_PATH + "switchapplet_main.png";
	const std::string SES_TABNAVIGATION_ICON = SES_RESOURCE_IMAGE_PATH + "tabnavigation_main.png";

	const std::string SES_TEACHER_ICON = SES_RESOURCE_IMAGE_PATH + "gui_teacher_connected.png";
	const std::string SES_TEACHER_CONNECT_ICON = SES_RESOURCE_IMAGE_PATH + "gui_teacher_connected.png";
	const std::string SES_TEACHER_DISCONNECT_ICON = SES_RESOURCE_IMAGE_PATH + "gui_teacher_disconnected.png";
	const std::string SES_STUDENT_ICON = SES_RESOURCE_IMAGE_PATH + "gui_student.png";

	// Lock Files for implement singleton.
	//const std::string RUNNING_APP_LOCK_PATH = "/usr/local/bin/SES/";
	const std::string RUNNING_APP_LOCK_PATH = "/tmp/";
	const std::string SES_BIN_TABNAVIGATION_LOCKFILE = RUNNING_APP_LOCK_PATH + "TabNavigation.lock";
	const std::string SES_BIN_TEACHER_SELECTION_LOCKFILE = RUNNING_APP_LOCK_PATH + "TeacherSelection.lock";
	const std::string SES_BIN_STUDENT_INFO_LOCKFILE = RUNNING_APP_LOCK_PATH + "StudentInformation.lock";
	const std::string SES_BIN_FAVORITE_EDITOR_LOCKFILE = RUNNING_APP_LOCK_PATH + "TabNaviFavoriteEditor.lock";
	const std::string SES_BIN_ADMINISTRATOR_TOOLS_LOCKFILE = RUNNING_APP_LOCK_PATH + "AdministrativeTool.lock";
	const std::string SES_BIN_THEME_SETTING_LOCKFILE = RUNNING_APP_LOCK_PATH + "ThemeSetting.lock";
	const std::string SES_BIN_SHELLCONTROLLER_LOCKFILE = RUNNING_APP_LOCK_PATH +"ShellController.lock";
	const std::string SES_BIN_ADMINTOOL_LOCKFILE = RUNNING_APP_LOCK_PATH +"AdminTool.lock";
	const std::string SES_BIN_TASK_MANAGER_LOCKFILE = RUNNING_APP_LOCK_PATH +"TaskManager.lock";
	const std::string SES_BIN_CALENDAR_LOCKFILE = RUNNING_APP_LOCK_PATH +"SesCalendar.lock";
	const std::string SES_BIN_SSD_LOCKFILE = RUNNING_APP_LOCK_PATH +"SSD.lock";
	const std::string SES_BIN_TSD_LOCKFILE = RUNNING_APP_LOCK_PATH +"TSD.lock";
	const std::string SES_BIN_TABNAVIUISETTING_LOCKFILE = RUNNING_APP_LOCK_PATH +"TabNaviUISetting.lock";
	const std::string SES_BIN_TASK_SWITCH_LOCKFILE = RUNNING_APP_LOCK_PATH +"TaskSwitch.lock";
	const std::string SES_BIN_ADMINPWDCONFIRM_LOCKFILE = RUNNING_APP_LOCK_PATH + "AdminPwdConfirm.lock";
	const std::string SES_BIN_FADEOUTMAKER_LOCKFILE = RUNNING_APP_LOCK_PATH + "FadeoutMaker.lock";
	const std::string SES_BIN_SSD_TEMPFILE = RUNNING_APP_LOCK_PATH + "tabnavigation.xml";
	const std::string SES_BIN_About_LOCKFILE = RUNNING_APP_LOCK_PATH + "About.lock";
	const std::string SES_BIN_CATOOL_LOCKFILE = RUNNING_APP_LOCK_PATH + "CaTool.lock";
	const std::string SES_BIN_VOLUMECONTROLLER_LOCKFILE = RUNNING_APP_LOCK_PATH + "VolumeController.lock";
	const std::string SES_BIN_SESSWITCHAPP_LOCKFILE = RUNNING_APP_LOCK_PATH + "SESSwitchApp.lock";

	// image path
	const std::string IMAGE_PATH = "/etc/SES/image/";
	const std::string TABNAVIGATION_TRAYICON_CONNECTED_LOCK		 	=	"connected_locked.png";
	const std::string TABNAVIGATION_TRAYICON_DISCONNECTED_LOCK 		=	"disconnected_locked.png";
	const std::string TABNAVIGATION_TRAYICON_CONNECTED_UNLOCK 		=	"connected_unlocked.png";
	const std::string TABNAVIGATION_TRAYICON_DISCONNECTED_UNLOCK 	=	"disconnected_unlocked.png";
	const std::string TABNAVIGATION_TRAYICON_LOCK   = "tabnavigation_trayicon_lock.png";
	const std::string TABNAVIGATION_TRAYICON_UNLOCK = "tabnavigation_trayicon_unlock.png";

	//VolumeController Tray Icon
	const std::string VOLUME_CONTROLLER_HIGH_VOLUME		=	IMAGE_PATH + "audio-volume-high.png";
	const std::string VOLUME_CONTROLLER_MEDIUM_VOLUME	=	IMAGE_PATH + "audio-volume-medium.png";
	const std::string VOLUME_CONTROLLER_LOW_VOLUME		=	IMAGE_PATH + "audio-volume-low.png";
	const std::string VOLUME_CONTROLLER_MUTE_VOLUME		=	IMAGE_PATH + "audio-volume-muted.png";

	// icon path
	const std::string ICON_PATH = "/etc/SES/icons/";

	// Status Menu Icon
	const std::string STATUS_MENU_SELECT_TEACHER	= 	IMAGE_PATH + "select_teacher.png";
	const std::string STATUS_MENU_SELECT_HELP		= 	IMAGE_PATH + "help.png";
	const std::string STATUS_MENU_SELECT_ABOUT		= 	IMAGE_PATH + "about.png";

	//APP MAIN ICON
	const std::string FAVORITEEDITOR_MAIN_ICON 		= 	"favoriteeditor_main.png";
	const std::string TEACHERSELECTION_MAIN_ICON 	=	"teacherselection_main.png";
	const std::string STUDENTINFO_MAIN_ICON			= 	"studentinfo_main.png";
	const std::string UISETTING_MAIN_ICON 			= 	"uisetting_main.png";

	// Select class status icon
	const std::string SC_THISCLASS_UNLOCK_DISCONNECT_ICON = "sc_ThisClass_Unlock_Disconnect.png";
	const std::string SC_THISCLASS_UNLOCK_CONNECT_ICON = "sc_ThisClass_Unlock.png";
	const std::string SC_THISCLASS_LOCK_DISCONNECT_ICON = "sc_ThisClass_Lock_Disconnect.png";
	const std::string SC_THISCLASS_LOCK_CONNECT_ICON = "sc_ThisClass_Lock.png";
	const std::string SC_NOTTHISCLASS_UNLOCK_DISCONNECT_ICON = "sc_NotThisClass_Unlock_Disconnect.png";
	const std::string SC_NOTTHISCLASS_UNLOCK_CONNECT_ICON = "sc_NotThisClass_Unlock.png";
	const std::string SC_NOTTHISCLASS_LOCK_DISCONNECT_ICON = "sc_NotThisClass_Lock_Disconnect.png";
	const std::string SC_NOTTHISCLASS_LOCK_CONNECT_ICON = "sc_NotThisClass_Lock.png";

	const std::string TABNAVIGATION_DEFAULT_BACKGROUND = SES_RESOURCE_THEME_BACKGROUND_PATH + "tabnavigation.png";
	const std::string TABNAVIGATION_TAB_FAVORITE = IMAGE_PATH + "tabnavigation_tab_favorite.png";
	const std::string TASKSWITCH_TASKMANAGER_BUTTON_ICON = IMAGE_PATH + "taskmanager_app.png";

	const std::string SES_RC_HOMEDIR	=  "/.ses";
	const std::string SES_GTKRC_FILE = "/gtkrc";
	const std::string SES_RC_PARSE_FILE = "/gtkrc-2.0";
	const std::string SES_RC_PARSE_FILE_BAKPATH = SES_RESOURCE_THEME_PATH + SES_RC_PARSE_FILE;
	const std::string SES_DEFAULT_THEME = "Blue";
	// special style defined in rc configuration file
	const std::string SES_STYLE_FONT_WHITE = "font-white";
	const std::string SES_STYLE_FONT_BLACK = "font-black";
	const std::string SES_STYLE_LABEL_FONT = "label-font";

	const std::string SES_STYLE_BUTTON_PANEL = "button-panel.GtkEventBox";
	const std::string SES_STYLE_TASKSWITCH_BG = "taskswitch-bg";

	const std::string SES_STYLE_UP_BUTTON 	= "up-button";
	const std::string SES_STYLE_DOWN_BUTTON = "down-button";
	const std::string SES_STYLE_LEFT_BUTTON = "left-button";
	const std::string SES_STYLE_RIGHT_BUTTON = "right-button";
	const std::string SES_STYLE_CLOSE_BUTTON = "close-button";
	const std::string SES_STYLE_SMALL_BUTTON = "small-button";
	const std::string SES_STYLE_LINK_BUTTON = "link-button";

	const std::string SES_VERSION = "3.0.0.162";
}

#endif /* LIBSESDATACOMMON_H_ */
