/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          LocalDomain.h

Description:

    This file defines class LocalDomain.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Shao Mingyin 2008/12/08

  =====================================================================

****************************************************************************/


#ifndef __LOCALDOMAIN_H__
#define __LOCALDOMAIN_H__

#ifdef SES_LOCAL_DOMAIN

#include <glib/gi18n.h>

#include "LibSESDataCommon.h"

namespace LibSESData
{
	inline static const char *GetText(const char *Domain, const char *MsgID)
	{
		bindtextdomain(Domain , LOCALEDIR.c_str());
		bind_textdomain_codeset (Domain, "UTF-8");

		return dgettext(Domain, MsgID);
	}
}

#undef _
#define _(str) LibSESData::GetText(SES_LOCAL_DOMAIN, str)

#endif // SES_LOCAL_DOMAIN

#endif // __LOCALDOMAIN_H__
