/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          SESThemeData.h

Description:

    This file defines class SESThemeData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __SESTHEMEDATA_H__
#define __SESTHEMEDATA_H__

#include "SESDataProvider.h"
#include "Font.h"
#include "Theme.h"
#include "BackgroundImage.h"
#include <list>

namespace LibSESData
{
	class CSESThemeData: public LibSESData::CSESDataProvider
	{
	public:
		CSESThemeData();
		virtual ~CSESThemeData();

	protected:
		int DOM2Member();
		int Member2DOM();

	private:
		CFont* m_pFont;
		CBackgroundImage* m_pBackgroundImage;
		std::list<CTheme*>* m_pThemeList;

	public:

		//Modify by lx start 20081013: move to cpp
		std::list<CTheme*> *GetPThemeList() const;

		void SetPThemeList(std::list<CTheme*> *pThemeList);
		//Modify by lx end

		std::string GetFontName() const;
		void SetFontName(std::string m_strFontName);

		int GetFontSize() const;
		void SetFontSize(int m_iFontSize);

		std::string GetImagePath() const;
		void SetImagePath(std::string m_strImagePath);

		std::string GetCurrentTheme() const;
		void SetCurrentTheme(std::string m_strCurrentThemeName);

		std::string GetCurrentThemePath() const;
		void SetCurrentThemePath(std::string m_strCurrentThemePath);
	};

}

#endif /* __SESTHEMEDATA_H__ */
