/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CAboutDlg.h

Description:

    This file defines class CAboutDlg.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Qian di    2008/10/28

  =====================================================================

****************************************************************************/

#ifndef CABOUTDLG_H_
#define CABOUTDLG_H_

#include <gtk/gtk.h>
#include <string>

#include "CSESLog.h"
#include "libsesdata.h"
#include "SESDataTools.h"
#include <glib/gi18n.h>
#include "CSESWindowBase.h"

namespace LibSESGUI
{

//TODO: jinxin review need inherit from windows base.
class CAboutDlg : public CSESWindowBase
{
public:
	CAboutDlg();
	explicit CAboutDlg(const std::string& strAppName, const std::string& strTitleName,const std::string& strImagePath, const std::string& strVersion);
	virtual ~CAboutDlg();

public:
	int Init();
//	int Close();
//	int Show();


public:

	static int ClickOKBtn(GtkWidget *widget, gpointer data);

private:
	std::string m_strAppName;
	std::string m_strTitleName;
	std::string m_strShowAppName;
	std::string m_strBGImagePath;
	std::string m_strImagePath;
	std::string m_strVersion;
	std::string m_strShowVersion;
	std::string m_strShowCopyright;
//	std::string m_strShowCopyrightOther;
	std::string m_strDefaultImagePath;

	const gchar* m_gShowAppName;
	const gchar* m_gShowVersion;
	const gchar* m_gShowCopyright;
	const gchar* m_gShowCopyrightOther;
	const gchar* m_gDefaultImagePath;

	GdkPixbuf *m_pImage ;
	GtkWidget *m_FixBox;
	GtkWidget *m_gLabelAppName;
	GtkWidget *m_gLabelVersion;
	GtkWidget *m_gLabelCopyright;
	GtkWidget *m_gLabelCopyrightOther;
	GtkWidget *m_gOkBtn;
	GtkWidget *m_gImage;
	GtkWidget *m_gBGImage;
	GdkPixbuf *m_gIconPixbuf;
	GtkWidget *m_showBgImage;
};

}

#endif /* CABOUTDLG_H_ */
