#include <string>
#include <sstream>

#include "DeployShellSettingsWindow.h"
#include "PublicFunc.h"




using namespace std;
using namespace LibSESData;
using namespace IPCAPI;
using namespace LibSESGUI;

#define DEPLOY_SHELLSETTINGS_WINDOW_BORDER_WIDTH 1
#define DEPLOY_SHELLSETTINGS_WINDOW_WIDTH 320
#define DEPLOY_SHELLSETTINGS_WINDOW_HEIGHT 110
#define DEPLOY_SHELLSETTINGS_WINDOW_PROGRESS_BAR_WIDTH 300
#define DEPLOY_SHELLSETTINGS_WINDOW_PROGRESS_BAR_HEIGHT 25
#define DEPLOY_SETTINGS_WINDOW_CANCEL_COLOSE_BUTTON_WIDTH 80
#define DEPLOY_SETTINGS_WINDOW_CANCEL_COLOSE_BUTTON_HEIGHT 30

DeployShellSettingsWindow::DeployShellSettingsWindow(std::list<std::string>& studentList, int selectStudentCount)

{
	m_pTeacherAPI->RegisterCallBack(this);

//	m_iStudentNumber = 0;
	m_gWindow = NULL;

	m_gProgressBar = NULL;
	list<string>::iterator iter;
	for(iter = studentList.begin(); iter != studentList.end(); ++iter)
	{
		m_pStudentList.push_back(*iter);
	}

	m_iDeployStudentNumber = 0;
	m_iStudentSuccessfulNum = 0;
	m_iDeployStudentWholeNum = studentList.size();

	m_iSelectStudentsCount = selectStudentCount;

	//m_iCancelOperationID = OID;

	//m_iCanceeOperationOK = false;

	m_bHasCancelOperation = false;
}

DeployShellSettingsWindow::~DeployShellSettingsWindow()
{
	if(NULL != m_gWindow)
	{
		gtk_widget_destroy(m_gWindow);
	}
}

int DeployShellSettingsWindow::Init()
{
	InitWindow();
	return 0;
}

int DeployShellSettingsWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	DeploySettingsData();
	return 0;
}

int DeployShellSettingsWindow::InitWindow()
{
	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect (G_OBJECT(m_gWindow), "delete_event", G_CALLBACK(OnWindowClosing), this);
	//g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK(gtk_main_quit), NULL);
	//g_signal_connect (G_OBJECT(m_gWindow), "show", G_CALLBACK(OnWindowShow), this);
	gtk_container_set_border_width (GTK_CONTAINER (m_gWindow), DEPLOY_SHELLSETTINGS_WINDOW_BORDER_WIDTH);
	gtk_window_set_position (GTK_WINDOW (m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_widget_set_size_request (GTK_WIDGET (m_gWindow), DEPLOY_SHELLSETTINGS_WINDOW_WIDTH, DEPLOY_SHELLSETTINGS_WINDOW_HEIGHT);
	//gtk_window_set_keep_above (GTK_WINDOW (m_gWindow), true);
	gtk_window_set_resizable(GTK_WINDOW (m_gWindow), FALSE);
	gtk_window_set_title(GTK_WINDOW (m_gWindow), _("Deploy Settings"));
	//gtk_window_set_decorated(GTK_WINDOW (m_gWindow), FALSE);

	//added by dengjing
	//modify by shaomy
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Deploy Settings"), "SES");

	string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), error);

	GtkWidget* pMainVbox = NULL;
	pMainVbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (m_gWindow), pMainVbox);

	GtkWidget* pHbox = NULL;
	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pMainVbox), pHbox, FALSE, FALSE, 10);


	m_gLabel = NULL;
	m_gLabel = gtk_label_new (_("Deploy Shell Settings..."));
	gtk_widget_set_tooltip_text (m_gLabel, _("Deploy Shell Settings..."));
	gtk_box_pack_start(GTK_BOX(pHbox), m_gLabel, FALSE, FALSE, 10);


    pHbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (pMainVbox), pHbox, FALSE, FALSE, 0);

	//m_pProgressBarData = (ProgressBarData_t*)g_malloc(sizeof(ProgressBarData_t));
	//m_pProgressBarData->pProgressBar = gtk_progress_bar_new ();
	m_gProgressBar = gtk_progress_bar_new ();
	gtk_widget_set_size_request(m_gProgressBar, DEPLOY_SHELLSETTINGS_WINDOW_PROGRESS_BAR_WIDTH,
												DEPLOY_SHELLSETTINGS_WINDOW_PROGRESS_BAR_HEIGHT);
	//gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (m_gProgressBar), GTK_PROGRESS_LEFT_TO_RIGHT);
	//gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(m_gProgressBar), 0.0);
	//gtk_progress_bar_pulse (GTK_PROGRESS_BAR(m_gProgressBar));
	//gtk_progress_bar_set_pulse_step (GTK_PROGRESS_BAR(m_gProgressBar), 0.0);
	//gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR(m_gProgressBar), GTK_PROGRESS_DISCRETE);

	gtk_box_pack_start(GTK_BOX (pHbox), m_gProgressBar, FALSE, FALSE, 10);

	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pMainVbox), pHbox, FALSE, FALSE, 10);

	m_gCancelCloseBtn = gtk_button_new_with_label(_("Cancel"));
	g_signal_connect (G_OBJECT(m_gCancelCloseBtn), "clicked", G_CALLBACK(DeployShellSettingsWindow::OnBtnClick), this);
	gtk_widget_set_size_request(m_gCancelCloseBtn, DEPLOY_SETTINGS_WINDOW_CANCEL_COLOSE_BUTTON_WIDTH,
	                            DEPLOY_SETTINGS_WINDOW_CANCEL_COLOSE_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX(pHbox), m_gCancelCloseBtn, FALSE, FALSE, 10);

	//m_pProgressBarData->timer = g_timeout_add(100, GSourceFunc(ProgressTimeOut), m_pProgressBarData);
	return 0;
}


int DeployShellSettingsWindow::Release()
{
	return 0;
}


void DeployShellSettingsWindow::DeployTabNavPolicyCallBack(string studentID, bool bSuccess)
{
    CSESLog::WriteLine("ShellControllerWindow::DeploySchedulePolicyCallBack>>Start");
	gdk_threads_enter();
	double dProgress = 0.0;
	if (studentID.size() > 0)
    {
	    if(bSuccess)
	    {
	        m_iDeployStudentNumber++;
	        m_iStudentSuccessfulNum++;

	    }
	    else
	    {
	        m_iDeployStudentNumber++;
	    }
	    dProgress = (double) m_iDeployStudentNumber / (double) m_iDeployStudentWholeNum;
	    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(m_gProgressBar), dProgress);
;
    }
    else
    {
        // cancel operation
        gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(m_gProgressBar), 1.0);

//        m_iDeployStudentNumber = 0;
//        m_iDeployStudentWholeNum 	= 0;
        //m_iCanceeOperationOK = true;
    }
//Deploy Shell Settings Complete
	if (m_iDeployStudentNumber >= m_iDeployStudentWholeNum)
    {



        stringstream summaryStream("");
        summaryStream << "Successful:";
        summaryStream << m_iStudentSuccessfulNum;
        summaryStream << "  ";
        summaryStream << "Failure:";
        summaryStream << m_iSelectStudentsCount-m_iStudentSuccessfulNum;
        //summaryStream << m_iDeployStudentWholeNum-m_iStudentSuccessfulNum;
//        string summaryString ("Successful:");
//        summary.append("");
        gtk_label_set_text(GTK_LABEL(m_gLabel), summaryStream.str().c_str());
        gtk_widget_set_tooltip_text(m_gLabel, summaryStream.str().c_str());

        m_iStudentSuccessfulNum         = 0;
        //m_iDeployStudentWholeNum    = 0;
        m_iDeployStudentNumber = 0;

        gtk_button_set_label(GTK_BUTTON(m_gCancelCloseBtn), "Close");
        //CMessageBox::Show(_("Deploy Shell Settings is done!"), m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
        //gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(m_gProgressBar), 0.0);
    }


	gdk_threads_leave();
	//
	CSESLog::WriteLine("ShellControllerWindow::DeploySchedulePolicyCallBack>>End");
}

void DeployShellSettingsWindow::OnWindowShow (GtkWidget*, GdkEvent*, gpointer)
{

}

bool DeployShellSettingsWindow::OnWindowClosing(GtkWindow* gtkwidget, GdkEvent* event, gpointer data)
{
    DeployShellSettingsWindow* ptr = (DeployShellSettingsWindow*)data;
    int ret = false;
    if(false == ptr->m_bHasCancelOperation)
    {
        int errCode = 0;
        if (SES_API_SUCCESS == ptr->m_pTeacherAPI->CancelOperation(ptr->m_iCancelOperationID, errCode))
        {
            ptr->m_iCancelOperationID = 0;
            ret = false;
        }
        else
        {
            ret = true;
            CSESLog::WriteLine("Fail to cancel deploy Shell Settings!", CSESLog::ERROR);
        }
    }


    return ret;
}

void DeployShellSettingsWindow::OnBtnClick(GtkWidget* gtkwidget, gpointer data)
{
    DeployShellSettingsWindow* ptr = (DeployShellSettingsWindow*)data;

    string buttonString = gtk_button_get_label(GTK_BUTTON(ptr->m_gCancelCloseBtn));


    if( 0== buttonString.compare("Close"))
    {
        gtk_widget_destroy(ptr->m_gWindow);
    }
    else
    {
        gtk_button_set_label(GTK_BUTTON(gtkwidget), "Close");

        int errCode = 0;

        if (SES_API_SUCCESS == ptr->m_pTeacherAPI->CancelOperation(ptr->m_iCancelOperationID, errCode))
        {
            ptr->m_bHasCancelOperation = true;
            ptr->m_iCancelOperationID = 0;

            stringstream summaryStream("");
            summaryStream << "Successful:";
            summaryStream << ptr->m_iStudentSuccessfulNum;
            summaryStream << "  ";
            summaryStream << "Failure:";
            summaryStream << ptr->m_iDeployStudentWholeNum-ptr->m_iStudentSuccessfulNum;

            gtk_label_set_text(GTK_LABEL(ptr->m_gLabel), summaryStream.str().c_str());
        }
        else
        {
            CSESLog::WriteLine("Fail to cancel deploy Shell Settings!", CSESLog::ERROR);
        }

    }

}


void DeployShellSettingsWindow::DeploySettingsData()
{
    string lockScheduleString("");
    string tabNaviString("");
    CLockScheduleData lockScheduleData;
    CTabNavigationData tabNavigationData;
    if(m_pStudentList.size() > 0)
    {
        lockScheduleData.LoadFromFile(CONFIG_FILE_DIR + LOCK_SCHEDULE);
        lockScheduleData.SetManualLock(0);
        if(true == lockScheduleData.IsAutoLockEnable())
        {
            lockScheduleData.SetLockStatus(SES_STU_AUTO_LOCK);
        }else
        {
            lockScheduleData.SetLockStatus(SES_STU_AUTO_UNLOCK);
        }
        tabNavigationData.LoadFromFile(CONFIG_FILE_DIR + TAB_NAVIGATION);
        lockScheduleData.SetManualLock(0);
        lockScheduleData.Save2String(lockScheduleString);
        tabNavigationData.Save2String(tabNaviString);

        if ( m_pStudentList.size() > 0 )
        {
//            CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,  "ShellControllerWindow::DeploySettings::DeploySchedulePolicy<<Start LOG_TEACHER_DEPLOYSCHEDULE");
//
//            m_pTeacherAPI->DeploySchedulePolicy(m_pStudentList, lockScheduleString, m_iCancelOperationID);
//            CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE,  "ShellControllerWindow::DeploySettings::DeploySchedulePolicy>>End LOG_TEACHER_DEPLOYSCHEDULE");

            CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,   "ShellControllerWindow::DeploySettings::DeployTabNavPolicy<<Start LOG_TEACHER_DEPLOYTABNAV");
            m_pTeacherAPI->DeployTabNavPolicy(m_pStudentList, lockScheduleString, tabNaviString, m_iCancelOperationID);
            CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,   "ShellControllerWindow::DeploySettings::DeployTabNavPolicy>>End LOG_TEACHER_DEPLOYTABNAV");

        }
    }
//    else
//    {
//        string message(_("Please select some students!"));
//        CMessageBox::Show(message, m_gWindow, GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
//         //ptr->SESShowDialog("please select some students");
//    }
}
