	/******************************************************************************
 * File Name    : EditGroupWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : To Edit the Class
 ******************************************************************************/
#include <vector>
#include <algorithm>
#include <functional>
#include <ctype.h>
#include "EditGroupWindow.h"
#include "TeacherCallBack.h"
#include <glib/gi18n.h>
#include "PublicFunc.h"
#include "SESCommonDef.h"
#include "libsesdata.h"
#include "libsesgui.h"


using namespace LibSESData;
using namespace std;
using namespace IPCAPI;
using namespace LibSESGUI;

#define EDIT_WINDOW_ARROW_BUTTTON_WIDTH 60
#define EDIT_WINDOW_ARROW_BUTTTON_HEIGHT 30

enum
{
	COLUMN_ITEM_ICON,
	COLUMN_ITEM_STUDENTNAME,
	COLUMN_ITEM_STUDENT,
	COLUMN_ITEM_COLUMNS,
};
/******************************************************************************
 * Function Name: EditGroupWindow
 * Description  : The constructor of EditGroupWindow
 * Date         : 2008/9/10
 * Parameter    : IsAdd				justify if Adding class or Editing class
 * 				  pClass			the selected class
 * 				  pTeacherApiRef	IPCTeacherAPI
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
EditGroupWindow::EditGroupWindow(int IsAdd,
								 CClassDef* pClass, //IPCTeacherAPI* pTeacherApiRef,
		                         CClassGroupData* pClassGroup)
	: m_pClass(NULL)
{
	CSESLog::WriteLine("EditGroupWindow::EditGroupWindow >>Start");


	string selectClassPicPath = SES_STUDENT_ICON;
	m_pEditClassPic = gdk_pixbuf_new_from_file_at_size (selectClassPicPath.c_str(), 24, 24, NULL);
	m_iIsAdd = IsAdd;
	if(NULL != pClass)
	{
		m_pClass = pClass->Clone();
		m_previousClassName = pClass->GetName();
	}
	else
	{
		m_pClass = new CClassDef();
	}

	// save the original data.
	m_pClassOrg = m_pClass->Clone();

	//m_pClassOriRef = pClass;

	m_iResult = BUTTON_CLICK_IS_CANCEL;
	m_gWindow = NULL;
	m_gEntry = NULL;
    m_pLeftTreeView = NULL;
    m_pRightTreeView = NULL;
    m_pLeftStore = NULL;
    m_pRightStore = NULL;
    //m_pTeacherApiRef = pTeacherApiRef;
    m_IsLeftTreeViewSelected = false;
    m_IsRightTreeViewSelected = false;
    //m_isDataChanged = 0;
    m_isInitial = 0;

    m_ClassGroup.LoadFromFile(LibSESData::CONFIG_FILE_DIR + CLASS_GROUP);

    CSESLog::WriteLine("EditGroupWindow::EditGroupWindow <<End");
}
/******************************************************************************
 * Function Name: ~EditGroupWindow
 * Description  : The destructor of EditGroupWindow
 * Date         : 2008/9/10
 * Parameter    : Void
 * Return Code  : Void
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
EditGroupWindow::~EditGroupWindow()
{
	CSESLog::WriteLine("EditGroupWindow::~EditGroupWindow>>Start");

	g_object_unref(m_pEditClassPic);

	if(NULL != m_gWindow)
	{
	    gtk_widget_destroy(m_gWindow);
	}

	if(NULL != m_pClass)
	{
		delete m_pClass;
		m_pClass = NULL;
	}

	if(NULL != m_pClassOrg)
	{
		delete m_pClassOrg;
		m_pClassOrg = NULL;
	}

	if(m_pEditClassPic)
	{
	    g_object_unref (m_pEditClassPic);
	}
	ReleaseStudentList();

	CSESLog::WriteLine("EditGroupWindow::~EditGroupWindow<<End");
}
/******************************************************************************
 * Function Name: Init
 * Description  : To Init the EditGroupWindow
 * Date         : 2008/9/10
 * Parameter    : Void
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::Init()
{
	CSESLog::WriteLine("EditGroupWindow::Init>>Start");
	int result = InitWindow();
	if(SHELLCONTROLLER_SUCCESSFUL != result)
	{
		CSESLog::WriteLine("EditGroupWindow::Init --InitWindow Failed", CSESLog::ERROR);
		return SHELLCONTROLLER_FAILED;
	}
	CSESLog::WriteLine("EditGroupWindow::Init<<End");
    return SHELLCONTROLLER_SUCCESSFUL;
}
/******************************************************************************
 * Function Name: InitWindow
 * Description  : To Init the main window
 * Date         : 2008/9/10
 * Parameter    : Void
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::InitWindow()
{
	CSESLog::WriteLine("EditGroupWindow::InitWindow>>Start");
	GtkWidget *vbox = NULL;
	GtkWidget *label = NULL;
	GtkWidget *hbox = NULL;
	GtkWidget *scrolled_window = NULL;
	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);

	g_signal_connect (G_OBJECT (m_gWindow), "delete_event", G_CALLBACK (EditGroupWindow::OnWindowClosing), this);
	gtk_window_set_title(GTK_WINDOW(m_gWindow), _("Edit Class"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Edit Class"), "SES");
	gtk_container_set_border_width(GTK_CONTAINER(m_gWindow), 0);
	gtk_widget_set_size_request(GTK_WIDGET (m_gWindow), 468, 282);
	gtk_window_set_resizable(GTK_WINDOW(m_gWindow), FALSE);
	gtk_window_set_position(GTK_WINDOW(m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);
	string iconPath("");
	iconPath.append(SES_RESOURCE_IMAGE_PATH);
	iconPath.append("shellcontroller_main.png");
	GError** error = NULL;
	gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), iconPath.c_str(), error);

	vbox = gtk_vbox_new (FALSE, 0);
	//gtk_dialog_add_action_widget(GTK_DIALOG(m_gWindow), vbox, 0);
	gtk_container_add (GTK_CONTAINER (m_gWindow), vbox);

	hbox = gtk_hbox_new(FALSE, false);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 10);

	label = gtk_label_new(_("Class Name:"));
	gtk_widget_set_tooltip_text (label, _("Class Name:"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 10);
	//gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);

	m_gEntry = gtk_entry_new();
	g_signal_connect (G_OBJECT (m_gEntry), "changed", G_CALLBACK (NameEntryChanged), this);
	gtk_widget_set_size_request(m_gEntry, 200, 25);
	gtk_box_pack_start(GTK_BOX(hbox), m_gEntry, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_set_size_request(hbox, 100, 190);

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window), 1);
	gtk_widget_set_size_request(scrolled_window, 180, 280);
	gtk_box_pack_start(GTK_BOX (hbox), scrolled_window, FALSE, FALSE, 5);

	CreateLeftTreeView(scrolled_window);

	InitMiddleButtons (hbox);

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window), 1);
	gtk_widget_set_size_request(scrolled_window, 180, 280);
	gtk_box_pack_start(GTK_BOX (hbox), scrolled_window, FALSE, FALSE, 5);

	CreateRightTreeView(scrolled_window);

	InitBottomButtons (vbox);

	if(m_iIsAdd)
	{
		AddWindow();
	}
	else
	{
		EditWindow();
	}
	CSESLog::WriteLine("EditGroupWindow::InitWindow<<End");
	return 0;
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : To make the window in modal style
 * Date         : 2008/9/10
 * Parameter    : parentWindow			parent window
 * 				  cb					callback function
 * 				  data					user data
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("EditGroupWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parentWindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	if (NULL != cb)
	{
		g_signal_connect (G_OBJECT(m_gWindow), "destroy", G_CALLBACK (cb), data);
	}
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("EditGroupWindow::ShowModal<<End");
	return 0;
}

int EditGroupWindow::InitListViews()
{
	int ret = 0;

	// 1.class student
	// 2.online student
	// 2.1 check repeat
	// 3.make name unique
	// 4.call draw tree funcs
	list<CStudentInfoData*>::iterator iterStudent;
	std::list<CStudentInfoData*>* pStudentList = m_pClass->GetPStudentsInfoList();

	for(iterStudent = pStudentList->begin(); iterStudent != pStudentList->end(); ++iterStudent)
	{
		StudentInfo_t* pStudent = new StudentInfo_t();
		pStudent->username 		= (*iterStudent)->GetStudentName();
		pStudent->studentID 	= (*iterStudent)->GetStudentID();
		pStudent->displayName 	= pStudent->username;

		m_StudentListInClass.push_back(pStudent);
	}

	// 2.online student
	// 2.1 check repeat
	std::list<IPCAPI::StudentInfo_t> studentList;
	std::list<IPCAPI::StudentInfo_t>::iterator iterOnlineStudent;

	m_pTeacherAPI->GetStudentList(studentList, ret);

	for (iterOnlineStudent = studentList.begin();iterOnlineStudent!= studentList.end(); ++iterOnlineStudent)
	{
		if ( 0 == IsStudentInList( (*iterOnlineStudent).studentID,  &m_StudentListInClass) )
		{
			StudentInfo_t* pStudent = new StudentInfo_t(*iterOnlineStudent);
			m_tagStudentList.push_back(pStudent);
		}
	}

	// 3.make name unique
	MakeStudentNameUnique();

	// 4.call draw tree funcs
	DrawCandidateStudentListView();
	DrawClassStudentListView();

	return ret;
}


/******************************************************************************
 * Function Name: EditWindow
 * Description  : To Edit the EditWindow
 * Date         : 2008/9/10
 * Parameter    :
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::EditWindow()
{
	{
		string strLogMsg("");
		strLogMsg.append("EditGroupWindow::EditWindow>>Start");
		CSESLog::WriteLine(strLogMsg);
	}
	//GtkTreeIter iter;
	list<tagStudent_t> tagStudent;
	//int ret = 0;
	gtk_window_set_title(GTK_WINDOW(m_gWindow), _("Edit Class"));
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Edit Class"), "SES");
	gtk_entry_set_text(GTK_ENTRY(m_gEntry), _(m_pClass->GetName().c_str()));

	InitListViews();

	m_isInitial = 1;

	return 0;
}
/******************************************************************************
 * Function Name: AddWindow
 * Description  : To Add the EditWindow
 * Date         : 2008/9/10
 * Parameter    :
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::AddWindow()
{
	CSESLog::WriteLine("EditGroupWindow::AddWindow>>Start");
	//GtkTreeIter iter;
	list<tagStudent_t> tagStudent;

	gtk_window_set_title(GTK_WINDOW(m_gWindow), _("Add Class"));
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Add Class"), "SES");
	gtk_entry_set_text(GTK_ENTRY(m_gEntry), "");

	//int ret = 0;

	InitListViews();

	m_isInitial = 1;
	CSESLog::WriteLine("EditGroupWindow::AddWindow<<End");
	return 0;
}
/******************************************************************************
 * Function Name: CreateLeftTreeView
 * Description  : To Create left treeview
 * Date         : 2008/9/10
 * Parameter    : parent		parent GtkWidget
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::CreateLeftTreeView(GtkWidget* parent)
{
	CSESLog::WriteLine("EditGroupWindow::CreateLeftTreeView>>Start");
	GtkCellRenderer *renderer = NULL;
	GtkTreeViewColumn *column = NULL;
	m_pLeftStore =  gtk_list_store_new(COLUMN_ITEM_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_INT);

	m_pLeftTreeView= gtk_tree_view_new_with_model(GTK_TREE_MODEL (m_pLeftStore));
	g_signal_connect(G_OBJECT(m_pLeftTreeView), "cursor-changed", G_CALLBACK(LeftCursorChanged), this);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(m_pLeftTreeView), FALSE);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW (m_pLeftTreeView), TRUE);
	//gtk_widget_set_size_request(m_pLeftTreeView, 200, 100);
	gtk_container_add(GTK_CONTAINER(parent), m_pLeftTreeView);

	GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(m_pLeftTreeView));
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);


	renderer = gtk_cell_renderer_pixbuf_new();
	column = gtk_tree_view_column_new_with_attributes("", renderer, "pixbuf", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (m_pLeftTreeView), column);

	renderer = gtk_cell_renderer_text_new();
	//g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	column = gtk_tree_view_column_new_with_attributes("", renderer, "text", 1,	NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (m_pLeftTreeView), column);

//	gtk_widget_show(m_pLeftTreeView);
	CSESLog::WriteLine("EditGroupWindow::CreateLeftTreeView<<End");
}
/******************************************************************************
 * Function Name: CreateLeftTreeView
 * Description  : To Create right treeview
 * Date         : 2008/9/10
 * Parameter    : parent		parent GtkWidget
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::CreateRightTreeView(GtkWidget* parent)
{
	CSESLog::WriteLine("EditGroupWindow::CreateRightTreeView>>Start");
	GtkCellRenderer *renderer = NULL;
	GtkTreeViewColumn *column = NULL;
	m_pRightStore =  gtk_list_store_new(COLUMN_ITEM_COLUMNS, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_INT);
	m_pRightTreeView= gtk_tree_view_new_with_model(GTK_TREE_MODEL (m_pRightStore));
	g_signal_connect(G_OBJECT(m_pRightTreeView), "cursor-changed", G_CALLBACK(RightCursorChanged), this);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(m_pRightTreeView), FALSE);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW (m_pRightTreeView), TRUE);
	//gtk_container_set_border_width(GTK_CONTAINER(m_pRightTreeView), 5);
	//gtk_widget_set_size_request(m_pRightTreeView, 160, 40);
	//gtk_container_add(GTK_CONTAINER(parent), m_pRightTreeView);
	gtk_container_add(GTK_CONTAINER(parent), m_pRightTreeView);

	GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(m_pRightTreeView));
	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);

	renderer = gtk_cell_renderer_pixbuf_new();
	column = gtk_tree_view_column_new_with_attributes("", renderer, "pixbuf", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (m_pRightTreeView), column);

	renderer = gtk_cell_renderer_text_new();
	//g_object_set(renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	column = gtk_tree_view_column_new_with_attributes("", renderer, "text", 1, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (m_pRightTreeView), column);
	//gtk_widget_show(m_pRightTreeView);
	CSESLog::WriteLine("EditGroupWindow::CreateRightTreeView<<End");
}
/******************************************************************************
 * Function Name: InitMiddleButtons
 * Description  : To Create the middle buttons
 * Date         : 2008/9/10
 * Parameter    : parent		parent GtkWidget
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::InitMiddleButtons (GtkWidget* parent)
{
	CSESLog::WriteLine("EditGroupWindow::InitMiddleButtons>>Start");
	GtkWidget* button_vbox = NULL;
	//GtkWidget* button = NULL;
	button_vbox = gtk_vbutton_box_new();
	gtk_container_set_border_width(GTK_CONTAINER (button_vbox), 1);
	gtk_box_set_spacing(GTK_BOX (button_vbox), 5);
	gtk_button_box_set_layout(GTK_BUTTON_BOX (button_vbox), GTK_BUTTONBOX_SPREAD);
	gtk_box_pack_start(GTK_BOX (parent), button_vbox, FALSE, FALSE, 0);
	//gtk_widget_show(button_vbox);

	m_gRightBtn = gtk_button_new_with_label("-->");
	g_signal_connect (G_OBJECT(m_gRightBtn), "clicked", G_CALLBACK (EditGroupWindow::MoveRight), this);
	gtk_widget_set_size_request(m_gRightBtn, EDIT_WINDOW_ARROW_BUTTTON_WIDTH, EDIT_WINDOW_ARROW_BUTTTON_HEIGHT);
	gtk_box_pack_start(GTK_BOX (button_vbox), m_gRightBtn, FALSE, FALSE, 5);
	gtk_widget_set_sensitive(m_gRightBtn, false);
	//gtk_widget_show(m_gRightBtn);

	m_gLeftBtn = gtk_button_new_with_label("<--");
	g_signal_connect (G_OBJECT(m_gLeftBtn), "clicked", G_CALLBACK (MoveLeft), this);
	gtk_widget_set_size_request(m_gLeftBtn, EDIT_WINDOW_ARROW_BUTTTON_WIDTH, EDIT_WINDOW_ARROW_BUTTTON_HEIGHT);
	gtk_box_pack_start(GTK_BOX (button_vbox), m_gLeftBtn, FALSE, FALSE, 5);
	gtk_widget_set_sensitive(m_gLeftBtn, false);
	//gtk_widget_show(m_gLeftBtn);
	CSESLog::WriteLine("EditGroupWindow::InitMiddleButtons<<End");
	return 0;
}
/******************************************************************************
 * Function Name: InitMiddleButtons
 * Description  : To Create the bottom buttons
 * Date         : 2008/9/10
 * Parameter    : parent		parent GtkWidget
 * Return Code  : OK 		return 0;
 * 				  ERROR		return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::InitBottomButtons (GtkWidget* parent)
{
	CSESLog::WriteLine("EditGroupWindow::InitBottomButtons>>Start");
	GtkWidget *hbox = NULL;
	GtkWidget *button = NULL;
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX (parent), hbox, FALSE, FALSE, 10);
	//gtk_widget_show(hbox);

	button = gtk_button_new_with_label(_("OK"));
	g_signal_connect (G_OBJECT(button), "clicked", G_CALLBACK(EditGroupWindow::OnOK), this);
	gtk_widget_set_tooltip_text(button, _("OK"));
	gtk_widget_set_size_request(button, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX (hbox), button, FALSE, FALSE, 10);
	//gtk_widget_show(button);

	button = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect (GTK_OBJECT(button), "clicked", G_CALLBACK (OnCancel), this);
	gtk_widget_set_tooltip_text(button, _("Cancel"));
	gtk_widget_set_size_request(button, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	gtk_box_pack_end(GTK_BOX (hbox), button, FALSE, FALSE, 0);
	//gtk_widget_show(button);
	CSESLog::WriteLine("EditGroupWindow::InitBottomButtons<<End");
	return 0;
}

/******************************************************************************
 * Function Name: Set_Entry
 * Description  : To set the entry text
 * Date         : 2008/9/10
 * Parameter    : text		the seted text
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::SetEntry (gchar* text)
{
	CSESLog::WriteLine("EditGroupWindow::Set_Entry>>Start");
	gtk_entry_set_text (GTK_ENTRY(m_gEntry), text);
	CSESLog::WriteLine("EditGroupWindow::Set_Entry<<End");
}

int EditGroupWindow::MoveTreeItems(GtkTreeView *srcTreeView, std::list<IPCAPI::tagStudent_t*>* pSrcTagStudentList, GtkTreeView *destTreeView, std::list<IPCAPI::tagStudent_t*>* pDestTagStudentList)
{
	CSESLog::WriteLine("EditGroupWindow::MoveTreeItems>>Start");

	int ret = 0;

	GtkTreeModel *srcModel = gtk_tree_view_get_model (GTK_TREE_VIEW(srcTreeView));
	GtkTreeModel *destModel = gtk_tree_view_get_model (GTK_TREE_VIEW(destTreeView));
	GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(srcTreeView));

	if(srcModel && destModel && selection)
	{
		GList* treePathList = gtk_tree_selection_get_selected_rows(selection, NULL);
		treePathList = g_list_reverse(treePathList);

		tagStudent_t *ptagStudent = NULL;
		GtkTreeIter srcIter, destIter;
		GtkTreePath* treepath = NULL;
		for(GList* tmpGlist = g_list_first(treePathList); NULL != tmpGlist; tmpGlist = g_list_next(tmpGlist))
		{
			treepath = (GtkTreePath*)(tmpGlist->data);
			gtk_tree_model_get_iter(srcModel, &srcIter, treepath);
			gtk_tree_model_get (srcModel, &srcIter, COLUMN_ITEM_STUDENT, &ptagStudent, -1);

			// Add the student to current class list.
			gtk_list_store_prepend(GTK_LIST_STORE (destModel), &destIter);
			gtk_list_store_set(GTK_LIST_STORE (destModel), &destIter, COLUMN_ITEM_ICON, m_pEditClassPic, COLUMN_ITEM_STUDENTNAME,
					ptagStudent->displayName.c_str(), COLUMN_ITEM_STUDENT, ptagStudent, -1);

			// move the data.
			pDestTagStudentList->push_front(ptagStudent);
			pSrcTagStudentList->remove(ptagStudent);

			gtk_list_store_remove(GTK_LIST_STORE (srcModel), &srcIter);

			if(!ret)
			{
				ret = 1;
			}
		}

		g_list_foreach (treePathList, (GFunc)gtk_tree_path_free, NULL);
		g_list_free (treePathList);
	}

	CSESLog::WriteLine("EditGroupWindow::MoveTreeItems<<End");

	return ret;
}

/******************************************************************************
 * Function Name: Move_Right
 * Description  : To move the tree items
 * Date         : 2008/9/10
 * Parameter    : gtkwidget				the treeview which triggers the event
 * 				  data					user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::MoveRight (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("EditGroupWindow::Move_Right>>Start");

	EditGroupWindow *ptr = (EditGroupWindow*)data;

	if(ptr->MoveTreeItems(GTK_TREE_VIEW(ptr->m_pLeftTreeView), &(ptr->m_tagStudentList), GTK_TREE_VIEW(ptr->m_pRightTreeView), &(ptr->m_StudentListInClass)))
	{
		gtk_widget_set_sensitive(ptr->m_gRightBtn, false);
	}

//
//	GtkTreeModel *left_model = gtk_tree_view_get_model (GTK_TREE_VIEW(ptr->m_pLeftTreeView));
//	GtkTreeModel *right_model = gtk_tree_view_get_model (GTK_TREE_VIEW(ptr->m_pRightTreeView));
//	GtkTreeIter left_iter, right_iter;
//	GtkTreeSelection *left_selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(ptr->m_pLeftTreeView));
//	if (gtk_tree_selection_get_selected (left_selection, &left_model, &left_iter))
//	{
//		// Get the student pointer from the candidate list.
//		tagStudent_t *ptagStudent = NULL;
//		gtk_tree_model_get (left_model, &left_iter, COLUMN_ITEM_STUDENT, &ptagStudent, -1);
//
//		// Add the student to current class list.
//		gtk_list_store_prepend(GTK_LIST_STORE (right_model), &right_iter);
//		gtk_list_store_set(GTK_LIST_STORE (right_model), &right_iter, COLUMN_ITEM_ICON, ptr->m_pEditClassPic, COLUMN_ITEM_STUDENTNAME,
//				ptagStudent->displayName.c_str(), COLUMN_ITEM_STUDENT,  ptagStudent, -1);
//
//
//		// move the data.
//		ptr->m_StudentListInClass.push_front(ptagStudent);
//		ptr->m_tagStudentList.remove(ptagStudent);
//
//		gtk_list_store_remove(GTK_LIST_STORE (left_model), &left_iter);
//
//		gtk_widget_set_sensitive(ptr->m_gRightBtn, false);
//	}
//
//

	CSESLog::WriteLine("EditGroupWindow::Move_Right<<End");
}
/******************************************************************************
 * Function Name: Move_Left
 * Description  : To move the tree items
 * Date         : 2008/9/10
 * Parameter    : gtkwidget				the treeview which triggers the event
 * 				  data					user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::MoveLeft (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("EditGroupWindow::Move_Left>>Start");

	EditGroupWindow *ptr = (EditGroupWindow*)data;

	if(ptr->MoveTreeItems(GTK_TREE_VIEW(ptr->m_pRightTreeView), &(ptr->m_StudentListInClass), GTK_TREE_VIEW(ptr->m_pLeftTreeView), &(ptr->m_tagStudentList)))
	{
		gtk_widget_set_sensitive(ptr->m_gLeftBtn, false);
	}

//	GtkTreeModel *right_model = gtk_tree_view_get_model (GTK_TREE_VIEW(ptr->m_pRightTreeView));
//	GtkTreeModel *left_model = gtk_tree_view_get_model (GTK_TREE_VIEW(ptr->m_pLeftTreeView));
//	GtkTreeIter left_iter, right_iter;
//	GtkTreeSelection *right_selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(ptr->m_pRightTreeView));
//	if (gtk_tree_selection_get_selected (right_selection, &right_model, &right_iter))
//	{
//		tagStudent_t* pStudentInfo = NULL;
//		gtk_tree_model_get (right_model, &right_iter, COLUMN_ITEM_STUDENT, &pStudentInfo, -1);
//
//		gtk_list_store_prepend(GTK_LIST_STORE (left_model), &left_iter);
//		gtk_list_store_set(GTK_LIST_STORE (left_model), &left_iter, COLUMN_ITEM_ICON, ptr->m_pEditClassPic, COLUMN_ITEM_STUDENTNAME,
//						pStudentInfo->displayName.c_str(), COLUMN_ITEM_STUDENT,  pStudentInfo, -1);
//
//		ptr->m_tagStudentList.push_front(pStudentInfo);
//		ptr->m_StudentListInClass.remove(pStudentInfo);
//		gtk_list_store_remove(GTK_LIST_STORE (right_model), &right_iter);
//
//		gtk_widget_set_sensitive(ptr->m_gLeftBtn, false);
//	}

	CSESLog::WriteLine("EditGroupWindow::Move_Left<<End");
}
/******************************************************************************
 * Function Name: OnOK
 * Description  : Ok event
 * Date         : 2008/9/10
 * Parameter    : gtkwidget				the button which triggers the event
 * 				  data					user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::OnOK (GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("EditGroupWindow::OnOK>>Start");
	EditGroupWindow *ptr = (EditGroupWindow*)data;

	//int result = 0;

	string className = gtk_entry_get_text(GTK_ENTRY(ptr->m_gEntry));
	string error;
	PublicFunc::TrimString(className);

	//Check Input Valid
	if ( CSESDataTools::IsInputValid(className, error) < 0 )
	{
		CMessageBox::Show(error, ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
		return;
	}


	// Check class Name repeat
	if ( 1 == ptr->m_iIsAdd )
	{
		//new class
		//if ( 1 == ptr->m_pClassGroup->IsClassExist(className) )
		if ( 1 == ptr->m_ClassGroup.IsClassExist(className) )
		{
			CMessageBox::Show(_("The class name has been existed!"), ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
			return;
		}
	}
	else
	{
		// edit class
		// if user changed class name, we need check this name does not exist in old class list.
		if (className != ptr->m_pClassOrg->GetName())
		{
			//if (1 == ptr->m_pClassGroup->IsClassExist(className) )
			if ( 1 == ptr->m_ClassGroup.IsClassExist(className) )
			{
				CMessageBox::Show(_("The class name has been existed!"), ptr->m_gWindow, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK);
				return;
			}
		}
	}

	// update student in class
	std::list<CStudentInfoData*>* pStudentList = new std::list<CStudentInfoData*>();

	ptr->ConvertStudentInfo2CStudentInfoData( &(ptr->m_StudentListInClass), pStudentList);
	ptr->m_pClass->SetPStudentsInfoList(pStudentList);

	ptr->m_iResult = BUTTON_CLICK_IS_OK;
	ptr->m_pClass->SetName(className);
	gtk_widget_destroy(ptr->m_gWindow);


	CSESLog::WriteLine("EditGroupWindow::OnOK<<End");
}

/******************************************************************************
 * Function Name: OnCancel
 * Description  : Cancel event
 * Date         : 2008/9/10
 * Parameter    : gtkwidget				the button which triggers the event
 * 				  data					user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void EditGroupWindow::OnCancel(GtkWidget* gtkwidget, gpointer data)
{
	CSESLog::WriteLine("EditGroupWindow::OnCancel>>Start");
	EditGroupWindow* ptr = (EditGroupWindow*)data;

	// Dump latest data.
	ptr->DumpGUIClassInfo();


	if(1 == ptr->IsDataDirty())
	{
		//GtkWidget *outDialog = NULL;
//		outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//						   GTK_DIALOG_MODAL,
//						   GTK_MESSAGE_QUESTION,
//						   GTK_BUTTONS_YES_NO,
//						   _("Do you want to save the data?"));
//		gtk_window_set_title(GTK_WINDOW(outDialog), "Information");
	    string message(_("Do you want to save the data?"));
	    int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
		if(GTK_RESPONSE_YES == result)
		{
		    OnOK(gtkwidget, data);

		}
		else
		{
			ptr->m_iResult = BUTTON_CLICK_IS_CANCEL;

			gtk_widget_destroy(ptr->m_gWindow);
		}

        //gtk_widget_destroy(outDialog);
	}
	else
	{
		gtk_widget_destroy(ptr->m_gWindow);
	}

	CSESLog::WriteLine("EditGroupWindow::OnCancel<<End");
}

bool EditGroupWindow::OnWindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	CSESLog::WriteLine("EditGroupWindow::OnWindowClosed>>Start");
	EditGroupWindow* ptr = (EditGroupWindow*)data;
	int ret = true;

	// check data dirty
	// Dump latest data.
	ptr->DumpGUIClassInfo();


	if(1 == ptr->IsDataDirty())
	{
//		GtkWidget *outDialog = NULL;
//		outDialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//						   GTK_DIALOG_MODAL,
//						   GTK_MESSAGE_QUESTION,
//						   GTK_BUTTONS_YES_NO,
//						   _("Do you want to save the data?"));
	    string message(_("Do you want to save the data?"));
	    int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
		//gtk_window_set_title(GTK_WINDOW(outDialog), "Information");
		if(GTK_RESPONSE_YES == result)
		{

		    OnOK(gtkwidget, data);


		    //OnOK has aready destroyed window, set ret true in all conditions;
		    ret = true;

		}
		else
		{
			ptr->m_iResult = BUTTON_CLICK_IS_CANCEL;
	        ret = false;

		}

		//gtk_widget_destroy (outDialog);
	}
	else
	{
		ret = false;
	}

	return ret;
}

/******************************************************************************
 * Function Name: Get_Window
 * Description  : Get the EditGroupWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : GtkWidget*
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
GtkWidget* EditGroupWindow::Get_Window()
{
	return m_gWindow;
}

/******************************************************************************
 * Function Name: IsAddGroup
 * Description  : Justify whether the class is added or edited
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : Added		return 1;
 * 				  Edited	return 0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::IsAddGroup()
{
	return m_iIsAdd;
}
/******************************************************************************
 * Function Name: GetResult
 * Description  : Justify whether Ok button is clicked or Cancel button is clicked
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK		return 1;
 * 				  Cancel	return 0;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
int EditGroupWindow::GetResult()
{
	return m_iResult;
}
/******************************************************************************
 * Function Name: GetSelectedClass
 * Description  : Get selected class
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : CClassDef*
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
CClassDef* EditGroupWindow::GetSelectedClass()
{
	return m_pClass;
}
/******************************************************************************
 * Function Name: GetSelectedOriRefClass
 * Description  : Get original selected class
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : CClassDef*
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
//CClassDef* EditGroupWindow::GetSelectedOriRefClass()
//{
//	return m_pClassOriRef;
//}

void EditGroupWindow::LeftCursorChanged(GtkTreeView* leftTreeView, gpointer data)
{
	EditGroupWindow* ptr = (EditGroupWindow*)data;
	if(NULL == leftTreeView)
	{
		ptr->m_IsLeftTreeViewSelected = 0;
	}
	else
	{
		GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(ptr->m_pLeftTreeView));
		gint selectedNum = gtk_tree_selection_count_selected_rows(selection);
		if (selectedNum > 0)
		{
			gtk_widget_set_sensitive(ptr->m_gRightBtn, true);
			ptr->m_IsLeftTreeViewSelected = 1;
		}
		else
		{
			gtk_widget_set_sensitive(ptr->m_gRightBtn, false);
			ptr->m_IsLeftTreeViewSelected = 0;
		}

//		GtkTreeIter iter;
//		GtkTreeModel* model = gtk_tree_view_get_model (GTK_TREE_VIEW(ptr->m_pLeftTreeView));
//		GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(ptr->m_pLeftTreeView));
//		if (gtk_tree_selection_get_selected (selection, &model, &iter))
//		{
//			gtk_widget_set_sensitive(ptr->m_gRightBtn, true);
//			ptr->m_IsLeftTreeViewSelected = 1;
//		}
//		else
//		{
//			gtk_widget_set_sensitive(ptr->m_gRightBtn, false);
//			ptr->m_IsLeftTreeViewSelected = 0;
//		}
	}

}
void EditGroupWindow::RightCursorChanged(GtkTreeView* rightTreeView, gpointer data)
{
	EditGroupWindow* ptr = (EditGroupWindow*)data;
	if(NULL == rightTreeView)
	{
		ptr->m_IsRightTreeViewSelected = 0;
	}
	else
	{
		GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(ptr->m_pRightTreeView));
		gint selectedNum = gtk_tree_selection_count_selected_rows(selection);
		if (selectedNum > 0)
		{
			gtk_widget_set_sensitive(ptr->m_gLeftBtn, true);
			ptr->m_IsRightTreeViewSelected = 1;
		}
		else
		{
			gtk_widget_set_sensitive(ptr->m_gLeftBtn, false);
			ptr->m_IsRightTreeViewSelected = 0;
		}

//		GtkTreeIter iter;
//		GtkTreeModel* model = gtk_tree_view_get_model (GTK_TREE_VIEW(ptr->m_pRightTreeView));
//		GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(ptr->m_pRightTreeView));
//		if (gtk_tree_selection_get_selected (selection, &model, &iter))
//		{
//			gtk_widget_set_sensitive(ptr->m_gLeftBtn, true);
//			ptr->m_IsRightTreeViewSelected = 1;
//		}
//		else
//		{
//			gtk_widget_set_sensitive(ptr->m_gLeftBtn, false);
//			ptr->m_IsRightTreeViewSelected = 0;
//		}
	}

}
void EditGroupWindow::NewStudentMessage(int MessageID, tagStudent_t* student, CClassDef* selectedClass)
{
	CClassDef* newClass(selectedClass);
	if(NEW_STUDENT_SELECT_ONE == MessageID)
	{
		if(m_pClass->GetName() == newClass->GetName())
		{
			CStudentInfoData* newStudent = new CStudentInfoData();
			newStudent->SetStudentID(student->studentID);
			newStudent->SetStudentName(student->username);
			m_pClass->GetPStudentsInfoList()->push_back(newStudent);
			GtkTreeIter rightIter;
			GtkTreeModel *rightModel = gtk_tree_view_get_model (GTK_TREE_VIEW(m_pRightTreeView));
			gtk_list_store_append(GTK_LIST_STORE (rightModel), &rightIter);
			gtk_list_store_set(GTK_LIST_STORE (rightModel), &rightIter, COLUMN_ITEM_ICON, m_pEditClassPic,
										   COLUMN_ITEM_STUDENTNAME, newStudent->GetStudentName().c_str(),
										   COLUMN_ITEM_STUDENT, newStudent, -1);
		}
	}
}

//
void EditGroupWindow::UpdateStudentListOfCurrentClass(int MessageID, std::string ClassName, const IPCAPI::StudentInfo_t* pStudent)
{
	//if (ClassName.size() == 0 || NULL == pStudent)
	if (ClassName.size() == 0)
	{
		return;
	}

	// TODO: jinxin the new added student only exist in right tree.

	if (NEW_STUDENT_SELECT_ONE == MessageID && m_pClass->GetName() == ClassName)
	{
//		CStudentInfoData* newStudent = new CStudentInfoData();
//		newStudent->SetStudentID(pStudent->studentID);
//		newStudent->SetStudentName(pStudent->username);
//
//		m_pClass->GetPStudentsInfoList()->push_back(newStudent);

		//
		StudentInfo_t* pNewStudent = new StudentInfo_t(*pStudent);

		m_StudentListInClass.push_back(pNewStudent);

		// filter student in candidate list.
		if ( IsStudentInList(pNewStudent->studentID, &m_tagStudentList) )
		{
			RemoveCandidateStudent(pNewStudent->studentID);
		}

		// make unique name
		MakeStudentNameUnique();

//		GtkTreeIter rightIter;
//		GtkTreeModel *rightModel = gtk_tree_view_get_model (GTK_TREE_VIEW(m_pRightTreeView));
//		gtk_list_store_append(GTK_LIST_STORE (rightModel), &rightIter);
//		gtk_list_store_set(GTK_LIST_STORE (rightModel),
//						   &rightIter,
//						   COLUMN_ITEM_ICON, m_pEditClassPic,
//						   //COLUMN_ITEM_STUDENTNAME, newStudent->GetStudentName().c_str(),
//						   COLUMN_ITEM_STUDENTNAME, pNewStudent->displayName.c_str(),
//						   COLUMN_ITEM_STUDENT, pNewStudent,
//						   -1);

		DrawClassStudentListView();
		DrawCandidateStudentListView();

	}
}

void EditGroupWindow::UpdateStudentInfo(std::string ClassName, const IPCAPI::StudentInfo_t* pStudent)
{
	// 0. check args.
	if (ClassName.size() == 0 || NULL == pStudent)
	{
		return;
	}

	 if ( m_pClass->GetName() == ClassName )
	 {
		 // update the exist
		 UpdateStudentInfoInList(&m_tagStudentList, pStudent);
		 UpdateStudentInfoInList(&m_StudentListInClass, pStudent);

		 MakeStudentNameUnique();

		 DrawClassStudentListView();
		 DrawCandidateStudentListView();
	 }

}

int EditGroupWindow::UpdateStudentInfoInList(std::list<IPCAPI::StudentInfo_t*>* pStudentList, const IPCAPI::StudentInfo_t* pStudent)
{
	if (NULL == pStudentList || NULL == pStudent)
	{
		return -1;
	}

	int ret = 0;

	std::list<IPCAPI::StudentInfo_t*>::iterator iter;
	for (iter = pStudentList->begin(); iter != pStudentList->end(); ++iter)
	{
		if ( (*iter)->studentID == pStudent->studentID )
		{
			(*iter)->username = pStudent->username;

			ret = 1;
		}
	}

	return ret;
}


int EditGroupWindow::RemoveCandidateStudent(std::string studentID)
{
	// remove from gui

	//GtkTreeModel *right_model = gtk_tree_view_get_model (GTK_TREE_VIEW(m_pRightTreeView));
	GtkTreeModel *left_model = gtk_tree_view_get_model (GTK_TREE_VIEW(m_pLeftTreeView));
	GtkTreeIter iter;
	gboolean isValid = gtk_tree_model_get_iter_first(left_model, &iter);
	while(isValid)
	{
		StudentInfo_t* pStudent = NULL;
		gtk_tree_model_get(left_model, &iter, COLUMN_ITEM_STUDENT, &pStudent, -1);
		if(studentID == pStudent->studentID)
		{
			break;
		}
		isValid = gtk_tree_model_iter_next (left_model, &iter);
	}

	if (true == isValid)
	{
		gtk_list_store_remove(GTK_LIST_STORE (left_model), &iter);
	}


	// remove from list
	std::list<IPCAPI::tagStudent_t*>::iterator iter2;
	for (iter2 = m_tagStudentList.begin(); iter2 != m_tagStudentList.end(); ++iter2)
	{
		if ( (*iter2)->studentID == studentID )
		{
			if ( NULL != (*iter2))
			{
				delete *iter2;
				(*iter2) = NULL;
			}
			m_tagStudentList.erase(iter2);
			break;
		}
	}

	return 0;
}

int EditGroupWindow::RemoveClassStudent(std::string studentID)
{
	// remove from gui

	GtkTreeModel *right_model = gtk_tree_view_get_model (GTK_TREE_VIEW(m_pRightTreeView));
	//GtkTreeModel *left_model = gtk_tree_view_get_model (GTK_TREE_VIEW(m_pLeftTreeView));
	GtkTreeIter iter;
	gboolean isValid = gtk_tree_model_get_iter_first(right_model, &iter);
	while(isValid)
	{
		StudentInfo_t* pStudent = NULL;
		gtk_tree_model_get(right_model, &iter, COLUMN_ITEM_STUDENT, &pStudent, -1);
		if(studentID == pStudent->studentID)
		{
			break;
		}
		isValid = gtk_tree_model_iter_next (right_model, &iter);
	}

	if (true == isValid)
	{
		gtk_list_store_remove(GTK_LIST_STORE (right_model), &iter);
	}


	// remove from list
	std::list<IPCAPI::tagStudent_t*>::iterator iter2;
	for (iter2 = m_StudentListInClass.begin(); iter2 != m_StudentListInClass.end(); ++iter2)
	{
		if ( (*iter2)->studentID == studentID )
		{
			if ( NULL != (*iter2))
			{
				delete *iter2;
				(*iter2) = NULL;
			}
			m_StudentListInClass.erase(iter2);
			break;
		}
	}

	return 0;
}


void EditGroupWindow::UpdateStudentListInCandidateList(int MessageID, std::string ClassName, const IPCAPI::StudentInfo_t* pStudent)
{
	if (ClassName.size() == 0 || NULL == pStudent)
	{
		return;
	}

	if (NEW_STUDENT_SELECT_ONE == MessageID && m_pClass->GetName() == ClassName)
	{
		ReLoadCandidateList();
	}
}

void EditGroupWindow::LoadOnlineStudent()
{

}

void EditGroupWindow::ReleaseStudentList()
{
	ReleaseCandidateStudentList();

	ReleaseClassStudentList();
}

void EditGroupWindow::ReleaseCandidateStudentList()
{
	std::list<IPCAPI::tagStudent_t*>::iterator iter;
	for (iter = m_tagStudentList.begin(); iter != m_tagStudentList.end(); ++iter)
	{
		if (NULL != *iter)
		{
			delete *iter;
			*iter = NULL;
		}
	}
	m_tagStudentList.clear();

}

void EditGroupWindow::ReleaseClassStudentList()
{
	std::list<IPCAPI::tagStudent_t*>::iterator iter;
	for (iter = m_StudentListInClass.begin(); iter != m_StudentListInClass.end(); ++iter)
	{
		if (NULL != *iter)
		{
			delete *iter;
			*iter = NULL;
		}
	}
	m_StudentListInClass.clear();
}

void EditGroupWindow::DrawCandidateStudentListView()
{
	gtk_list_store_clear(m_pLeftStore);

	GtkTreeIter IterTree;

	std::list<IPCAPI::StudentInfo_t*>::iterator iterStudent;

	for (iterStudent = m_tagStudentList.begin();iterStudent!= m_tagStudentList.end(); ++iterStudent)
	{
		gtk_list_store_append(m_pLeftStore, &IterTree);
		gtk_list_store_set(m_pLeftStore, &IterTree,
				COLUMN_ITEM_ICON, m_pEditClassPic,
				COLUMN_ITEM_STUDENTNAME, (*iterStudent)->displayName.c_str(),
				COLUMN_ITEM_STUDENT, (*iterStudent),
				-1);
	}
}

void EditGroupWindow::DrawClassStudentListView()
{
	gtk_list_store_clear(m_pRightStore);

	GtkTreeIter IterTree;

	std::list<IPCAPI::StudentInfo_t*>::iterator iterStudent;

	for (iterStudent = m_StudentListInClass.begin();iterStudent!= m_StudentListInClass.end(); ++iterStudent)
	{
		gtk_list_store_append(m_pRightStore, &IterTree);
		gtk_list_store_set(m_pRightStore, &IterTree,
				COLUMN_ITEM_ICON, m_pEditClassPic,
				COLUMN_ITEM_STUDENTNAME, (*iterStudent)->displayName.c_str(),
				COLUMN_ITEM_STUDENT, (*iterStudent),
				-1);
	}
}



void EditGroupWindow::ReLoadCandidateList()
{
	gtk_list_store_clear(m_pLeftStore);

	ReleaseCandidateStudentList();

	std::list<IPCAPI::StudentInfo_t> studentList;

	int ret = 0;
	m_pTeacherAPI->GetStudentList(studentList, ret);

	list<tagStudent_t>::iterator iterStudent;
	//GtkTreeIter IterTree;

	for (iterStudent = studentList.begin();iterStudent!= studentList.end(); ++iterStudent)
	{
		if ( 0 == IsStudentInList( (*iterStudent).studentID,  &m_StudentListInClass) )
		{
			StudentInfo_t* pStudent = new StudentInfo_t(*iterStudent);
			m_tagStudentList.push_back(pStudent);
		}
	}

	MakeStudentNameUnique();

	DrawCandidateStudentListView();
	DrawClassStudentListView();

}

int EditGroupWindow::IsStudentInList(std::string studentID, const std::list<IPCAPI::tagStudent_t*>* pStudentList)
{
	int ret = 0;
	if (studentID.size() == 0 || NULL == pStudentList)
	{
		return 0;
	}

	std::list<IPCAPI::tagStudent_t*>::const_iterator iter;
	for (iter = pStudentList->begin(); iter != pStudentList->end(); ++iter)
	{
		if (studentID == (*iter)->studentID)
		{
			ret = 1;
			break;
		}
	}

	return ret;
}

void EditGroupWindow::RefreshCandidateList()
{
	GtkTreeIter iter;
	StudentInfo_t* pStudent = NULL;

	GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_pLeftTreeView));

	gboolean isValid = FALSE;

	isValid = gtk_tree_model_get_iter_first (model, &iter);
	while(isValid)
	{
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_STUDENT, &pStudent, -1);
		if (NULL != pStudent)
		{
			gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_STUDENTNAME, (pStudent->displayName).c_str(), -1);
		}

		isValid = gtk_tree_model_iter_next (model, &iter);
	}
}

void EditGroupWindow::MakeStudentNameUnique()
{
	// 0.make whole list
	std::list<IPCAPI::StudentInfo_t*> wholeList(m_tagStudentList.size() + m_StudentListInClass.size());

	copy(m_tagStudentList.begin(), m_tagStudentList.end(), wholeList.begin());

	std::list<IPCAPI::StudentInfo_t*>::iterator iter = wholeList.begin();

	advance(iter, m_tagStudentList.size());

	copy(m_StudentListInClass.begin(), m_StudentListInClass.end(), iter);

	// 1. make students with same name add id
	std::list<IPCAPI::StudentInfo_t*>::iterator iter2;
	std::list<IPCAPI::StudentInfo_t*>::iterator iterInternalBegin;

	for (iter = wholeList.begin(); iter != wholeList.end(); ++iter)
	{
		(*iter)->displayName = (*iter)->username;
	}

	// 2. check same namee
	for (iter = wholeList.begin(); iter != wholeList.end(); ++iter)
	{
		iterInternalBegin = iter;
		iterInternalBegin++;
		for (iter2 = iterInternalBegin; iter2 != wholeList.end(); ++iter2)
		{
			if ( (*iter)->username == (*iter2)->username )
			{
				(*iter)->displayName  = (*iter)->username + "-" + (*iter)->studentID;
				(*iter2)->displayName = (*iter2)->username + "-" + (*iter2)->studentID;
			}
		}
	}

}

void EditGroupWindow::FilterStudentInClass()
{

}

bool EditGroupWindow::IsTreeViewNull(GtkWidget* treeview)
{
	GtkTreeModel* model = gtk_tree_view_get_model (GTK_TREE_VIEW(treeview));
	GtkTreeIter iter;
	gboolean isInvalid = gtk_tree_model_get_iter_first(GTK_TREE_MODEL(model), &iter);
	return isInvalid;
}

bool EditGroupWindow::IsButtonSensitive(GtkWidget*)
{
	return true;
}

void EditGroupWindow::NameEntryChanged(GtkEntry* entry, gpointer data)
{
	EditGroupWindow* ptr = (EditGroupWindow*)data;
	if(1 == ptr->m_isInitial)
	{
//		ptr->m_isDataChanged = 1;
	}
}

void EditGroupWindow::ReDrawTreeView()
{
	GtkTreeIter iter;
	GtkTreeModel* model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_pLeftTreeView));
	gboolean isValid = FALSE;

	//TODO m_tagStudentList instead temp list
	list<tagStudent_t*> tagStudentList;
	isValid = gtk_tree_model_get_iter_first (model, &iter);
	tagStudent_t* ptagStudent_t = NULL;
	while(isValid)
	{
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_STUDENT, &ptagStudent_t, -1);
		tagStudentList.push_back(ptagStudent_t);
		isValid = gtk_tree_model_iter_next (model, &iter);
	}


	isValid = gtk_tree_model_get_iter_first (model, &iter);
	while(isValid)
	{
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_STUDENT, &ptagStudent_t, -1);
		list<tagStudent_t*>::iterator studentIter;
		for(studentIter = tagStudentList.begin(); studentIter != tagStudentList.end(); ++studentIter)
		{
			if(((*studentIter)->studentID != ptagStudent_t->studentID) && ((*studentIter)->username == ptagStudent_t->username))
			{
				string name("");
				name.append(ptagStudent_t->username);
				name.append("\n");
				name.append(ptagStudent_t->studentID);
				gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_STUDENTNAME, name.c_str(), -1);

				break;
			}
//			else
//			{
//				gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_STUDENTNAME, ((*studentIter)->username).c_str(), -1);
//			}
		}
		isValid = gtk_tree_model_iter_next (model, &iter);
	}
	CStudentInfoData* pRightStudent;
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(m_pRightTreeView));
	isValid = FALSE;
	isValid = gtk_tree_model_get_iter_first (model, &iter);
	while(isValid)
	{
		gtk_tree_model_get (model, &iter, COLUMN_ITEM_STUDENT, &pRightStudent, -1);
		list<CStudentInfoData*>::iterator studentCIter;
		for(studentCIter = m_pClass->GetPStudentsInfoList()->begin(); studentCIter != m_pClass->GetPStudentsInfoList()->end(); ++studentCIter)
		{
			if(((*studentCIter)->GetStudentID() != pRightStudent->GetStudentID())&&((*studentCIter)->GetStudentName() == pRightStudent->GetStudentName()))
			{
				string name("");
				name.append(pRightStudent->GetStudentName());
				name.append("\n");
				name.append(pRightStudent->GetStudentID());
				gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_STUDENTNAME, name.c_str(), -1);

				break;
			}
//			else
//			{
//				gtk_list_store_set(GTK_LIST_STORE(model), &iter, COLUMN_ITEM_STUDENTNAME, (*studentCIter)->GetStudentName().c_str(), -1);
//			}
		}
		isValid = gtk_tree_model_iter_next (model, &iter);
	}
}

int EditGroupWindow::ConvertStudentInfo2CStudentInfoData(
		std::list<IPCAPI::StudentInfo_t*>* pStudent,
		std::list<LibSESData::CStudentInfoData*>* pCStudentInfoData)
{
	int ret = 0;

	if (NULL == pStudent || NULL == pCStudentInfoData)
	{
		return -1;
	}

	// clear
	std::list<LibSESData::CStudentInfoData*>::iterator iter;
	for (iter = pCStudentInfoData->begin(); iter != pCStudentInfoData->end(); ++iter)
	{
		if ( NULL != (*iter) )
		{
			delete (*iter);
			(*iter) = NULL;
		}
	}
	pCStudentInfoData->clear();

	// dump

	std::list<IPCAPI::StudentInfo_t*>::iterator iter2;
	for (iter2 = pStudent->begin(); iter2 != pStudent->end(); ++iter2)
	{
		if ( NULL != (*iter2) )
		{
			CStudentInfoData* pObj = new CStudentInfoData();
			pObj->SetStudentID( (*iter2)->studentID );
			pObj->SetStudentName( (*iter2)->username );

			pCStudentInfoData->push_back(pObj);

			ret++;
		}
	}

	return ret;
}


int EditGroupWindow::IsDataDirty()
{
	if (NULL == m_pClass || NULL == m_pClassOrg )
	{
		g_assert(0);
		return -1;
	}
	if ( 0 == m_pClass->IsEqual(m_pClassOrg) )
	{
		return 1;
	}
	else
	{
		return 0;
	}
}


int EditGroupWindow::DumpGUIClassInfo()
{
	string className = gtk_entry_get_text(GTK_ENTRY(m_gEntry));
	PublicFunc::TrimString(className);
	m_pClass->SetName(className);

	std::list<CStudentInfoData*>* pStudentList = new std::list<CStudentInfoData*>();
	ConvertStudentInfo2CStudentInfoData( &m_StudentListInClass, pStudentList);
	m_pClass->SetPStudentsInfoList(pStudentList);

	return 0;
}


