/******************************************************************************
 * File Name    : main.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : main function
 ******************************************************************************/
#include "ShellControllerApp.h"
#include "libsesdata.h"
#include <libgnome/libgnome.h>
#include <gnome-ui-init.h>


using namespace LibSESData;
using namespace ShellController;

int main (int argc, char* argv[])
{
	CSESLog::WriteLine("ShellController >>Start", CSESLog::TRACE, "ShellController");
	std::string lockPath = SES_BIN_SHELLCONTROLLER_LOCKFILE;
	if(CSESDataTools::GetLock(lockPath))
    {
		ShellControllerApp app;
		bindtextdomain (SES_BIN_SHELL_CONTROLLER.c_str(), LOCALEDIR.c_str());
		bind_textdomain_codeset (SES_BIN_SHELL_CONTROLLER.c_str(), "UTF-8");
		textdomain (SES_BIN_SHELL_CONTROLLER.c_str());
		gnome_program_init("ShellController", "1.0", LIBGNOMEUI_MODULE, argc, argv, NULL, NULL, NULL);
		if ( app.Init() )
		{
			app.Run();
		}
		app.Release();
    }
    CSESLog::WriteLine("ShellController <<End", CSESLog::TRACE, "ShellController");
    return 0;
}

