/*
 * DeployPRGMRequ.cpp
 *
 *  Created on: 2008-9-16
 *      Author: stanley
 */
#include "SESOperator.h"
#include "StudentMgr.h"
#include "TabNavigationData.h"
#include "LibSESDataCommon.h"
#include "CSESLog.h"
#include "TeacherInfoData.h"
#include "TeacherPolicySettingData.h"
using namespace std;
using namespace LibSESData;
CDeployPRGMListRequ::CDeployPRGMListRequ()
{
	pStudentMgr = CStudentMgr::instance();
}
CDeployPRGMListRequ::~CDeployPRGMListRequ()
{
	pStudentMgr = NULL;
}

bool CDeployPRGMListRequ::SendRequ(CIntfData& myData)
{
	bool bResult = true;
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,
			"COperationManager::work Get Msg from dbus!");

	std::list<std::string> studentList;
	myData.ParaXmlDoc.getListPara(studentList);

	std::string tabNavPolicyXML;
	LibSESData::CTabNavigationData tabnavData;
	tabnavData.LoadFromFile(LibSESData::CONFIG_FILE_DIR
			+ LibSESData::TAB_NAVIGATION);
	tabnavData.Save2String(tabNavPolicyXML);

	myData.GetOperationID(OperationID);

	std::string schedulePolicyXML;
	myData.ParaXmlDoc.getString("schedulePolicyXML", schedulePolicyXML);

	bool bEffective = (true != tabNavPolicyXML.empty()) || (true != schedulePolicyXML.empty());
	if ((0 != studentList.size()) && bEffective)
	{

		string teacherInfoFile = CONFIG_FILE_DIR + TEACHER_INFO;
		string ControllerName;
		LibSESData::CTeacherInfoData* pTeacher = new LibSESData::CTeacherInfoData();
		if (0 == pTeacher->LoadFromFile(teacherInfoFile))
		{
			ControllerName = pTeacher->GetTeacherName();
			delete pTeacher;
		}else
		{
			delete pTeacher;
			return false;
		}

		string teacherpolicyupdatedatapath = CONFIG_FILE_DIR
				+ TEACHERPOLICYSETTING;
		CTeacherPolicySettingData teacherpolicyupdatedata;
		teacherpolicyupdatedata.LoadFromFile(teacherpolicyupdatedatapath);

		CIntfData cIntfData;
		cIntfData.SetMessage(TEACHER_DEPLOYTABNAVPOLICY);
		cIntfData.ParaXmlDoc.setString("tabNavPolicyXML", tabNavPolicyXML);
		cIntfData.ParaXmlDoc.setString("schedulePolicyXML", schedulePolicyXML);
		cIntfData.SetOperationID(OperationID);
		list<std::string>::iterator ir;
		list<std::string>::iterator para_begin = studentList.begin();
		list<std::string>::iterator para_end = studentList.end();

		for (ir = para_begin; ir != para_end; ir++)
		{
			cIntfData.SetStudentID((*ir));
			m_StudentIDList.push_back((*ir));
			pStudentMgr->Send(cIntfData);

			teacherpolicyupdatedata.UpdateInfo(*ir, ControllerName);
		}

		teacherpolicyupdatedata.Save2File(teacherpolicyupdatedatapath);
	}
	else
	{
		Disconnect("");
		bResult = false;
	}

	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYTABNAV,
			"COperationManager::work Deploy finished!");
	return bResult;
}

bool CDeployPRGMListRequ::RecvResp(CIntfData& myData)
{
	std::string studentID;
	myData.GetStudentID(studentID);
	return filter(studentID);
}

int CDeployPRGMListRequ::GetOperationID()
{
	return OperationID;

}
bool CDeployPRGMListRequ::filter(std::string studentID)
{
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_DEPLOYSCHDULE, "CDeployPRGMListRequ::filter--Get Reply from network, StudentID = "+ studentID);
	if(true == studentID.empty())
	{
		return false;
	}
	list<std::string>::iterator ir;
	list<std::string>::iterator para_begin = m_StudentIDList.begin();
	list<std::string>::iterator para_end = m_StudentIDList.end();

	for (ir = para_begin; ir != para_end; ir++)
	{
		if(0 == (*ir).compare(studentID))
		{
			m_StudentIDList.erase(ir);
			break;
		}
	}
	return m_StudentIDList.empty();
}
bool CDeployPRGMListRequ::Disconnect(std::string studentID)
{
	CSESLog::WriteLine("CDeployPRGMListRequ::Disconnect");
//	CIntfData* myData = new CIntfData();
//	myData->SetMessage(TEACHER_DEPLOYTABNAVPOLICYCALLBACK);
//	myData->SetStudentID(studentID);
//	myData->SetResult(SES_API_SUCCESS);
//	myData->ParaXmlDoc.setString("bSuccess", METHOD_FALSE);
//	TeacherDaemonAPI->SendMsg(myData);
//	delete myData;
	TeacherDaemonAPI->DeployTabNavPolicyCallBack(studentID, false);
	return filter(studentID);
}

bool CDeployPRGMListRequ::CancelOperation(int OID)
{
	CSESLog::WriteLine("CDeployPRGMListRequ::CancelOperation");
//	CIntfData* myData = new CIntfData();
//	myData->SetMessage(TEACHER_DEPLOYTABNAVPOLICYCALLBACK);
//	myData->SetStudentID("");
//	myData->ParaXmlDoc.setString("bSuccess", METHOD_FALSE);
//	myData->SetResult(SES_API_FAILURE);
//	TeacherDaemonAPI->SendMsg(myData);
//	delete myData;
	TeacherDaemonAPI->DeployTabNavPolicyCallBack("", false);
	return true;
}
