///////////////////////////////////////////////////////////
//  RequBase.cpp
//  Implementation of the Class RequBase
//  Created on:      10-九月-2008 9:44:09
//  Original author: sunxy
///////////////////////////////////////////////////////////

#include "RequBase.h"
#include "StudentMgr.h"
#include <IntfData.h>
#include "TeacherPolicySettingData.h"
#include "LibSESDataCommon.h"
#include "TeacherInfoData.h"
#include "TimeStamp.h"
#include <time.h>
using namespace std;

#define TIMEOUT_SECOND 300

RequBase::RequBase()
{
	pStudentMgr = CStudentMgr::instance();
	m_StudentIDList.clear();
	time(&m_TimeOutPoint);
	m_TimeOutPoint += TIMEOUT_SECOND;
}

RequBase::~RequBase()
{
	pStudentMgr = NULL;
}

bool RequBase::CheckTimeOut()
{

	return false;
}

bool RequBase::RecvResp(CIntfData& myData)
{
	return false;
}

bool RequBase::SendRequ(CIntfData& myData)
{
	return false;
}

int RequBase::GetOperationID()
{
	return false;
}
bool RequBase::Disconnect(std::string studentID)
{
	return true;
}
/*void RequBase::GetSentMessage(IPCAPI::CIntfData& myData)
{
	if(NULL != sentMsg)
	{
		myData = *sentMsg;
	}
}*/
bool RequBase::isSameStudent(std::string studentID)
{
	list<std::string>::iterator ir;
	list<std::string>::iterator para_begin = m_StudentIDList.begin();
	list<std::string>::iterator para_end = m_StudentIDList.end();

	for (ir = para_begin; ir != para_end; ir++)
	{
		if(0 == (*ir).compare(studentID)){
			return true;
		}
	}
	return false;
}
void RequBase::SetIPCTeacherDaemonAPI(IPCAPI::IPCTeacherDaemonAPI* TeacherDaemonAPI)
{
	this->TeacherDaemonAPI = TeacherDaemonAPI;
}

void RequBase::UpdateTeacherPolicyData(std::string StudentID)
{
	string teacherpolicyupdatedatapath = LibSESData::CONFIG_FILE_DIR
			+ LibSESData::TEACHERPOLICYSETTING;
	LibSESData::CTeacherPolicySettingData teacherpolicyupdatedata;
	teacherpolicyupdatedata.LoadFromFile(teacherpolicyupdatedatapath);

	LibSESData::CTeacherInfoData data;
	data.LoadFromFile( LibSESData::CONFIG_FILE_DIR + LibSESData::TEACHER_INFO);

	teacherpolicyupdatedata.UpdateInfo(StudentID,data.GetTeacherName());

	teacherpolicyupdatedata.Save2File(teacherpolicyupdatedatapath);
}

long int RequBase::GetTimeOutPoint()
{
	return this->m_TimeOutPoint;
}

void RequBase::setTimeOutPoint(long int TimeOutPoint)
{
	this->m_TimeOutPoint = TimeOutPoint;
}

