/*
 * This file is part of signon
 *
 * Copyright (C) 2009-2010 Nokia Corporation.
 *
 * Contact: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef BACKUPTEST_H_
#define BACKUPTEST_H_

#include <QtTest/QtTest>
#include <QtCore>

#include "signond/signoncommon.h"

using namespace SignOn;

class TestBackup: public QObject
{
    Q_OBJECT

public Q_SLOTS:
#if defined(SSO_CI_TESTMANAGEMENT)
    void runAllTests();
#endif

private Q_SLOTS:
    void initTestCase();
    void cleanupTestCase();
    void init();
    void cleanup();

    //backup mode
    void backupTest();
    void restoreTest();

    void backupNormalTest();
    void restoreNormalTest();

private:
    QProcess *daemonProcess;
};

#endif //BACKUPTEST_H_
