/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ConfigurableThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public ConfigurableThreadFactory(int priority, boolean daemon) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.group.setMaxPriority(priority);
        this.group.setDaemon(daemon);
        this.namePrefix = "configurablepool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    public Thread newThread(Runnable task) {
        Thread result = new Thread(this.group, task, this.namePrefix + this.threadNumber.getAndIncrement());
        result.setDaemon(this.group.isDaemon());
        return result;
    }
}

