
#ifndef _LRET_H
#define _LRET_H

typedef struct {
	char name[SPECTER_IRET_NAME_LEN];
	specter_iret_t *p;
} specter_local_ret_t;


#define GET_VALUE(ret_arr,x)	(ret_arr[x].p->value)
#define GET_FLAGS(ret_arr,x)	(ret_arr[x].p->flags)
#define GET_LEN(ret_arr,x)	(ret_arr[x].p->len)
#define IS_VALID(p)		(p->flags & SPECTER_RETF_VALID)


static inline int fill_local_ret(specter_local_ret_t *lrets, int num)
{
	int ctr;

	for (ctr = 0; ctr < num; ctr++) {
		if ((lrets[ctr].p = find_iret(lrets[ctr].name)) == NULL) {
			specter_log(SPECTER_NOTICE, "iret with name \"%s\" not found.\n", lrets[ctr].name);
			return -1;
		}
	}

	return 0;
}

#endif /* lret.h */

