var targetURL;
var selectionBox;
var selectionStartX;
var selectionStartY;
var selectionEndX;
var selectionEndY;
var currentScaling;
var mainArea;
var isSelecting = false;
var cropSelected;
var makeSelectionVisibleWhenLoaded = false;
const SELECTING_NEW = 0;
const SELECTING_E = 1;
const SELECTING_NE = 2;
const SELECTING_SE = 3;
const SELECTING_W = 4;
const SELECTING_NW = 5;
const SELECTING_SW = 6;
const SELECTING_N = 7;
const SELECTING_S = 8;
const SELECTING_MOVE = 9;
var selectingMode = SELECTING_NEW;
var currentMoveX;
var currentMoveY;
var javascriptEnabled;
var originalCanvas;

const SELECTION_BORDER = 8;

function Startup() {
  targetURL = window.arguments[0];
  cropSelected = window.arguments[1];
  var initialCropX = window.arguments[2];
  var initialCropY = window.arguments[3];
  var initialCropWidth = window.arguments[4];
  var initialCropHeight = window.arguments[5];
  currentScaling = window.arguments[6];
  javascriptEnabled = window.arguments[7];
  
  if (currentScaling < 5) {
    currentScaling = 100;
  } else if (currentScaling > 1000) {
    currentScaling = 1000;
  }
  
  document.getElementById("currentScaling").value = currentScaling;
  document.getElementById("selectionAreaColor").color = "#000000";
  document.getElementById("selectionAreaColorText").value = document.getElementById("selectionAreaColor").color;
  selectionBox = document.getElementById("selection-box");
  selectionBox.style.borderColor = document.getElementById("selectionAreaColor").color;
  mainArea = document.getElementById("cropCanvas");
  
  originalCanvas = document.createElementNS("http://www.w3.org/1999/xhtml", "canvas");
  
  // Capture thumbnail
  var wm = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var windowIter = wm.getEnumerator('navigator:browser');
  
  if (windowIter.hasMoreElements()) {
    var firstWindow = windowIter.getNext();
    firstWindow.SpeedDial.thumbnailGenerationListeners.push(window);
    firstWindow.SpeedDial.addPrioritySchedule(0);
  }

  // Register observers
  mainArea.addEventListener("mousedown", selectionBoxMouseDown, false);
  mainArea.addEventListener("mouseup", selectionBoxMouseUp, false);
  mainArea.addEventListener("mouseout", selectionBoxMouseOut, false);
  mainArea.addEventListener("mousemove", selectionBoxMouseMove, false);
  
  if (cropSelected) {
    makeSelectionVisibleWhenLoaded = true;
    selectionStartX = parseInt(initialCropX);
    selectionStartY = parseInt(initialCropY);
    selectionEndX = selectionStartX + parseInt(initialCropWidth);
    selectionEndY = selectionStartY + parseInt(initialCropHeight);
    setTimeout(refreshSelectionBox, 0);
  }
}

function refreshSelectionBox() {
    selectionBox.setAttribute("top", selectionStartY);
    selectionBox.setAttribute("left", selectionStartX);
    setSize(selectionBox, selectionEndX - selectionStartX, selectionEndY - selectionStartY);
}

function Unload() {
  mainArea.removeEventListener("mousedown", selectionBoxMouseDown, false);
  mainArea.removeEventListener("mouseup", selectionBoxMouseOut, false);
  mainArea.removeEventListener("mouseout", selectionBoxMouseOut, false);
  mainArea.removeEventListener("mousemove", selectionBoxMouseMove, false);
}

function onOK(event) {
  if (selectionBox.hasAttribute("hidden")) {
    var bundle = document.getElementById("bundle_cropSelector");
    alert(bundle.getString("noCropArea.warning"));
    return false;
  }
  var leftOffset, cropWidth;
  if (selectionStartX < selectionEndX) {
    leftOffset = selectionStartX;
    cropWidth = selectionEndX - selectionStartX;
  } else {
    leftOffset = selectionEndX;
    cropWidth = selectionStartX - selectionEndX;
  }
  var topOffset, cropHeight;
  if (selectionStartY < selectionEndY) {
    topOffset = selectionStartY;
    cropHeight = selectionEndY - selectionStartY;
  } else {
    topOffset = selectionEndY;
    cropHeight = selectionStartY - selectionEndY;
  }
  window.opener.setCropData(leftOffset, topOffset, cropWidth, cropHeight, currentScaling);

  return true;
}

function onCancel(event) {
  return true;
}

function selectionBoxMouseDown(e) {
  if (e.button != 0) {
    return;
  }
  
  selectingMode = getSelectingMode(e.layerX, e.layerY);

  if (selectionBox.hasAttribute("hidden")) {
    selectionBox.removeAttribute("hidden");
  }

  isSelecting = true;

  if (selectingMode == SELECTING_NEW) {
    selectionStartX = e.layerX;
    selectionStartY = e.layerY;
    selectionEndX = e.layerX;
    selectionEndY = e.layerY;
    selectionBox.setAttribute("top", selectionStartY);
    selectionBox.setAttribute("left", selectionStartX);
    setSize(selectionBox, 0, 0);
  } else if (selectingMode == SELECTING_MOVE) {
    currentMoveX = e.layerX;
    currentMoveY = e.layerY;
    mainArea.style.cursor = "-moz-grabbing";
  }
}

function selectionBoxMouseUp(e) {
  if (e.button != 0) {
    return;
  }
  
  endSelection();
}

function selectionBoxMouseOut(el) {
  if (selectionBox.hasAttribute("hidden")) return;

  var hasExited = (el.relatedTarget != el.currentTarget);
  var currentNode = el.relatedTarget;

  if (currentNode) {
    while (hasExited && currentNode.parentNode) {
      hasExited = ((el.currentTarget != currentNode.parentNode) && (currentNode.localName != "tooltip"));
      currentNode = currentNode.parentNode;
    }
  }

  if (hasExited) {
    if (!selectionBox.hasAttribute("hidden") && isSelecting)
      endSelection();
  }
}

function selectionBoxMouseMove(e) {
  if (e.button != 0) {
    return;
  }

  if (selectionBox.hasAttribute("hidden")) {
    return;
  }
  
  if (!isSelecting) {
    // Check current mouse cursor
    var cursor = "auto";
    switch (getSelectingMode(e.layerX, e.layerY)) {
      case SELECTING_NEW:
        cursor = "crosshair";
        break;
      case SELECTING_E:
        cursor = "e-resize";
        break;
      case SELECTING_NE:
        cursor = "ne-resize";
        break;
      case SELECTING_SE:
        cursor = "se-resize";
        break;
      case SELECTING_W:
        cursor = "w-resize";
        break;
      case SELECTING_NW:
        cursor = "nw-resize";
        break;
      case SELECTING_SW:
        cursor = "sw-resize";
        break;
      case SELECTING_N:
        cursor = "n-resize";
        break;
      case SELECTING_S:
        cursor = "s-resize";
        break;
      case SELECTING_MOVE:
        cursor = "-moz-grab";
        break;
    }
    
    mainArea.style.cursor = cursor;
    
    return;
  }

  if (selectingMode == SELECTING_NEW) {
    var newWidth, newHeight;
    if (e.layerX < selectionStartX) {
      selectionBox.setAttribute("left", e.layerX);
      newWidth = selectionStartX - e.layerX;
    } else {
      selectionBox.setAttribute("left", selectionStartX);
      newWidth = e.layerX - selectionStartX - 1;
    }
  
    if (e.layerY < selectionStartY) {
      selectionBox.setAttribute("top", e.layerY);
      newHeight = selectionStartY - e.layerY;
    } else {
      selectionBox.setAttribute("top", selectionStartY);
      newHeight = e.layerY - selectionStartY - 1;
    }
    setSize(selectionBox, newWidth, newHeight);
  
    selectionEndX = e.layerX;
    selectionEndY = e.layerY;
  } else {
    if (selectingMode == SELECTING_MOVE) {
      var diffX = e.layerX - currentMoveX;
      var diffY = e.layerY - currentMoveY;
      
      selectionStartX += diffX;
      selectionEndX += diffX;
      selectionStartY += diffY;
      selectionEndY += diffY;
      
      currentMoveX = e.layerX;
      currentMoveY = e.layerY;
      mainArea.style.cursor = "-moz-grabbing";
    } else {
      switch (selectingMode) {
        case SELECTING_N:
          selectionStartY = e.layerY;
          if (selectionStartY >= selectionEndY) {
            selectionStartY = selectionEndY - 1;
          }
          break;
        case SELECTING_NW:
          selectionStartY = e.layerY;
          selectionStartX = e.layerX;
          if (selectionStartY >= selectionEndY) {
            selectionStartY = selectionEndY - 1;
          }
          if (selectionStartX >= selectionEndX) {
            selectionStartX = selectionEndX - 1;
          }
          break;
        case SELECTING_NE:
          selectionStartY = e.layerY;
          selectionEndX = e.layerX;
          if (selectionStartY >= selectionEndY) {
            selectionStartY = selectionEndY - 1;
          }
          if (selectionEndX <= selectionStartX) {
            selectionEndX = selectionStartX + 1;
          }
          break;
        case SELECTING_S:
          selectionEndY = e.layerY;
          if (selectionEndY <= selectionStartY) {
            selectionEndY = selectionStartY + 1;
          }
          break;
        case SELECTING_SW:
          selectionEndY = e.layerY;
          selectionStartX = e.layerX;
          if (selectionEndY <= selectionStartY) {
            selectionEndY = selectionStartY + 1;
          }
          if (selectionStartX >= selectionEndX) {
            selectionStartX = selectionEndX - 1;
          }
          break;
        case SELECTING_SE:
          selectionEndY = e.layerY;
          selectionEndX = e.layerX;
          if (selectionEndY <= selectionStartY) {
            selectionEndY = selectionStartY + 1;
          }
          if (selectionEndX <= selectionStartX) {
            selectionEndX = selectionStartX + 1;
          }
          break;
        case SELECTING_W:
          selectionStartX = e.layerX;
          if (selectionStartX >= selectionEndX) {
            selectionStartX = selectionEndX - 1;
          }
          break;
        case SELECTING_E:
          selectionEndX = e.layerX;
          if (selectionEndX <= selectionStartX) {
            selectionEndX = selectionStartX + 1;
          }
          break;
      }
    }
    selectionBox.setAttribute("left", selectionStartX);
    selectionBox.setAttribute("top", selectionStartY);
    setSize(selectionBox, selectionEndX - selectionStartX, selectionEndY - selectionStartY);
  }
}

function selectionAreaColorChanged() {
  var selectionAreaColorText = document.getElementById("selectionAreaColorText");
  var selectionAreaColor = document.getElementById("selectionAreaColor");
  
  if (selectionAreaColorText.value != selectionAreaColor.color) {
    selectionAreaColorText.value = selectionAreaColor.color;
  }
  
  // Refresh border color
  selectionBox.style.borderColor = selectionAreaColor.color;
}

function selectionAreaColorTextChanged() {
  var selectionAreaColorText = document.getElementById("selectionAreaColorText");
  var selectionAreaColor = document.getElementById("selectionAreaColor");
  
  if (selectionAreaColorText.value != selectionAreaColor.color) {
    selectionAreaColor.color = selectionAreaColorText.value;
  }
  
  // Refresh border color
  selectionBox.style.borderColor = selectionAreaColorText.value;
}

function endSelection() {
  isSelecting = false;
  if (selectingMode == SELECTING_MOVE) {
    mainArea.style.cursor = "-moz-grab";
  }

  // Ensure that the order is correct
  if (selectionEndX < selectionStartX) {
    var x = selectionStartX;
    selectionStartX = selectionEndX;
    selectionEndX = x;
  }
  if (selectionEndY < selectionStartY) {
    var y = selectionStartY;
    selectionStartY = selectionEndY;
    selectionEndY = y;
  }
}

// Call functions from thumbnail generator
function getTargetURL() {
  return targetURL;
}

function getJsEnabled() {
  return javascriptEnabled;
}

function getTargetCanvas() {
  return originalCanvas;
}

function thumbnailLoadError() {
  document.getElementById("cropCanvas").style.display = "none";
  document.getElementById("loadingMessage").style.display = "none";
  document.getElementById("errorMessage").style.display = "block";
}

function thumbnailLoadCompleted() {
  try {
  if ((makeSelectionVisibleWhenLoaded) && (selectionBox.hasAttribute("hidden"))) {
    selectionBox.removeAttribute("hidden");
  }
  document.getElementById("cropCanvas").style.display = "block";
  renderCanvas();
  document.getElementById("loadingMessage").style.display = "none";
  } catch (e) { alert(e); }
}

function renderCanvas() {
  var canvas = document.getElementById("cropCanvas");
  if (canvas.style.display == "block") {
    var originalCanvasWidth = parseInt(originalCanvas.getAttribute("width"));
    var originalCanvasHeight = parseInt(originalCanvas.getAttribute("height"));
    var canvasWidth = Math.round(originalCanvasWidth * currentScaling / 100);
    var canvasHeight = Math.round(originalCanvasHeight * currentScaling / 100);
    canvas.setAttribute("width", canvasWidth);
    canvas.setAttribute("height", canvasHeight);
    var context = canvas.getContext('2d');

//    alert("" + originalCanvasWidth + "," +originalCanvasHeight + "," +canvasWidth + "," +canvasHeight + ",");
//    canvas.setAttribute("style", "background-color: #000;");
    
    context.drawImage(originalCanvas, 0, 0, originalCanvasWidth, originalCanvasHeight, 0, 0, canvasWidth, canvasHeight);
  }
}

function getSelectingMode(x, y) {
  if (selectionBox.hasAttribute("hidden")) {
    return SELECTING_NEW;
  } else {
    if ((x < selectionStartX) || (y < selectionStartY) || (x > selectionEndX) || (y > selectionEndY)) {
      return SELECTING_NEW;
    }
    
    var distanceW = x - selectionStartX;
    var distanceE = selectionEndX - x;
    var distanceN = y - selectionStartY;
    var distanceS = selectionEndY - y;
  
    if (distanceN < SELECTION_BORDER) {
      if (distanceE < SELECTION_BORDER) {
        return SELECTING_NE;
      } else if (distanceW < SELECTION_BORDER) {
        return SELECTING_NW;
      } else {
        return SELECTING_N;
      }
    } else if (distanceS < SELECTION_BORDER) {
      if (distanceE < SELECTION_BORDER) {
        return SELECTING_SE;
      } else if (distanceW < SELECTION_BORDER) {
        return SELECTING_SW;
      } else {
        return SELECTING_S;
      }
    } else if (distanceE < SELECTION_BORDER) {
        return SELECTING_E;
    } else if (distanceW < SELECTION_BORDER) {
        return SELECTING_W;
    } else {
      return SELECTING_MOVE;
    }
  }
}

function setSize(targetElement,width,height) {
  targetElement.setAttribute("width", width);
  targetElement.setAttribute("height", height);

  targetElement.style.width = width+"px";
  targetElement.style.height = height+"px";
//  targetElement.style.minWidth = targetElement.style.width;
//  targetElement.style.minHeight = targetElement.style.height;
  targetElement.style.maxWidth = targetElement.style.width;
  targetElement.style.maxHeight = targetElement.style.height;
}

function currentScalingChanged() {
  currentScaling = document.getElementById("currentScaling").value;
  if (currentScaling < 5) {
    currentScaling = 100;
  } else if (currentScaling > 1000) {
    currentScaling = 1000;
  }
  renderCanvas();
}

function lessScaling() {
  var scalingText = document.getElementById("currentScaling");
  currentScaling = Math.round(parseInt(scalingText.value) * 0.91);
  scalingText.value = currentScaling;
  currentScalingChanged();
}

function moreScaling() {
  var scalingText = document.getElementById("currentScaling");
  currentScaling = Math.round(parseInt(scalingText.value) * 1.10);
  scalingText.value = currentScaling;
  currentScalingChanged();
}
