var gPref = Components.classes["@mozilla.org/preferences-service;1"]
               .getService(Components.interfaces.nsIPrefService)
               .QueryInterface(Components.interfaces.nsIPrefBranch2);

function Startup() {
  try {
  var defaultRefreshInterval = gPref.getIntPref("extensions.speeddial.defaultRefreshInterval");
  var refreshIntervalValue = 86400;
  if (defaultRefreshInterval > 0) {
    document.getElementById("refreshType").selectedIndex = 1;
    refreshIntervalValue = defaultRefreshInterval;
  }

  // Set the correct refresh interval unit value
  var refreshInterval = document.getElementById("refreshInterval");
  var unitIndex = SpeedDialUtils.getTimeUnitIndex(refreshIntervalValue);
  currentUnitValue = SpeedDialUtils.timeUnits[unitIndex];
  
  document.getElementById("refreshIntervalUnit").selectedIndex = unitIndex;
  refreshInterval.value = refreshIntervalValue / currentUnitValue;

  refreshTypeChanged();
  } catch (e) { alert(e); }
}

function refreshTypeChanged() {
  document.getElementById("refreshIntervalBox").hidden = !(document.getElementById("refreshType").selectedIndex == 1);
}

function refreshIntervalUnitChanged() {
  var newValue = SpeedDialUtils.timeUnits[document.getElementById("refreshIntervalUnit").selectedIndex];
  if (newValue != currentUnitValue) {
    // Update ammount
//    var refreshInterval = document.getElementById("refreshInterval");
//    refreshInterval.value = Math.floor(refreshInterval.value * currentUnitValue / newValue);
    currentUnitValue = newValue;
  }
}

function onOK(event) {
  var newDefaultRefreshInterval = -1;
  if (document.getElementById("refreshType").selectedIndex == 1) {
    var newRefreshInterval = document.getElementById("refreshInterval").value * currentUnitValue;
    if (newRefreshInterval < 5) newRefreshInterval = 5;
    newDefaultRefreshInterval = document.getElementById("refreshInterval").value * currentUnitValue;
  } else {
    newDefaultRefreshInterval = 0;
  }
  gPref.setIntPref("extensions.speeddial.defaultRefreshInterval", newDefaultRefreshInterval);
  window.opener.setRefreshDefault();
  return true;
}

function onCancel(event) {
  return true;
}