/*
 * norverify.c - verify mtd(not nand)
 *
 *  norverify /dev/mtdX orig-file
 *
 * modification information
 * ------------------------
 * 2009/07/03 : first release
 */

/* Include Files */
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
#include <sys/ioctl.h>
#include <mtd/mtd-user.h>

#define MTD_LENGTH (0x10000)

unsigned char readdata [MTD_LENGTH];
unsigned char origdata [MTD_LENGTH];

/*
 * main - verify
 */
int main (int argc, char *argv[])
{
	int     mfd, ofd;
	char   *mname, *oname;
	int     usage, offset, length, i, rc, err;

	usage  = 0;
	mname  = 0;
	oname  = 0;
	for ( i = 1 ; i < argc ; i++ ) {
		if (mname == 0) {
			mname = argv [i];
		} else if (oname == 0) {
			oname = argv [i];
		} else {
			usage++;
		}
	}
	if ((0 < usage) || (mname == 0) || (oname == 0)) {
		fprintf (stderr, "Usage: %s /dev/mtdX orig-file\n", argv [0]);
		return 1;
	}

	/*
	 * MTD
	 */
	mfd = open (mname, O_RDONLY);
	if (mfd < 0) {
		fprintf (stderr, "%s: %m\n", mname);
		return -1;
	}

	/*
	 * Original file
	 */
	ofd = open (oname, O_RDONLY);
	if (ofd < 0) {
		fprintf (stderr, "%s: %m\n", oname);
		close ( mfd );
		return -1;
	}

	/*
	 * Verify orig-file to MTD
	 */
	err    = 0;
	offset = 0;
	while ( 1 ) {
		length = read (ofd, origdata, sizeof(origdata));
		if (length <= 0) {
			break;
		}
		rc = read (mfd, readdata, length);
		if (length != rc) {
			fprintf (stderr, "Can't read %s at %dbytes\n", mname, offset);
			err = 1; 
			break;
		}
		if (memcmp (origdata, readdata, length) != 0) {
			fprintf (stderr, "Verify error at %dbytes\n", offset);
			err = 1;
			break;
		}
		offset += length;
	}

	close ( ofd );
	close ( mfd );

	exit ( err );
}
