# -*- coding: utf-8 -*-
# Copyright (c) 2007 Jimmy Rönnholm
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

from threading import Thread

from bootconfig import Grub, GrubLegacy, Usplash, Splashy

class StartupThread(Thread):

    """Provide a threaded interface to the initialization.

    Example:
    thread = StartupThread()
    thread.start()
    while(thread.isAlive()):
        do_stuff()
    grub_legacy_mode = thread.grub_legacy_mode
    grub = thread.grub
    usplash = thread.usplash
    splashy = thread.splashy
    
    grub_legacy_mode indicates if Grub2 or Grub Legacy is used.
    grub, usplash and splashy returns None if they could not be initialized.
    
    """

    def __init__ (self):
        Thread.__init__(self)
        self.grub_legacy_mode = False

    def run(self):
        try:
            self.grub = Grub()
            print "Grub2 detected"
        except:
            try:
                print "Grub2 not detected"
                self.grub = GrubLegacy()
                self.grub_legacy_mode = True
                print "Grub Legacy detected"
            except:
                self.grub = None
                print "Grub Legacy not detected"
        try:
            self.usplash = Usplash()
            print "Usplash detected"
        except:
            self.usplash = None
            print "Usplash not detected"
        try:
            self.splashy = Splashy()
            print "Splashy detected"
        except:
            self.splashy = None
            print "Splashy not detected"

class ShutdownThread(Thread):

    """Provide a threaded interface to the shutdown tasks."""

    def __init__ (self, grub=None, usplash=None, splashy=None):
        Thread.__init__(self)
        self.grub = grub
        self.usplash = usplash
        self.splashy = splashy

    def run(self):
        if self.usplash:
            self.usplash.do_shutdown_tasks()
        if self.splashy:
            self.splashy.do_shutdown_tasks()
        if self.grub:
            self.grub.do_shutdown_tasks()

class FloppyThread(Thread):

    """Provide a threaded interface for creating a grub boot floppy.
    
    grub is an instance of the Grub class.
    action is the action that should be performed.
    Possible values:
    'format'
    'write'
    
    The return code can be accessed from the variable ret.
    
    """

    def __init__ (self, grub, action):
        Thread.__init__(self)
        self.grub = grub
        self.action = action
        self.ret = None

    def run(self):
        if self.action == 'format':
            self.ret = self.grub.format_floppy()
        if self.action == 'write':
            self.ret = self.grub.make_floppy()
