/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          InfoMgmt.h

Description:

Environment (opt):
 
Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================
  
  =====================================================================
****************************************************************************/
#ifndef _INFO_MGMT
#define	_INFO_MGMT

#define NEWNICFLAG	'@'
#define SPLITFLAG	';'
#define MAXRECCOUNT	10

// Start Add By Roc Zhang 2007-9-18
#define STRING_TRUE			"True"
#define STRING_FALSE		"False"
// End Add

/*Macro used in DeviceInfo Module*/
#define _PATH_PROCNET_ROUTE "/proc/net/route"
#define _PATH_RESOLV_CONF "/etc/resolv.conf"

/*Macro used in PromptInfo Module*/
#define DEFAULT_PROMPTDAYS "2"
#define DEFAULT_PROMPTTIMES "5"

//add by xu jun
#define MAX_PROMPTDAYS "30"
#define MAX_PROMPTTIMES "200"
//END ADD

/*Macro used in ProxyInfo Module*/
#define FIREFOX_PROFILE_DIR "/.mozilla/firefox/"
#define FIREFOX_PROFILE_PATH "/.mozilla/firefox/profiles.ini"
#define FIREFOX_PREF_FILENAME "/prefs.js"
#define MAXNUM_PER_LINE 256



typedef struct DeviceInfo_struct
{
	char IPAddress[200];
	char LocDns[200];
	char Wins[200];
	char Proxy[200];
	char StudentID[200];
	char HardwareID[20];
	char GateWay[200];
	char HostName[200]; // Add by Roc Zhang 2007-9-28
	int BootTick;
} DeviceInfo;

typedef struct OtherInfo_struct {
	char StudentID[200];
	char CARoot[256];
	char Culture[50];
	char LastDate[50];
	char LastTimes[50];
	int Enable;
	int Actived;
	int ModifyPwd;
	int Provisioned;
	char Heartbeat_Interval[50];
	char Broadcast_Timeout[50];
	char ProvisionNumber[50]; // Add by Roc Zhang 2007-9-18
} OtherInfo;

typedef struct PromptInfo_struct {
	char PromptDays[20];
	char PromptTimes[20];
} PromptInfo;

typedef struct ServerInfo_struct {
	char ServerAddress[200];  //format: address:port or https://address:port
	char ProxyAddress[200];
	char ProxyUser[200];
	char ProxyPwd[200];
	 int  UseProxy; // Add by Roc Zhang 2007-9-19
} ServerInfo;

/*Func in DeviceInfo Module*/
int DeviceInfo_Construct(DeviceInfo *pDevInfo);
int DeviceInfo_StudentID(char *pstid, char *cmd);

/*Func in OtherInfo Module*/
int OtherInfo_StudentID(char *pstid, char *cmd);
int OtherInfo_Culture(char *pculture, char *cmd);
int OtherInfo_LastDate(char *pld, char *cmd);
int OtherInfo_LastTimes(char *plt, char *cmd);
int OtherInfo_CARoot(char *pca, char *cmd);
int OtherInfo_Construct(OtherInfo *pOI);

// Start Add By Roc Zhang 2007-9-11
int OtherInfo_Enable( int *pca, char *cmd);  
int OtherInfo_Actived( int *pca, char *cmd);  
int OtherInfo_ModifyPwd( int *pca, char *cmd);  
int OtherInfo_HeartBeat_Interval( char *pca, char *cmd);  
int OtherInfo_Broadcast_Timeout( char *pca, char *cmd);
// End Add

// Start Add  By Roc Zhang 2007-9-18 
int OtherInfo_Provisioned(int *pca, char *cmd);
int OtherInfo_ProvisionNumber( char *pca, char *cmd);
//end Add


/*Func in PromptInfo Module*/
int PromptInfo_PromptTimes(char *ptimes, char *cmd);
int PromptInfo_PromptDays(char *pdays, char *cmd);
int PromptInfo_Construct(PromptInfo *pPI);

/*Func in ProxyInfo Module*/
int ProxyInfo_Construct(char *pPI);

/*Func in ServerInfo Module*/
int ServerInfo_ServerAddress(char *paddr, char *cmd);
int ServerInfo_ProxyAddress(char *paddr, char *cmd);
int ServerInfo_ProxyUser(char *puser, char *cmd);
int ServerInfo_ProxyPwd(char *ppwd, char *cmd);
int ServerInfo_Construct(ServerInfo *pSI);

// Start add by Roc Zhang 2007-9-19
int ServerInfo_UseProxy(int * puseproxy, char *cmd);
// End add



#endif
