/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

	File Name:  Provision.h     

	Description:
	This file implements class 
	This class has following functions.

    OS: Metasys
    SE: SUSE 10.2

	Notes (opt):
****************************************************************************/

#ifndef _PROVISION_
#define _PROVISION_

#include "../TPMCtrl/tspi.h"
#include "../TPMCtrl/tss_defines.h"
#include "../TPMCtrl/tss_error.h"
#include "../TPMCtrl/TPMInterface.h"

#define	MAX_PATH			256
#define	TPM_OWNER_PASSWORD  "Intel"

// define the length & offset of user data structure
#define BOOTTICK_OFFSET				0
#define BOOTCOUNT_OFFSET			3
#define EXPIRYDATE_OFFSET			6
#define HWID_OFFSET					12
#define BOOTTICK_LENGTH				3
#define BOOTCOUNT_LENGTH			3
#define EXPIRYDATE_LENGTH			6
#define HWID_LENGTH					12

// define the initial value
#define BLANK_CHARACTER				' '
#define INITIAL_BOOT_COUNT          100
#define INITIAL_EXPIRY_DATE         "991231"

// define the result of TPM owner status
#define TPM_OWNER_VALID             5
#define TPM_OWNER_INVALID			4
#define TPM_PASSWORD_WRONG          3
#define SUCCESS						0

typedef struct Provision_struct
{
	char m_OwnerPassword[MAX_PATH];
	int  bTPMPresence;

} Provision;

int 	Provision_Construct(Provision *);
int 	Provision_Destruct(void);

TSS_RESULT createKnownPolicy(TSS_HCONTEXT, TSS_FLAG, TSS_HPOLICY *, TSS_HOBJECT);
TSS_RESULT createAltPolicy(TSS_HCONTEXT, TSS_FLAG, TPM_SECRET *, TSS_HPOLICY *, TSS_HOBJECT);
TSS_RESULT createKey(TSS_HCONTEXT, UINT32, TSS_HKEY *, TSS_BOOL, TSS_BOOL, TSS_HKEY);
void	setup_tss_validation(TSS_VALIDATION *, TSS_NONCE *);
void	cleanup_tss_validation(TSS_HCONTEXT, TSS_VALIDATION *);

// these functions are for SecurityPlatformInterface
int		Provision_VerifyRight(void);
int 	Provision_ConncetToTPM(void);

// these functions initialize the TPM user data
int		Provision_GetMacAddress(STRING);
int		Provision_InitTPMNV(BYTE *, UINT32, UINT32);
int		Provision_InitUserData(void);

// this function write down the ServerPK & IntelPK
int		Provision_WritePublicKey(BYTE *, BYTE *);

// these function set/change the owner password.
int		Provision_CreateOwnerShip(Provision *);
int		Provision_DisableOwnerClear(Provision *);
int		Provision_ChangeTPMOwnerShip(void);

// this function is for complete the whole TPM provision process
int		Provision_TPMAutoProvision(Provision *, BYTE *, BYTE *);

#endif
