/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _TPM_CTRL_
#define _TPM_CTRL_

#include <stdio.h>
#include "Engine/EngineCmm.h"
#include "ConnMgmt/ConnMgmt.h"

#define USERDATA_LENGTH		24
#define BOOTTICK_LENGTH		3
#define BOOTCOUNT_LENGTH	3
#define EXPIRYDATE_LENGTH	6
#define HWID_LENGTH			12
#define BOOTTICK_OFFSET		0
#define BOOTCOUNT_OFFSET	3
#define EXPIRYDATE_OFFSET	6
#define HWID_OFFSET			12
#define DATE_BUFFER_LEN     3

typedef struct TPMCtrl_struct
{
	byte	m_UserData[USERDATA_LENGTH];

} TPMCtrl;

int 	TPMCtrl_Construct(TPMCtrl *);
int 	TPMCtrl_SaveProvisionPacket(byte *, int);
int 	TPMCtrl_GetUserData(TPMCtrl *);
int		TPMCtrl_Bootick(TPMCtrl *, int *);
int		TPMCtrl_BootCount(TPMCtrl *, int *);
int     TPMCtrl_ExpiryDate(TPMCtrl *, DateTime *);
int 	TPMCtrl_HWID(TPMCtrl *, string);

#endif
