/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
/*++

There are platform dependent and general defines.

--*/

#ifndef TSS_PLATFORM_H
#define TSS_PLATFORM_H


/* The default implementation is to use stdint.h, a part of the C99 standard.
 * Systems that don't support this are handled on a case-by-case basis.
 */

#if !defined(WIN32)
#include <stdint.h>
   typedef uint8_t            BYTE;
   typedef int8_t             TSS_BOOL;
   typedef uint16_t           UINT16;
   typedef uint32_t           UINT32;
   typedef uint64_t           UINT64;

   typedef uint16_t           TSS_UNICODE;
   typedef void*              PVOID;

#elif defined(WIN32)
#include <basetsd.h>
   typedef  unsigned char    BYTE;  
   typedef  signed char      TSS_BOOL;
#ifndef _BASETSD_H_
   // basetsd.h provides definitions of UINT16, UINT32 and UINT64.
   typedef  unsigned short   UINT16;
   typedef  unsigned long    UINT32;
   typedef  unsigned __int64 UINT64;
#endif
   typedef  unsigned short   TSS_UNICODE;
   typedef  void*            PVOID;
#endif


#endif // TSS_PLATFORM_H
