/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "GUI/callbacks.h"
#include "GUI/interface.h"
#include "GUI/support.h"
#include "GUI/FormTCAgent.h"

#define setbuttondisabled(window,name) (gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(window),name),FALSE))
#define setbuttonenabled(window,name) (gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(window),name),TRUE))
extern GtkWidget *AgentWindow;
//extern GtkWidget *WarningWindow;
//extern GtkWidget *ProgressWindow;
extern GtkWidget *RebootWindow;
extern GtkWidget *AboutWindow;

int last_switch_page_num=1;
//extern gboolean m_bFormWarningShow;

gboolean
on_AgentWindow_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  //gtk_window_iconify(widget);
    gtk_widget_hide(widget);
    destroywindow();
	return TRUE;
  //return FALSE;//normal behaviour
}


gboolean
on_AgentWindow_destroy_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{   
	//gtk_main_quit();
	gtk_widget_hide(widget);  
	destroywindow();	
	return FALSE;
}

gboolean
on_AgentWindow_map                     (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	TCAgentForm_Load();
	
	return FALSE;
}


gboolean
on_AgentWindow_unmap_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(AgentWindow);
  return FALSE;
}


void
on_btnOK_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
	OkButton_Click();
	gtk_widget_hide(AgentWindow);
}


void
on_btnCancel_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	CancelButton_Click();
	gtk_widget_hide(AgentWindow);
}


void
on_btnApply_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	ApplyButton_Click();
}
/*
on_WarningWindow_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(WarningWindow);
  return TRUE;
}


gboolean
on_WarningWindow_destroy_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_WarningWindow_unmap_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  m_bFormWarningShow = FALSE;

  return FALSE;
}


gboolean
on_WarningWindow_map_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  LoadWarningWindow();
  gtk_widget_show(WarningWindow);

  return FALSE;
}


void
on_btnWarningOK_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_hide(WarningWindow);
}


gboolean
on_DownloadWindow_destroy_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_DownloadWindow_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(ProgressWindow);
  return TRUE;
}


gint update_progress_bar(gpointer data)
{
	gdouble new_val;
	
 	new_val = gtk_progress_bar_get_fraction (lookup_widget(GTK_WIDGET(ProgressWindow),"progressbar1")) + 0.1;
     
	gtk_progress_bar_set_fraction(lookup_widget(GTK_WIDGET(ProgressWindow),"progressbar1"),new_val);
	
	if (new_val>=1)
	{
		gtk_widget_hide(ProgressWindow);
		return FALSE;
	}
	else
		return TRUE;	
}

pthread_t MyDownloadThread;

void showprogresswindow()
{
	// show Form progress

//	int ret = pthread_create(&MyDownloadThread, NULL, DownloadControl, NULL);
//	if (ret) 
//	{
//		WritestrLog(MODULE_GUI, "thread fork error.");
//		return;// FALSE;
//	}
	
}

gboolean
on_DownloadWindow_map_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{//every 1 second (1000ms), update progress bar once

	gtk_widget_show_all(ProgressWindow);
	gtk_timeout_add(1000, update_progress_bar,NULL);	
	showprogresswindow();	
	return FALSE;
}


gboolean
on_DownloadWindow_unmap_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    int ret = pthread_join(MyDownloadThread, (void **)NULL);
	if (ret) 
	{

		WritestrLog(MODULE_GUI, "thread join error.");
		//return ;//FALSE;
	}
	
	UpdateUIbyStatus();

    return FALSE;
}

*/
gboolean
on_RebootWindow_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(RebootWindow);
  RebootDevice_Clicked();
  return TRUE;
}


gboolean
on_RebootWindow_destroy_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_RebootWindow_map_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
//every 1 second (1000ms), update progress bar once
	gtk_timeout_add(1000, update_reboot_time,NULL);	

  return FALSE;
}


gboolean
on_RebootWindow_unmap_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}

void
on_entryPwd_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	entryPwd_TextChanged();

}


void
on_btnReboot_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	RebootDevice_Clicked();
	
		gtk_widget_hide(RebootWindow);
}

/*
void
on_notebook1_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        guint            page_num,
                                        gpointer         user_data)
{
//	WritestrLog(MODULE_GUI, "notebook switch");
	//if (page_num == 2)
	//{
//		WritestrLog(MODULE_GUI, "notebook switch to 2");
	//	UpdateExpirationInfo();
	//	UpdateDeviceInfo();	
	//}
}


void
on_notebook1_change_current_page       (GtkNotebook     *notebook,
                                        gint             offset,
                                        gpointer         user_data)
{

}


gboolean
on_notebook1_select_page               (GtkNotebook     *notebook,
                                        gboolean         move_focus,
                                        gpointer         user_data)
{

  return FALSE;
}
*/
void
on_entryProxy_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
 entryPwd_TextChanged();

}


void
on_entryName_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
 entryPwd_TextChanged();

}


void
on_entryServer_changed                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
 entryPwd_TextChanged();

}


/*
void
on_entryDays_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
 entryPwd_TextChanged();

}
*/
/*
void
on_entryTimes_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
 entryPwd_TextChanged();

}
*/

void
on_checkbutton1_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	EnableProxyServer(gtk_toggle_button_get_active(button));
}

gboolean
on_AboutWindow_map_event               (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_AboutWindow_unmap_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


gboolean
on_AboutWindow_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gtk_widget_hide(AboutWindow);
  return TRUE;
}


gboolean
on_AboutWindow_destroy_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_AboutBtnOK_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_hide(AboutWindow);
  return TRUE;
}
