/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          OtherInfo.c

Description:

Environment (opt):
 
Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================
  
  =====================================================================
****************************************************************************/


#include <string.h>
#include <stdio.h>
#include "InfoMgmt/InfoBase.h"
#include "InfoMgmt/InfoMgmt.h"
#include "GUI/error.h"

/* Description: Enable/Disable Debug Operation
 * Module: Other Info
 * Parameter: pstid (the StudentID Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
int OtherInfo_Debug(int *pca)
{
	/*parameter validity check*/
	if(pca == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	char enable_debug[10];
	memset(enable_debug, 0, 10);
	if(0 == Ini_ReadString(OTHERINFO_SECTION, ENABLE_DEBUG, "", enable_debug, get_tcagentconfig_path()))
	{
	if(!strcmp(enable_debug, "On"))
		*pca = 1;//enable debug
	else
		*pca = 0;//disable debug
	}else
	{
		*pca = 0;//disable debug
	}
	return *pca;
}

/* Description: StudentID Operation
 * Module: Other Info
 * Parameter: pstid (the StudentID Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
int OtherInfo_StudentID(char *pstid, char *cmd)
{
	/*parameter validity check*/
	if(pstid == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(OTHERINFO_SECTION, STUDENTID_VALUE, "", pstid, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(OTHERINFO_SECTION, STUDENTID_VALUE, pstid, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: Culture Operation
 * Module: Other Info
 * Parameter: pculture(the Culture Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_Culture(char *pculture, char *cmd)
{
	/*parameter validity check*/
	if(pculture == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}

	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(OTHERINFO_SECTION, CULTURE_VALUE, "en", pculture, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(OTHERINFO_SECTION, CULTURE_VALUE, pculture, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: LastDate Operation
 * Module: Other Info
 * Parameter: pld(the LastDate Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_LastDate(char *pld, char *cmd)
{
	/*parameter validity check*/
	if(pld == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	int err = 0, ret = 0;
	if(!strcmp(cmd, "GET"))
	{
		if(ret = Ini_ReadString(OTHERINFO_SECTION, LASTDATE_VALUE, "", pld, get_tcagentconfig_path()))
			err = ret;
		//if(ret = Ini_WriteString(OTHERINFO_SECTION, LASTDATE_VALUE, "", get_tcagentconfig_path()))
		//	err = ret;
		return err;
	}
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(OTHERINFO_SECTION, LASTDATE_VALUE, pld, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}


/* Description: LastTimes Operation
 * Module: Other Info
 * Parameter: plt(the LastTimes Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
int OtherInfo_LastTimes(char *plt, char *cmd)
{

	/*parameter validity check*/
	if(plt == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}

	int err = 0, ret = 0;
	if(!strcmp(cmd, "GET"))
	{
		if(ret = Ini_ReadString(OTHERINFO_SECTION, LASTTIMES_VALUE, "", plt, get_tcagentconfig_path()))
			err = ret;
		//if(ret = Ini_WriteString(OTHERINFO_SECTION, LASTTIMES_VALUE, "", get_tcagentconfig_path()))
		//	err = ret;
		return err;
	}
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(OTHERINFO_SECTION, LASTTIMES_VALUE, plt, get_tcagentconfig_path());
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}


/* Description: CARoot Operation
 * Module: Other Info
 * Parameter: pca(the CARoot Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_CARoot(char *pca, char *cmd)
{
	/*parameter validity check*/
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(OTHERINFO_SECTION, CAROOT_VALUE, "", pca, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(OTHERINFO_SECTION, CAROOT_VALUE, pca, get_tcagentconfig_path());	
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}

// Start Add By Roc Zhang 2007-9-18
/* Description: Provisione Operation
 * Module: Other Info
 * Parameter: pca(the Heartbeat_Interval Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_Provisioned(int *pca, char *cmd)
{
	char temp_value[10];
	int  ret;
	
        /*parameter validity check*/
        if(pca == NULL || cmd == NULL)
        {
                WriteLog(INFOMGMT_ERR_PARAM);
                return INFOMGMT_ERR_PARAM;
        }

	if(!strcmp(cmd, "GET"))
	{
		ret =  Ini_ReadString(OTHERINFO_SECTION, PROVISIONED_VALUE, STRING_FALSE, temp_value, get_tcagentconfig_path());
		if ( 0 == ret ) // SUCCEED
		{
			if ( strcasecmp( temp_value, STRING_TRUE ) == 0 )
				*pca = 1;
			else
				*pca = 0;
		}	
		return ret;	
	}
	else if(!strcmp(cmd, "SET"))
	{
		if ( *pca )
			strcpy( temp_value, STRING_TRUE );
		else
			strcpy( temp_value, STRING_FALSE );
			
		return Ini_WriteString(OTHERINFO_SECTION, PROVISIONED_VALUE, temp_value, get_tcagentconfig_path());	
	}       

	WriteLog(INFOMGMT_ERR_INVALIDCMD);
        return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: ProvisionNumber Operation
 * Module: Other Info
 * Parameter: pca(the Heartbeat_Interval Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
#define PROVISIONNUMBER_LEN 20
int OtherInfo_ProvisionNumber(char  *pca, char *cmd)
{
	char provisionnumber[PROVISIONNUMBER_LEN+1];
	int i=0,temp;
	char str[2];
	/*parameter validity check*/
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	memset(provisionnumber, 0, PROVISIONNUMBER_LEN+1);
	for (;i<PROVISIONNUMBER_LEN;i++)
	{
	//	str[0]=*(pca+i);
	//	str[1]='\0';
		temp=*(pca+i);
		sprintf(str,"%x",temp);
		strcat(provisionnumber,str);		
	}
	

	*(provisionnumber+PROVISIONNUMBER_LEN)='\0';//provsion num only 20 bytes
	WritestrLog(MODULE_INFOMGMT,"provisionnumber:");

	WritestrLog(MODULE_INFOMGMT,provisionnumber);
	
	if(!strcmp(cmd, "GET"))
		return Ini_ReadString(OTHERINFO_SECTION, PROVSION_NUMBER_VALUE , "", provisionnumber, get_tcagentconfig_path());
	else if(!strcmp(cmd, "SET"))
		return Ini_WriteString(OTHERINFO_SECTION,PROVSION_NUMBER_VALUE , provisionnumber, get_tcagentconfig_path());	
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}
//end add

/* Start Add By Roc Zhang 2007-9-11 */

/* Description: Enable Operation
 * Module: Other Info
 * Parameter: pca(the Enable Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_Enable( int *pca, char *cmd)
{
	char temp_value[10];
	int  ret;

	/*parameter validity check*/
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}

	// Start Modified  By Roc Zhang 2007-9-18 
	if(!strcmp(cmd, "GET"))
	{
		ret =  Ini_ReadString(OTHERINFO_SECTION, ENABLE_VALUE, STRING_FALSE, temp_value, get_tcagentconfig_path());
		if ( 0 == ret ) // SUCCEED
		{
			if ( strcasecmp( temp_value, STRING_TRUE ) == 0 )
				*pca = 1;
			else
				*pca = 0;
		}	
		return ret;	
	}
	else if(!strcmp(cmd, "SET"))
	{
		if ( *pca )
			strcpy( temp_value, STRING_TRUE );
		else
			strcpy( temp_value, STRING_FALSE );
			
		return Ini_WriteString(OTHERINFO_SECTION, ENABLE_VALUE, temp_value, get_tcagentconfig_path());	
	}
	//end Modified
	
	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}


/* Description: Actived Operation
 * Module: Other Info
 * Parameter: pca(the Actived Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_Actived( int *pca, char *cmd)
{
	char temp_value[10];
	int  ret;

	/*parameter validity check*/
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	// Start Modified  By Roc Zhang 2007-9-18 
	if(!strcmp(cmd, "GET"))
	{
		ret =  Ini_ReadString(OTHERINFO_SECTION, ACTIVED_VALUE, STRING_FALSE, temp_value, get_tcagentconfig_path());
		if ( 0 == ret ) // SUCCEED
		{
			if ( strcasecmp( temp_value, STRING_TRUE ) == 0 )
				*pca = 1;
			else
				*pca = 0;
		}	
		return ret;
	}
	else if(!strcmp(cmd, "SET"))
	{
		if ( *pca )
			strcpy( temp_value, STRING_TRUE );
		else
			strcpy( temp_value, STRING_FALSE );
		return Ini_WriteString(OTHERINFO_SECTION, ACTIVED_VALUE, temp_value, get_tcagentconfig_path());	
	}
	//end Modified

	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}


/* Description: ModifyPwd Operation
 * Module: Other Info
 * Parameter: pca(the ModifyPwd Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_ModifyPwd( int *pca, char *cmd)
{
	char temp_value[10];
	int  ret;

	/*parameter validity check*/
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	// Start Modified  By Roc Zhang 2007-9-18 
	if(!strcmp(cmd, "GET"))
	{
		ret = Ini_ReadString(OTHERINFO_SECTION, MODIFYPWD_VALUE, STRING_FALSE, temp_value, get_tcagentconfig_path());
		if ( 0 == ret ) // SUCCEED
		{
			if ( strcasecmp( temp_value, STRING_TRUE ) == 0 )
				*pca = 1;
			else
				*pca = 0;
		}	
		return ret;
	}
	else if(!strcmp(cmd, "SET"))
	{
		if ( *pca )
			strcpy( temp_value, STRING_TRUE );
		else
			strcpy( temp_value, STRING_FALSE );
		return Ini_WriteString(OTHERINFO_SECTION, MODIFYPWD_VALUE, temp_value, get_tcagentconfig_path());	
	}
	//end Modified
	
	WriteLog(INFOMGMT_ERR_INVALIDCMD);  
	return INFOMGMT_ERR_INVALIDCMD;
}

/* Description: Heartbeat_Interval Operation
 * Module: Other Info
 * Parameter: pca(the Heartbeat_Interval Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */

int OtherInfo_HeartBeat_Interval( char *pca, char *cmd)
{
	/*parameter validity check*/
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}

   int return_value;

    if(!strcmp(cmd, "GET"))
    {
		 return_value= Ini_ReadString(OTHERINFO_SECTION, HEARTBEAT_INTERVAL_VALUE, "", pca, get_tcagentconfig_path());
		int value = atoi(pca);
		if(MIN_HEARTBEAT_INTERVAL > value || MAX_HEARTBEAT_INTERVAL < value)
		{
		strcpy(pca, DEFAULT_HEARTBEAT_INTERVAL);//set default value 
		WriteLog(INFOMGMT_ERR_OTHERINFO);		
		}
		return  return_value;		
    }else if(!strcmp(cmd, "SET"))
    {
        int value = atoi(pca);
		if(MIN_HEARTBEAT_INTERVAL > value || MAX_HEARTBEAT_INTERVAL < value)
		{
		strcpy(pca, DEFAULT_HEARTBEAT_INTERVAL);//set default value 
		WriteLog(INFOMGMT_ERR_OTHERINFO);		
		}
		return_value = Ini_WriteString(OTHERINFO_SECTION, HEARTBEAT_INTERVAL_VALUE, pca, get_tcagentconfig_path());	
		return  return_value;
	}

	WriteLog(INFOMGMT_ERR_INVALIDCMD);	
	return INFOMGMT_ERR_INVALIDCMD;
}


/* Description: Broadcast_Timeout Operation
 * Module: Other Info
 * Parameter: pca(the Broadcast_Timeout Value), cmd (operation command)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL.
 */
/*
int OtherInfo_Broadcast_Timeout( char *pca, char *cmd)
{
	//parameter validity check
	if(pca == NULL || cmd == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}

    int retrun_value;
    char tmpstr[10]; 
    int half_heartbeat_interval;	
    OtherInfo_HeartBeat_Interval( tmpstr, "GET");
     half_heartbeat_interval = atoi(tmpstr) / 2;
	
    if(!strcmp(cmd, "GET"))
    {
           
	    retrun_value = Ini_ReadString(OTHERINFO_SECTION, BROADCAST_TIMEOUT_VALUE, "", pca, get_tcagentconfig_path());
	    int value = atoi(pca);
	    if(value > half_heartbeat_interval)
	    {
	    value = half_heartbeat_interval;
	    sprintf(tmpstr, "%d", half_heartbeat_interval);
	    WritestrLog(MODULE_INFOMGMT, "Broadcast_Timeout is greater than half of Heartbeat_Interval, set it to half of Heartbeat_Interval.");
	    Ini_WriteString(OTHERINFO_SECTION, BROADCAST_TIMEOUT_VALUE, tmpstr, get_tcagentconfig_path());	
	    }
	    	
	   if(MIN_BROADCASTCAST_TIMEOUT> value || MAX_BROADCASTCAST_TIMEOUT< value)
	  {
		    strcpy(pca, DEFAULT_BROADCAST_TIMOUT);//set default value to 1 minute
		     Ini_WriteString(OTHERINFO_SECTION, BROADCAST_TIMEOUT_VALUE, pca, get_tcagentconfig_path());	
		    WriteLog(INFOMGMT_ERR_OTHERINFO);		    
	  }
		return retrun_value; 		 
    }else if(!strcmp(cmd, "SET"))
    {
       int value = atoi(pca);
	if(value > half_heartbeat_interval) 
	{
	value = half_heartbeat_interval;
	sprintf(pca, "%d", value);
	WritestrLog(MODULE_INFOMGMT, "Broadcast_Timeout is greater than half of Heartbeat_Interval, set it to half of Heartbeat_Interval.");
	}
	
	 if(MIN_BROADCASTCAST_TIMEOUT> value || MAX_BROADCASTCAST_TIMEOUT< value)
	{
	    strcpy(pca, DEFAULT_BROADCAST_TIMOUT);//set default value to 1 minute	
	    WriteLog(INFOMGMT_ERR_OTHERINFO);		
	}
	
	return Ini_WriteString(OTHERINFO_SECTION, BROADCAST_TIMEOUT_VALUE, pca, get_tcagentconfig_path());	
}

	WriteLog(INFOMGMT_ERR_INVALIDCMD);
	return INFOMGMT_ERR_INVALIDCMD;
}
*/
/* End  Add */

/* Description: Construct Other info from config file
 * Module: Other Info
 * Parameter: pOI (the OtherInfo structure which we need)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
 */
int OtherInfo_Construct(OtherInfo *pOI)
{
	int ret = 0, err = 0;

	/*parameter validity check*/
	if(pOI == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	memset(pOI, 0, sizeof(OtherInfo));
	if(ret = Ini_ReadString(OTHERINFO_SECTION, CULTURE_VALUE, "en", pOI->Culture, get_tcagentconfig_path()))
        {        
		err = ret;
	}
	if(ret = Ini_ReadString(OTHERINFO_SECTION, STUDENTID_VALUE, "", pOI->StudentID, get_tcagentconfig_path()))
	{        
		err = ret;
	}
	if(ret = Ini_ReadString(OTHERINFO_SECTION, CAROOT_VALUE, "", pOI->CARoot, get_tcagentconfig_path()))
	{        
		err = ret;
	}
	/* Commentted by Roc Zhang 2007-9-18
        if(ret = Ini_ReadString(OTHERINFO_SECTION, PROVISIONED_VALUE, "", pOI->Provisioned, get_tcagentconfig_path()))
        {
#ifdef DEBUG
printf("OtherInfoErrno1: %d\n", ret);
#endif
                err = ret;
        }
	*/

	// Start Add  By Roc Zhang 2007-9-18 
	if ( ret = OtherInfo_Provisioned( &pOI->Provisioned,  "GET") )
	{
		err = ret;
	}
	if ( ret = OtherInfo_ProvisionNumber( pOI->ProvisionNumber,  "GET") )
	{
		err = ret;
	}
	//end Add

	// Start Add By Roc Zhang 2007-9-12
	if ( ret = OtherInfo_Enable( &pOI->Enable,  "GET") )
	{
		err = ret;
	}
	if ( ret = OtherInfo_Actived( &pOI->Actived,  "GET") )
	{
		err = ret;
	}
	if ( ret = OtherInfo_ModifyPwd( &pOI->ModifyPwd,  "GET") )
	{
		err = ret;
	}
	if ( ret = OtherInfo_HeartBeat_Interval( pOI->Heartbeat_Interval,  "GET") )
	{
		err = ret;
	}
/*	if ( ret = OtherInfo_Broadcast_Timeout( pOI->Broadcast_Timeout,  "GET") )
	{
		err = ret;
	}*/
	// End add

	if(ret = Ini_ReadString(OTHERINFO_SECTION, LASTDATE_VALUE, "", pOI->LastDate, get_tcagentconfig_path()))
	{        
#ifdef DEBUG             
printf("OtherInfoErrno2: %d\n", ret); 
#endif		
		err = ret;
	}
/*	if(ret = Ini_WriteString(OTHERINFO_SECTION, LASTDATE_VALUE, "", get_tcagentconfig_path()))
	{
#ifdef DEBUG             
printf("OtherInfoErrno3: %d\n", ret); 
#endif		
		err = ret;
	}
*/	if(ret = Ini_ReadString(OTHERINFO_SECTION, LASTTIMES_VALUE, "", pOI->LastTimes, get_tcagentconfig_path()))
	{        
#ifdef DEBUG             
printf("OtherInfoErrno4: %d\n", ret); 
#endif		
		err = ret;
	}
/*	if(ret = Ini_WriteString(OTHERINFO_SECTION, LASTTIMES_VALUE, "", get_tcagentconfig_path()))
	{
#ifdef DEBUG             
printf("OtherInfoErrno5: %d\n", ret); 
#endif		
		err = ret;
	}
	if(err)
	{
		WriteLog(INFOMGMT_ERR_OTHERINFO);
		return INFOMGMT_ERR_OTHERINFO;
	}
	else
		return 0;*/
}


