# -*- coding: utf-8; Mode: Python; indent-tabs-mode: nil; tab-width: 4 -*-

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import signal
import gettext
import debconf
import parted
import glob

from ubiquity.plugin import *
from ubiquity import misc

from urecovery import util
from urecovery import grub
# don't install if we are runing as a recovery.
if not util.kopts_haskey('ubuntu-recovery'):
    NAME='recovery-inst'
    AFTER='usersetup'
    WEIGHT=11
OEM = False
class PageNoninteractive (PluginUI):
    pass

class Page(Plugin):
    pass

class Install(InstallPlugin):
    #{{{def install (self,target,progress,*args,**kwargs):
    def install (self,target,progress,*args,**kwargs):
        self.target = target
        progress.info("Install Recovery Tool")
        if not misc.execute_root('mount', '-t', 'vfat','/dev/sda1', '/mnt'):
            raise RuntimeError("Mount hidden partition failed")
        self.installInstallerInPart()
        self.installGrubInPart()
        if not misc.execute_root('umount', '/mnt'):
            raise RuntimeError("Umount /mnt failed")
#        util.set_partition_typenum('/dev/sda', '1', util.FS_RECOVERY)
        return InstallPlugin.install(self, target, progress, *args, **kwargs)
    #}}}

    #{{{def installInstallerInPart(self):
    def installInstallerInPart(self):
        self.debug("Installing recovery installer to /dev/sda1")
        for e in glob.glob('/cdrom/*'):
            self.debug("Copying %s" % e)
            if not misc.execute_root('cp', '-r', e, '/mnt'):
                raise RuntimeError("Copy files falied")
        # glob can not find hidden files
        self.debug("Copying /cdrom/.disk")
        if not misc.execute_root('cp', '-r', '/cdrom/.disk', '/mnt'):
            raise RuntimeError("Copy files falied")
        # create a preseed file
        util.generate_recoverypreseed('/mnt/install/preseed.cfg',
                                      '/mnt/install/recovery-preseed.cfg')
        #new UUID just fixes the installed-twice-on-same-system scenario
        if not util.generate_casperuuid('/mnt'):
            raise RuntimeError("Generate casper uuid failed")

        # hid partition
        if not misc.execute_root('cp',
                                 '/usr/share/ubuntu-recovery/data/30-hide-recovery-partition.fdi',
                                 '/target/usr/share/hal/fdi/preprobe/10osvendor/'):
            raise RuntimeError("Copy files falied")
    #}}}

    #{{{def installGrubInPart(self):
    def installGrubInPart(self):
        inmbr = False
        grubver = 2
        try:
            if not self.db.get('grub-installer/grub2_instead_of_grub_legacy'):
                grubver = 1
        except debconf.DebconfError:
            # backward
            pass

        cmd_installgrub = ['grub-install', '/dev/sda1']

        if not inmbr:
            cmd_installgrub.append('--root-directory=/mnt')
        if grubver == 2:
            cmd_installgrub.append('--force')

        if not misc.execute_root(*cmd_installgrub):
            raise RuntimeError("Install Grub in Recovery Partition failed")

        cfg = grub.GrubCfg()
        cfg.ver = grubver
        cfg.addEntry(grub.GrubMenuEntry(title="Restore System",
                                disk_id=0,
                                part_id=0,
                                kopts=self._genKopts()))
        cfg.saveToDir("/mnt/boot/grub/")
    #}}}

    #{{{def _genKopts(self):
    def _genKopts(self):
        kopts = ['boot=casper',
                'automatic-ubiquity',
                # we ingnor uuid checking in recovery intaller because updating uuid in
                # uuid.conf in ramdisk spend too much time
                'ignore_uuid',
                'only-ubiquity',
                'ubuntu-recovery',
                'file=/cdrom/install/recovery-preseed.cfg',
                'noprompt',
                'splash',
                'quiet']
        try:
            if self.db.get('oem-config/enable'):
                kopts.append('oem-config/enable=true')
        except debconf.DebconfError:
            # do nothing if oem-config/enable does not exists
            pass
        return kopts
    #}}}
pass
