import os
import re
import glob
import subprocess
import logging

FS_VFAT = '0b'
FS_RECOVERY = '1b'

#{{{def set_partition_typenum(disk, part_num, type_num):
def set_partition_typenum(disk, part_num, type_num):
    """use fdisk to change type number of partition.

    \param part_num partition number
    \param type_num filesystem type number
    """
    assert part_num is not int
    p1 = subprocess.Popen(['echo', "t\n%s\n%s\nw\n" % (part_num, type_num)],
                                                    stdout=subprocess.PIPE)
    p2 = subprocess.Popen(['fdisk', '-c', '-u', disk], stdin=p1.stdout)
    return p2.wait()
#}}}

#{{{def generate_recoverypreseed(src, to):
def generate_recoverypreseed(src, to):
    """generate a preseed file for recovery

    @param str src the path of preseed file for installation
    @param str to the path of preseed file for recovery
    """
    with open(src, 'r') as old:
        # remove local for language selection
        newstr = re.sub('d-i debian-installer/locale string .*', '', old.read())
    with open(to, 'w') as new:
        new.write(newstr)
#}}}

#{{{def kopts_haskey(key):
def kopts_haskey(key):
    """

    @param str key
    @return bool True if /proc/cmdline has key
    """
    with open('/proc/cmdline', 'r') as f:
        return True if key in f.read().strip().split() else False
#}}}

#{{{def generate_casperuuid(path):
def generate_casperuuid(path):
    try:
        uuid_path = glob.glob(os.path.join(path, '.disk', 'casper-uuid*'))[0]
        print uuid_path
    except IndexError:
        return False
    if os.path.isfile(uuid_path):
        p = subprocess.Popen(['uuidgen'], stdout=subprocess.PIPE)
        uuid = p.communicate()[0].replace('\n','')
        with open(uuid_path, 'w') as f:
            f.write(uuid)
        return True
    return False
#}}}

#{{{def setup_logging(debug=False, logfile=None):
def setup_logging(debug=False, logfile=None):
    '''Setup logging.'''

    logging.raiseExceptions = False
    if debug:
        logging.basicConfig(level=logging.DEBUG, filename=logfile,
            format='%(asctime)s %(levelname)s: %(message)s')
    else:
        logging.basicConfig(level=logging.WARNING, filename=logfile,
            format='%(levelname)s: %(message)s')
#}}}
