/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_APP_H_
#define _LAUNCHER_APP_H_

#include <glib.h>
#include <clutter/clutter.h>

#define LAUNCHER_TYPE_APP (launcher_app_get_type ())

#define LAUNCHER_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_APP, LauncherApp))

#define LAUNCHER_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_APP, LauncherAppClass))

#define LAUNCHER_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_APP))

#define LAUNCHER_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_APP))

#define LAUNCHER_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_APP, LauncherAppClass))

typedef struct _LauncherApp        LauncherApp;
typedef struct _LauncherAppClass   LauncherAppClass;
typedef struct _LauncherAppPrivate LauncherAppPrivate;
 
struct _LauncherApp
{
  ClutterGroup        parent;	

  LauncherAppPrivate *priv;
};

struct _LauncherAppClass
{
  ClutterGroupClass   parent_class;
};

GType launcher_app_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_app_get_default (void);


#endif /* _LAUNCHER_APP_H_ */

