/*
 * Copyright (C) 2012 Canonical, Ltd.
 *
 * Authors:
 *  Renato Araujo Oliveira Filho <renato@canonical.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
using Config;

namespace Unity.ContactsLens {

    static Daemon? daemon = null;
    static MainLoop? mainloop = null;
    public static int main (string[] args)
    {
        /* Set up necesities for i18n */
        GLib.Intl.textdomain (Config.PACKAGE);
        GLib.Intl.bindtextdomain (Config.PACKAGE, Config.LOCALEDIR);
        GLib.Intl.bind_textdomain_codeset (Config.PACKAGE, "UTF-8");
        GLib.Intl.setlocale(GLib.LocaleCategory.ALL, "");

        DesktopAppInfo.set_desktop_env ("Unity");

        /* Export the lens daemon on the session bus - as everywhere else
        * these values should match those definedd in the .lens file */
        Bus.own_name (BusType.SESSION, BUS_NAME,
                    BusNameOwnerFlags.NONE,
                    on_bus_acquired, on_name_acquired, on_name_lost);

        mainloop = new MainLoop ();
        mainloop.run ();

        return 0;
    }

    private static void on_bus_acquired (DBusConnection conn, string name)
    {
        debug ("Connected to session bus - checking for existing instances...");
        daemon = new Daemon ();
    }

    private static void on_name_acquired (DBusConnection conn, string name)
    {
        debug ("Acquired name %s. We're the main instance.\nAll system are go.",
               name);
    }

    private static void on_name_lost (DBusConnection conn, string name)
    {
        debug ("Another daemon is running.\nBailing out.");
        mainloop.quit ();
    }

} /* End namespace Unity.SampleLens */
