/* scroller-controller.c generated by valac 0.10.0, the Vala compiler
 * generated from scroller-controller.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2009-2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Gordon Allott <gord.allott@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutk/clutk.h>
#include <gee.h>
#include <libbamf/libbamf.h>
#include <unity.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <glib/gstdio.h>
#include <clutter/clutter.h>


#define UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER (unity_launcher_scroller_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER, UnityLauncherScrollerController))
#define UNITY_LAUNCHER_SCROLLER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER, UnityLauncherScrollerControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER, UnityLauncherScrollerControllerClass))

typedef struct _UnityLauncherScrollerController UnityLauncherScrollerController;
typedef struct _UnityLauncherScrollerControllerClass UnityLauncherScrollerControllerClass;
typedef struct _UnityLauncherScrollerControllerPrivate UnityLauncherScrollerControllerPrivate;

#define UNITY_LAUNCHER_TYPE_SCROLLER_MODEL (unity_launcher_scroller_model_get_type ())
#define UNITY_LAUNCHER_SCROLLER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, UnityLauncherScrollerModel))
#define UNITY_LAUNCHER_SCROLLER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, UnityLauncherScrollerModelClass))
#define UNITY_LAUNCHER_IS_SCROLLER_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL))
#define UNITY_LAUNCHER_IS_SCROLLER_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL))
#define UNITY_LAUNCHER_SCROLLER_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, UnityLauncherScrollerModelClass))

typedef struct _UnityLauncherScrollerModel UnityLauncherScrollerModel;
typedef struct _UnityLauncherScrollerModelClass UnityLauncherScrollerModelClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_VIEW (unity_launcher_scroller_view_get_type ())
#define UNITY_LAUNCHER_SCROLLER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerView))
#define UNITY_LAUNCHER_SCROLLER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerViewClass))
#define UNITY_LAUNCHER_IS_SCROLLER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW))
#define UNITY_LAUNCHER_IS_SCROLLER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW))
#define UNITY_LAUNCHER_SCROLLER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, UnityLauncherScrollerViewClass))

typedef struct _UnityLauncherScrollerView UnityLauncherScrollerView;
typedef struct _UnityLauncherScrollerViewClass UnityLauncherScrollerViewClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER (unity_launcher_scroller_child_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildController))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))

typedef struct _UnityLauncherScrollerChildController UnityLauncherScrollerChildController;
typedef struct _UnityLauncherScrollerChildControllerClass UnityLauncherScrollerChildControllerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD (unity_launcher_scroller_child_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChild))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))

typedef struct _UnityLauncherScrollerChild UnityLauncherScrollerChild;
typedef struct _UnityLauncherScrollerChildClass UnityLauncherScrollerChildClass;

#define UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER (unity_launcher_application_controller_get_type ())
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationController))
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationControllerClass))
#define UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER))
#define UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER))
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationControllerClass))

typedef struct _UnityLauncherApplicationController UnityLauncherApplicationController;
typedef struct _UnityLauncherApplicationControllerClass UnityLauncherApplicationControllerClass;

#define UNITY_LAUNCHER_SCROLLER_CHILD_TYPE_GROUP_TYPE (unity_launcher_scroller_child_group_type_get_type ())
typedef struct _UnityLauncherScrollerChildControllerPrivate UnityLauncherScrollerChildControllerPrivate;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER (unity_launcher_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistController))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))

typedef struct _UnityLauncherQuicklistController UnityLauncherQuicklistController;
typedef struct _UnityLauncherQuicklistControllerClass UnityLauncherQuicklistControllerClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER_MENU_STATE (unity_launcher_scroller_child_controller_menu_state_get_type ())
typedef struct _UnityLauncherApplicationControllerPrivate UnityLauncherApplicationControllerPrivate;
typedef struct _Block12Data Block12Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityLauncherScrollerChildPrivate UnityLauncherScrollerChildPrivate;

#define UNITY_LAUNCHER_TYPE_PIN_TYPE (unity_launcher_pin_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR (unity_launcher_scroller_model_iterator_get_type ())
#define UNITY_LAUNCHER_SCROLLER_MODEL_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR, UnityLauncherScrollerModelIterator))
#define UNITY_LAUNCHER_SCROLLER_MODEL_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR, UnityLauncherScrollerModelIteratorClass))
#define UNITY_LAUNCHER_SCROLLER_MODEL_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR))
#define UNITY_LAUNCHER_SCROLLER_MODEL_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR))
#define UNITY_LAUNCHER_SCROLLER_MODEL_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_SCROLLER_MODEL_TYPE_ITERATOR, UnityLauncherScrollerModelIteratorClass))

typedef struct _UnityLauncherScrollerModelIterator UnityLauncherScrollerModelIterator;
typedef struct _UnityLauncherScrollerModelIteratorClass UnityLauncherScrollerModelIteratorClass;
#define _unity_launcher_scroller_model_iterator_unref0(var) ((var == NULL) ? NULL : (var = (unity_launcher_scroller_model_iterator_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))

struct _UnityLauncherScrollerController {
	GObject parent_instance;
	UnityLauncherScrollerControllerPrivate * priv;
};

struct _UnityLauncherScrollerControllerClass {
	GObjectClass parent_class;
};

struct _UnityLauncherScrollerControllerPrivate {
	UnityLauncherScrollerModel* _model;
	UnityLauncherScrollerView* _view;
	GeeArrayList* childcontrollers;
	BamfMatcher* matcher;
	UnityFavorites* favorites;
	guint super_key_source;
	float last_drag_x;
	float last_drag_y;
};

typedef enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_DEVICE,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_SYSTEM
} UnityLauncherScrollerChildGroupType;

typedef void (*UnityLauncherScrollerChildControllermenu_cb) (DbusmenuMenuitem* menu, void* user_data);
typedef enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU_CLOSE_WHEN_LEAVE
} UnityLauncherScrollerChildControllerMenuState;

struct _UnityLauncherScrollerChildController {
	GObject parent_instance;
	UnityLauncherScrollerChildControllerPrivate * priv;
	UnityLauncherScrollerChildControllerMenuState menu_state;
	guint32 last_press_time;
	gboolean button_down;
	float click_start_pos_x;
	float click_start_pos_y;
	gint drag_sensitivity;
};

struct _UnityLauncherScrollerChildControllerClass {
	GObjectClass parent_class;
	void (*get_menu_actions) (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
	void (*get_menu_navigation) (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
	void (*activate) (UnityLauncherScrollerChildController* self);
	UnityLauncherQuicklistController* (*get_menu_controller) (UnityLauncherScrollerChildController* self);
	gboolean (*can_drag) (UnityLauncherScrollerChildController* self);
};

struct _UnityLauncherApplicationController {
	UnityLauncherScrollerChildController parent_instance;
	UnityLauncherApplicationControllerPrivate * priv;
	gboolean is_favorite;
};

struct _UnityLauncherApplicationControllerClass {
	UnityLauncherScrollerChildControllerClass parent_class;
};

struct _Block12Data {
	int _ref_count_;
	UnityLauncherScrollerController * self;
	UnityLauncherScrollerChildController* controller;
};

typedef enum  {
	UNITY_LAUNCHER_PIN_TYPE_UNPINNED,
	UNITY_LAUNCHER_PIN_TYPE_PINNED,
	UNITY_LAUNCHER_PIN_TYPE_ALWAYS,
	UNITY_LAUNCHER_PIN_TYPE_NEVER
} UnityLauncherPinType;

struct _UnityLauncherScrollerChild {
	CtkActor parent_instance;
	UnityLauncherScrollerChildPrivate * priv;
	UnityLauncherPinType pin_type;
	gboolean do_not_render;
	UnityLauncherScrollerChildController* controller;
	float grabbed_push;
	UnityUnityIcon* processed_icon;
};

struct _UnityLauncherScrollerChildClass {
	CtkActorClass parent_class;
};

typedef enum  {
	UNITY_LAUNCHER_APP_TYPE_ERROR_NO_DESKTOP_FILE
} UnityLauncherAppTypeError;
#define UNITY_LAUNCHER_APP_TYPE_ERROR unity_launcher_app_type_error_quark ()

static gpointer unity_launcher_scroller_controller_parent_class = NULL;

GType unity_launcher_scroller_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_model_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_view_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_controller_get_type (void) G_GNUC_CONST;
#define UNITY_LAUNCHER_SCROLLER_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER, UnityLauncherScrollerControllerPrivate))
enum  {
	UNITY_LAUNCHER_SCROLLER_CONTROLLER_DUMMY_PROPERTY,
	UNITY_LAUNCHER_SCROLLER_CONTROLLER_MODEL,
	UNITY_LAUNCHER_SCROLLER_CONTROLLER_VIEW
};
#define UNITY_LAUNCHER_SCROLLER_CONTROLLER_DRAG_SAFE_ZONE ((guint) 200)
UnityLauncherScrollerController* unity_launcher_scroller_controller_new (UnityLauncherScrollerModel* _model, UnityLauncherScrollerView* _view);
UnityLauncherScrollerController* unity_launcher_scroller_controller_construct (GType object_type, UnityLauncherScrollerModel* _model, UnityLauncherScrollerView* _view);
static void unity_launcher_scroller_controller_on_super_key_modifier_release (UnityLauncherScrollerController* self, guint keycode);
UnityLauncherScrollerModel* unity_launcher_scroller_controller_get_model (UnityLauncherScrollerController* self);
gint unity_launcher_scroller_model_get_size (UnityLauncherScrollerModel* self);
GType unity_launcher_scroller_child_get_type (void) G_GNUC_CONST;
static UnityLauncherScrollerChildController* unity_launcher_scroller_controller_get_controller_for_view (UnityLauncherScrollerController* self, UnityLauncherScrollerChild* childview);
UnityLauncherScrollerChild* unity_launcher_scroller_model_get (UnityLauncherScrollerModel* self, gint i);
void unity_launcher_scroller_child_controller_activate (UnityLauncherScrollerChildController* self);
static void unity_launcher_scroller_controller_on_super_key_active (UnityLauncherScrollerController* self);
static gboolean _lambda97_ (UnityLauncherScrollerController* self);
UnityLauncherScrollerView* unity_launcher_scroller_controller_get_view (UnityLauncherScrollerController* self);
void unity_launcher_scroller_view_enable_keyboard_selection_mode (UnityLauncherScrollerView* self, gboolean choice);
static gboolean __lambda97__gsource_func (gpointer self);
static void unity_launcher_scroller_controller_handle_bamf_view_opened (UnityLauncherScrollerController* self, GObject* object);
GType unity_launcher_application_controller_get_type (void) G_GNUC_CONST;
static UnityLauncherApplicationController* unity_launcher_scroller_controller_find_controller_by_desktop_file (UnityLauncherScrollerController* self, const char* desktop_file);
void unity_launcher_application_controller_attach_application (UnityLauncherApplicationController* self, BamfApplication* application);
UnityLauncherScrollerChild* unity_launcher_scroller_child_new (void);
UnityLauncherScrollerChild* unity_launcher_scroller_child_construct (GType object_type);
GType unity_launcher_scroller_child_group_type_get_type (void) G_GNUC_CONST;
void unity_launcher_scroller_child_set_group_type (UnityLauncherScrollerChild* self, UnityLauncherScrollerChildGroupType value);
UnityLauncherApplicationController* unity_launcher_application_controller_new (const char* desktop_file_, UnityLauncherScrollerChild* child_);
UnityLauncherApplicationController* unity_launcher_application_controller_construct (GType object_type, const char* desktop_file_, UnityLauncherScrollerChild* child_);
void unity_launcher_scroller_model_add (UnityLauncherScrollerModel* self, UnityLauncherScrollerChild* child);
static void unity_launcher_scroller_controller_on_scroller_controller_closed (UnityLauncherScrollerController* self, UnityLauncherScrollerChildController* controller);
static void _unity_launcher_scroller_controller_on_scroller_controller_closed_unity_launcher_scroller_child_controller_request_removal (UnityLauncherScrollerChildController* _sender, gpointer self);
static void _lambda98_ (Block12Data* _data12_);
gboolean unity_launcher_scroller_child_controller_get_hide (UnityLauncherScrollerChildController* self);
gboolean unity_launcher_scroller_model_contains (UnityLauncherScrollerModel* self, UnityLauncherScrollerChild* child);
UnityLauncherScrollerChild* unity_launcher_scroller_child_controller_get_child (UnityLauncherScrollerChildController* self);
GType unity_launcher_quicklist_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_controller_menu_state_get_type (void) G_GNUC_CONST;
void unity_launcher_scroller_model_remove (UnityLauncherScrollerModel* self, UnityLauncherScrollerChild* child);
static void __lambda98__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (Block12Data* _data12_);
gboolean unity_launcher_application_controller_is_sticky (UnityLauncherApplicationController* self);
static gint unity_launcher_scroller_controller_compare_prioritys (UnityLauncherScrollerChild* a, UnityLauncherScrollerChild* b);
GType unity_launcher_pin_type_get_type (void) G_GNUC_CONST;
GQuark unity_launcher_app_type_error_quark (void);
float unity_launcher_application_controller_get_priority (UnityLauncherApplicationController* self, GError** error);
static void unity_launcher_scroller_controller_build_favorites (UnityLauncherScrollerController* self);
static void unity_launcher_scroller_controller_model_order_changed (UnityLauncherScrollerController* self);
static void _unity_launcher_scroller_controller_model_order_changed_unity_launcher_scroller_model_order_changed (UnityLauncherScrollerModel* _sender, gpointer self);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
void unity_launcher_application_controller_set_fav_id (UnityLauncherApplicationController* self, const char* value);
void unity_launcher_scroller_model_sort (UnityLauncherScrollerModel* self, GCompareFunc compare);
static void unity_launcher_scroller_controller_on_favorite_added (UnityLauncherScrollerController* self, const char* uid);
const char* unity_launcher_application_controller_get_desktop_file (UnityLauncherApplicationController* self);
static void unity_launcher_scroller_controller_on_unity_drag_start (UnityLauncherScrollerController* self, UnityDragModel* drag_model);
static void unity_launcher_scroller_controller_on_unity_drag_motion (UnityLauncherScrollerController* self, UnityDragModel* drag_model, float x, float y);
static void _unity_launcher_scroller_controller_on_unity_drag_motion_unity_drag_controller_drag_motion (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self);
static void unity_launcher_scroller_controller_on_unity_drag_drop (UnityLauncherScrollerController* self, UnityDragModel* drag_model, float x, float y);
static void _unity_launcher_scroller_controller_on_unity_drag_drop_unity_drag_controller_drag_drop (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self);
void unity_launcher_scroller_view_set_drag_indicator_active (UnityLauncherScrollerView* self, gboolean value);
void unity_launcher_scroller_view_set_drag_indicator_space (UnityLauncherScrollerView* self, gboolean value);
UnityLauncherScrollerChildGroupType unity_launcher_scroller_child_get_group_type (UnityLauncherScrollerChild* self);
gboolean unity_launcher_scroller_child_get_enable_close_state (UnityLauncherScrollerChild* self);
void unity_launcher_scroller_child_set_enable_close_state (UnityLauncherScrollerChild* self, gboolean value);
gboolean unity_launcher_scroller_view_get_drag_indicator_space (UnityLauncherScrollerView* self);
gboolean unity_launcher_scroller_view_get_drag_indicator_active (UnityLauncherScrollerView* self);
gint unity_launcher_scroller_view_get_model_index_at_y_pos_no_anim (UnityLauncherScrollerView* self, float y, gboolean return_minus_if_fail);
void unity_launcher_scroller_model_move (UnityLauncherScrollerModel* self, UnityLauncherScrollerChild* child, gint i);
void unity_launcher_scroller_model_insert (UnityLauncherScrollerModel* self, UnityLauncherScrollerChild* child, gint i);
gint unity_launcher_scroller_view_get_drag_indicator_index (UnityLauncherScrollerView* self);
void unity_launcher_scroller_view_set_drag_indicator_index (UnityLauncherScrollerView* self, gint value);
CtkEffectCache* unity_launcher_scroller_view_get_cache (UnityLauncherScrollerView* self);
void unity_launcher_application_controller_set_sticky (UnityLauncherApplicationController* self, gboolean is_sticky);
void unity_launcher_application_controller_close_windows (UnityLauncherApplicationController* self);
gpointer unity_launcher_scroller_model_iterator_ref (gpointer instance);
void unity_launcher_scroller_model_iterator_unref (gpointer instance);
GParamSpec* unity_launcher_scroller_model_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_launcher_scroller_model_value_set_iterator (GValue* value, gpointer v_object);
void unity_launcher_scroller_model_value_take_iterator (GValue* value, gpointer v_object);
gpointer unity_launcher_scroller_model_value_get_iterator (const GValue* value);
GType unity_launcher_scroller_model_iterator_get_type (void) G_GNUC_CONST;
UnityLauncherScrollerModelIterator* unity_launcher_scroller_model_iterator (UnityLauncherScrollerModel* self);
gboolean unity_launcher_scroller_model_iterator_next (UnityLauncherScrollerModelIterator* self);
UnityLauncherScrollerChild* unity_launcher_scroller_model_iterator_get (UnityLauncherScrollerModelIterator* self);
void unity_launcher_application_controller_set_priority (UnityLauncherApplicationController* self, float priority);
static void unity_launcher_scroller_controller_set_model (UnityLauncherScrollerController* self, UnityLauncherScrollerModel* value);
static void unity_launcher_scroller_controller_set_view (UnityLauncherScrollerController* self, UnityLauncherScrollerView* value);
static void _unity_launcher_scroller_controller_on_favorite_added_unity_favorites_favorite_added (UnityFavorites* _sender, const char* uid, gpointer self);
static void _unity_launcher_scroller_controller_handle_bamf_view_opened_bamf_matcher_view_opened (BamfMatcher* _sender, GObject* object, gpointer self);
static void _g_list_free_g_object_unref (GList* self);
static void _unity_launcher_scroller_controller_on_unity_drag_start_unity_drag_controller_drag_start (UnityDragController* _sender, UnityDragModel* model, gpointer self);
static void _unity_launcher_scroller_controller_on_super_key_active_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_launcher_scroller_controller_on_super_key_modifier_release_unity_shell_super_key_modifier_release (UnityShell* _sender, guint keysym, gpointer self);
static GObject * unity_launcher_scroller_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_launcher_scroller_controller_finalize (GObject* obj);
static void unity_launcher_scroller_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_launcher_scroller_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



UnityLauncherScrollerController* unity_launcher_scroller_controller_construct (GType object_type, UnityLauncherScrollerModel* _model, UnityLauncherScrollerView* _view) {
	UnityLauncherScrollerController * self;
	g_return_val_if_fail (_model != NULL, NULL);
	g_return_val_if_fail (_view != NULL, NULL);
	self = (UnityLauncherScrollerController*) g_object_new (object_type, "model", _model, "view", _view, NULL);
	return self;
}


UnityLauncherScrollerController* unity_launcher_scroller_controller_new (UnityLauncherScrollerModel* _model, UnityLauncherScrollerView* _view) {
	return unity_launcher_scroller_controller_construct (UNITY_LAUNCHER_TYPE_SCROLLER_CONTROLLER, _model, _view);
}


static void unity_launcher_scroller_controller_on_super_key_modifier_release (UnityLauncherScrollerController* self, guint keycode) {
	gint index;
	gboolean _tmp0_ = FALSE;
	UnityLauncherScrollerChild* _tmp1_;
	UnityLauncherScrollerChildController* _tmp2_;
	UnityLauncherScrollerChildController* childcontroller;
	g_return_if_fail (self != NULL);
	if (!unity_shell_get_super_key_active (unity_global_shell)) {
		return;
	}
	index = ((gint) keycode) - 10;
	index = MIN (index, unity_launcher_scroller_model_get_size (self->priv->_model) - 1);
	if (index < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = index > 9;
	}
	if (_tmp0_) {
		return;
	}
	unity_shell_set_super_key_active (unity_global_shell, FALSE);
	childcontroller = (_tmp2_ = unity_launcher_scroller_controller_get_controller_for_view (self, _tmp1_ = unity_launcher_scroller_model_get (self->priv->_model, index)), _g_object_unref0 (_tmp1_), _tmp2_);
	if (UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (childcontroller)) {
		unity_launcher_scroller_child_controller_activate (childcontroller);
	} else {
		g_warning ("scroller-controller.vala:91: get_controller_for_view() returned NULL\n");
	}
	_g_object_unref0 (childcontroller);
}


static gboolean _lambda97_ (UnityLauncherScrollerController* self) {
	gboolean result = FALSE;
	unity_launcher_scroller_view_enable_keyboard_selection_mode (self->priv->_view, unity_shell_get_super_key_active (unity_global_shell));
	result = FALSE;
	return result;
}


static gboolean __lambda97__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda97_ (self);
	return result;
}


static void unity_launcher_scroller_controller_on_super_key_active (UnityLauncherScrollerController* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (unity_shell_get_super_key_active (unity_global_shell)) {
		_tmp0_ = self->priv->super_key_source == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->super_key_source = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, __lambda97__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		if (self->priv->super_key_source != 0) {
			g_source_remove (self->priv->super_key_source);
			self->priv->super_key_source = (guint) 0;
		}
		unity_launcher_scroller_view_enable_keyboard_selection_mode (self->priv->_view, FALSE);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_launcher_scroller_controller_on_scroller_controller_closed_unity_launcher_scroller_child_controller_request_removal (UnityLauncherScrollerChildController* _sender, gpointer self) {
	unity_launcher_scroller_controller_on_scroller_controller_closed (self, _sender);
}


static void _lambda98_ (Block12Data* _data12_) {
	UnityLauncherScrollerController * self;
	gboolean _tmp0_ = FALSE;
	self = _data12_->self;
	if (unity_launcher_scroller_child_controller_get_hide (_data12_->controller)) {
		_tmp0_ = unity_launcher_scroller_model_contains (self->priv->_model, unity_launcher_scroller_child_controller_get_child (_data12_->controller));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_data12_->controller)) {
			UnityLauncherScrollerChildController* _tmp1_;
			if ((_tmp1_ = _data12_->controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp1_) ? ((UnityLauncherApplicationController*) _tmp1_) : NULL)->is_favorite == FALSE) {
				unity_launcher_scroller_model_remove (self->priv->_model, unity_launcher_scroller_child_controller_get_child (_data12_->controller));
			}
		} else {
			unity_launcher_scroller_model_remove (self->priv->_model, unity_launcher_scroller_child_controller_get_child (_data12_->controller));
		}
	} else {
		gboolean _tmp2_ = FALSE;
		if (!unity_launcher_scroller_child_controller_get_hide (_data12_->controller)) {
			_tmp2_ = unity_launcher_scroller_model_contains (self->priv->_model, unity_launcher_scroller_child_controller_get_child (_data12_->controller)) == FALSE;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			unity_launcher_scroller_model_add (self->priv->_model, unity_launcher_scroller_child_controller_get_child (_data12_->controller));
		}
	}
}


static void __lambda98__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda98_ (self);
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (Block12Data* _data12_) {
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->self);
		_g_object_unref0 (_data12_->controller);
		g_slice_free (Block12Data, _data12_);
	}
}


static void unity_launcher_scroller_controller_handle_bamf_view_opened (UnityLauncherScrollerController* self, GObject* object) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (BAMF_IS_VIEW (object));
	if (BAMF_IS_APPLICATION (object)) {
		Block12Data* _data12_;
		GObject* _tmp0_;
		BamfApplication* app;
		char* desktop_file;
		gboolean _tmp1_ = FALSE;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->self = g_object_ref (self);
		app = _g_object_ref0 ((_tmp0_ = object, BAMF_IS_APPLICATION (_tmp0_) ? ((BamfApplication*) _tmp0_) : NULL));
		desktop_file = g_strdup (bamf_application_get_desktop_file (app));
		_data12_->controller = NULL;
		if (desktop_file != NULL) {
			_tmp1_ = _vala_strcmp0 (desktop_file, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			UnityLauncherScrollerChildController* _tmp2_;
			_data12_->controller = (_tmp2_ = (UnityLauncherScrollerChildController*) unity_launcher_scroller_controller_find_controller_by_desktop_file (self, desktop_file), _g_object_unref0 (_data12_->controller), _tmp2_);
		}
		if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_data12_->controller)) {
			UnityLauncherScrollerChildController* _tmp3_;
			unity_launcher_application_controller_attach_application ((_tmp3_ = _data12_->controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp3_) ? ((UnityLauncherApplicationController*) _tmp3_) : NULL), app);
		} else {
			UnityLauncherScrollerChild* child;
			UnityLauncherScrollerChildController* _tmp4_;
			UnityLauncherScrollerChildController* _tmp5_;
			child = g_object_ref_sink (unity_launcher_scroller_child_new ());
			unity_launcher_scroller_child_set_group_type (child, UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION);
			_data12_->controller = (_tmp4_ = (UnityLauncherScrollerChildController*) unity_launcher_application_controller_new (NULL, child), _g_object_unref0 (_data12_->controller), _tmp4_);
			unity_launcher_application_controller_attach_application ((_tmp5_ = _data12_->controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp5_) ? ((UnityLauncherApplicationController*) _tmp5_) : NULL), app);
			if (bamf_view_user_visible ((BamfView*) app)) {
				unity_launcher_scroller_model_add (self->priv->_model, child);
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->childcontrollers, _data12_->controller);
			g_signal_connect_object (_data12_->controller, "request-removal", (GCallback) _unity_launcher_scroller_controller_on_scroller_controller_closed_unity_launcher_scroller_child_controller_request_removal, self, 0);
			g_signal_connect_data ((GObject*) _data12_->controller, "notify::hide", (GCallback) __lambda98__g_object_notify, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
			_g_object_unref0 (child);
		}
		_g_free0 (desktop_file);
		_g_object_unref0 (app);
		block12_data_unref (_data12_);
	}
}


static void unity_launcher_scroller_controller_on_scroller_controller_closed (UnityLauncherScrollerController* self, UnityLauncherScrollerChildController* controller) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (controller != NULL);
	if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (controller)) {
		UnityLauncherScrollerChildController* _tmp0_;
		if (!unity_launcher_application_controller_is_sticky ((_tmp0_ = controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp0_) ? ((UnityLauncherApplicationController*) _tmp0_) : NULL))) {
			unity_launcher_scroller_model_remove (self->priv->_model, unity_launcher_scroller_child_controller_get_child (controller));
			gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->childcontrollers, controller);
		}
	}
}


static gint unity_launcher_scroller_controller_compare_prioritys (UnityLauncherScrollerChild* a, UnityLauncherScrollerChild* b) {
	gint result = 0;
	float prioritya;
	float priorityb;
	UnityLauncherScrollerChildController* childcontroller;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	prioritya = -1.0f;
	priorityb = -1.0f;
	childcontroller = NULL;
	{
		UnityLauncherScrollerChildController* _tmp0_;
		childcontroller = (_tmp0_ = _g_object_ref0 (a->controller), _g_object_unref0 (childcontroller), _tmp0_);
		if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (childcontroller)) {
			UnityLauncherScrollerChildController* _tmp1_;
			float _tmp2_;
			_tmp2_ = unity_launcher_application_controller_get_priority ((_tmp1_ = childcontroller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp1_) ? ((UnityLauncherApplicationController*) _tmp1_) : NULL), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == UNITY_LAUNCHER_APP_TYPE_ERROR) {
					goto __catch54_unity_launcher_app_type_error;
				}
				_g_object_unref0 (childcontroller);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			prioritya = _tmp2_;
		}
	}
	goto __finally54;
	__catch54_unity_launcher_app_type_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			prioritya = 10000.0f;
			_g_error_free0 (e);
		}
	}
	__finally54:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (childcontroller);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		UnityLauncherScrollerChildController* _tmp3_;
		childcontroller = (_tmp3_ = _g_object_ref0 (b->controller), _g_object_unref0 (childcontroller), _tmp3_);
		if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (childcontroller)) {
			UnityLauncherScrollerChildController* _tmp4_;
			float _tmp5_;
			_tmp5_ = unity_launcher_application_controller_get_priority ((_tmp4_ = childcontroller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp4_) ? ((UnityLauncherApplicationController*) _tmp4_) : NULL), &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == UNITY_LAUNCHER_APP_TYPE_ERROR) {
					goto __catch55_unity_launcher_app_type_error;
				}
				_g_object_unref0 (childcontroller);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			priorityb = _tmp5_;
		}
	}
	goto __finally55;
	__catch55_unity_launcher_app_type_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			priorityb = 10000.0f;
			_g_error_free0 (e);
		}
	}
	__finally55:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (childcontroller);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (prioritya < priorityb) {
		result = -1;
		_g_object_unref0 (childcontroller);
		return result;
	}
	if (prioritya > priorityb) {
		result = 1;
		_g_object_unref0 (childcontroller);
		return result;
	}
	result = 0;
	_g_object_unref0 (childcontroller);
	return result;
}


static void _unity_launcher_scroller_controller_model_order_changed_unity_launcher_scroller_model_order_changed (UnityLauncherScrollerModel* _sender, gpointer self) {
	unity_launcher_scroller_controller_model_order_changed (self);
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void unity_launcher_scroller_controller_build_favorites (UnityLauncherScrollerController* self) {
	guint _tmp0_;
	gint bamf_favorites_list_length1;
	gint _bamf_favorites_list_size_;
	char** _tmp2_;
	char** _tmp1_ = NULL;
	char** bamf_favorites_list;
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("order-changed", UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_scroller_controller_model_order_changed_unity_launcher_scroller_model_order_changed, self);
	bamf_favorites_list = (_tmp2_ = (_tmp1_ = g_new0 (char*, 0 + 1), _tmp1_), bamf_favorites_list_length1 = 0, _bamf_favorites_list_size_ = bamf_favorites_list_length1, _tmp2_);
	{
		GeeArrayList* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _uid_it;
		_uid_it = (_tmp4_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) (_tmp3_ = unity_favorites_get_favorites (self->priv->favorites))), _g_object_unref0 (_tmp3_), _tmp4_);
		while (TRUE) {
			char* uid;
			char* desktop_file;
			UnityLauncherApplicationController* controller;
			if (!gee_iterator_next (_uid_it)) {
				break;
			}
			uid = (char*) gee_iterator_get (_uid_it);
			desktop_file = unity_favorites_get_string (self->priv->favorites, uid, "desktop_file");
			if (!g_file_test (desktop_file, G_FILE_TEST_EXISTS)) {
				_g_free0 (desktop_file);
				_g_free0 (uid);
				continue;
			}
			_vala_array_add1 (&bamf_favorites_list, &bamf_favorites_list_length1, &_bamf_favorites_list_size_, g_strdup (desktop_file));
			controller = unity_launcher_scroller_controller_find_controller_by_desktop_file (self, desktop_file);
			if (!UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (controller)) {
				UnityLauncherScrollerChild* child;
				UnityLauncherApplicationController* _tmp5_;
				child = g_object_ref_sink (unity_launcher_scroller_child_new ());
				controller = (_tmp5_ = unity_launcher_application_controller_new (desktop_file, child), _g_object_unref0 (controller), _tmp5_);
				unity_launcher_scroller_model_add (self->priv->_model, child);
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->childcontrollers, (UnityLauncherScrollerChildController*) controller);
				g_signal_connect_object ((UnityLauncherScrollerChildController*) controller, "request-removal", (GCallback) _unity_launcher_scroller_controller_on_scroller_controller_closed_unity_launcher_scroller_child_controller_request_removal, self, 0);
				_g_object_unref0 (child);
			}
			unity_launcher_application_controller_set_fav_id (controller, uid);
			_g_object_unref0 (controller);
			_g_free0 (desktop_file);
			_g_free0 (uid);
		}
		_g_object_unref0 (_uid_it);
	}
	unity_launcher_scroller_model_sort (self->priv->_model, (GCompareFunc) unity_launcher_scroller_controller_compare_prioritys);
	g_signal_connect_object (self->priv->_model, "order-changed", (GCallback) _unity_launcher_scroller_controller_model_order_changed_unity_launcher_scroller_model_order_changed, self, 0);
	bamf_matcher_register_favorites (self->priv->matcher, bamf_favorites_list);
	bamf_favorites_list = (_vala_array_free (bamf_favorites_list, bamf_favorites_list_length1, (GDestroyNotify) g_free), NULL);
}


static void unity_launcher_scroller_controller_on_favorite_added (UnityLauncherScrollerController* self, const char* uid) {
	char* desktop_file;
	UnityLauncherApplicationController* controller;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	desktop_file = unity_favorites_get_string (self->priv->favorites, uid, "desktop_file");
	if (!g_file_test (desktop_file, G_FILE_TEST_EXISTS)) {
		_g_free0 (desktop_file);
		return;
	}
	controller = unity_launcher_scroller_controller_find_controller_by_desktop_file (self, desktop_file);
	if (!UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (controller)) {
		UnityLauncherScrollerChild* child;
		UnityLauncherApplicationController* _tmp0_;
		child = g_object_ref_sink (unity_launcher_scroller_child_new ());
		controller = (_tmp0_ = unity_launcher_application_controller_new (desktop_file, child), _g_object_unref0 (controller), _tmp0_);
		unity_launcher_scroller_model_add (self->priv->_model, child);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->childcontrollers, (UnityLauncherScrollerChildController*) controller);
		g_signal_connect_object ((UnityLauncherScrollerChildController*) controller, "request-removal", (GCallback) _unity_launcher_scroller_controller_on_scroller_controller_closed_unity_launcher_scroller_child_controller_request_removal, self, 0);
		_g_object_unref0 (child);
	}
	_g_object_unref0 (controller);
	_g_free0 (desktop_file);
}


static UnityLauncherApplicationController* unity_launcher_scroller_controller_find_controller_by_desktop_file (UnityLauncherScrollerController* self, const char* desktop_file) {
	UnityLauncherApplicationController* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (desktop_file != NULL, NULL);
	{
		GeeIterator* _controller_it;
		_controller_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->childcontrollers);
		while (TRUE) {
			UnityLauncherScrollerChildController* controller;
			if (!gee_iterator_next (_controller_it)) {
				break;
			}
			controller = (UnityLauncherScrollerChildController*) gee_iterator_get (_controller_it);
			if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (controller)) {
				UnityLauncherScrollerChildController* _tmp0_;
				if (_vala_strcmp0 (unity_launcher_application_controller_get_desktop_file ((_tmp0_ = controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp0_) ? ((UnityLauncherApplicationController*) _tmp0_) : NULL)), desktop_file) == 0) {
					UnityLauncherScrollerChildController* _tmp1_;
					result = _g_object_ref0 ((_tmp1_ = controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp1_) ? ((UnityLauncherApplicationController*) _tmp1_) : NULL));
					_g_object_unref0 (controller);
					_g_object_unref0 (_controller_it);
					return result;
				}
			}
			_g_object_unref0 (controller);
		}
		_g_object_unref0 (_controller_it);
	}
	result = NULL;
	return result;
}


static void _unity_launcher_scroller_controller_on_unity_drag_motion_unity_drag_controller_drag_motion (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self) {
	unity_launcher_scroller_controller_on_unity_drag_motion (self, model, x, y);
}


static void _unity_launcher_scroller_controller_on_unity_drag_drop_unity_drag_controller_drag_drop (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self) {
	unity_launcher_scroller_controller_on_unity_drag_drop (self, model, x, y);
}


static void unity_launcher_scroller_controller_on_unity_drag_start (UnityLauncherScrollerController* self, UnityDragModel* drag_model) {
	UnityDragController* drag_controller;
	UnityDragModel* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drag_model != NULL);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	g_signal_connect_object (drag_controller, "drag-motion", (GCallback) _unity_launcher_scroller_controller_on_unity_drag_motion_unity_drag_controller_drag_motion, self, 0);
	g_signal_connect_object (drag_controller, "drag-drop", (GCallback) _unity_launcher_scroller_controller_on_unity_drag_drop_unity_drag_controller_drag_drop, self, 0);
	if ((_tmp1_ = UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp0_ = unity_drag_controller_get_drag_model (drag_controller)), _g_object_unref0 (_tmp0_), _tmp1_)) {
		UnityDragModel* _tmp2_;
		UnityLauncherScrollerChildController* _tmp3_;
		UnityLauncherScrollerChild* _tmp4_;
		UnityLauncherScrollerChild* child;
		child = (_tmp4_ = _g_object_ref0 (unity_launcher_scroller_child_controller_get_child (_tmp3_ = (_tmp2_ = unity_drag_controller_get_drag_model (drag_controller), UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp2_) ? ((UnityLauncherScrollerChildController*) _tmp2_) : NULL))), _g_object_unref0 (_tmp3_), _tmp4_);
		clutter_actor_set_opacity ((ClutterActor*) child, (guint8) 0);
		child->do_not_render = TRUE;
		unity_launcher_scroller_view_set_drag_indicator_active (self->priv->_view, TRUE);
		unity_launcher_scroller_view_set_drag_indicator_space (self->priv->_view, TRUE);
		clutter_actor_queue_redraw ((ClutterActor*) self->priv->_view);
		_g_object_unref0 (child);
	}
	_g_object_unref0 (drag_controller);
}


static void unity_launcher_scroller_controller_on_unity_drag_motion (UnityLauncherScrollerController* self, UnityDragModel* drag_model, float x, float y) {
	gboolean _tmp0_ = FALSE;
	UnityDragController* drag_controller;
	UnityDragModel* _tmp1_;
	gboolean _tmp2_;
	UnityDragModel* _tmp3_;
	UnityLauncherScrollerChildController* _tmp4_;
	UnityLauncherScrollerChild* _tmp5_;
	UnityLauncherScrollerChild* retcont;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drag_model != NULL);
	if (x == self->priv->last_drag_x) {
		_tmp0_ = y == self->priv->last_drag_y;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->last_drag_x = x;
	self->priv->last_drag_y = y;
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if ((_tmp2_ = !UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp1_ = unity_drag_controller_get_drag_model (drag_controller)), _g_object_unref0 (_tmp1_), _tmp2_)) {
		_g_object_unref0 (drag_controller);
		return;
	}
	retcont = (_tmp5_ = _g_object_ref0 (unity_launcher_scroller_child_controller_get_child (_tmp4_ = (_tmp3_ = unity_drag_controller_get_drag_model (drag_controller), UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp3_) ? ((UnityLauncherScrollerChildController*) _tmp3_) : NULL))), _g_object_unref0 (_tmp4_), _tmp5_);
	if (x > (clutter_actor_get_width ((ClutterActor*) self->priv->_view) + UNITY_LAUNCHER_SCROLLER_CONTROLLER_DRAG_SAFE_ZONE)) {
		_tmp7_ = unity_launcher_scroller_child_get_group_type (retcont) != UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = unity_launcher_scroller_child_get_group_type (retcont) != UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_SYSTEM;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		unity_launcher_scroller_model_remove (self->priv->_model, retcont);
		unity_launcher_scroller_view_set_drag_indicator_active (self->priv->_view, FALSE);
		if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (retcont)) {
			if (unity_launcher_scroller_child_get_enable_close_state (retcont) == FALSE) {
				;
			}
			{
				unity_launcher_scroller_child_set_enable_close_state (retcont, TRUE);
			}
		}
	} else {
		gint model_index;
		UnityLauncherScrollerChild* _tmp9_;
		gboolean _tmp10_;
		if (UNITY_LAUNCHER_IS_SCROLLER_CHILD (retcont)) {
			if (unity_launcher_scroller_child_get_enable_close_state (retcont) == TRUE) {
				unity_launcher_scroller_child_set_enable_close_state (retcont, FALSE);
			}
		}
		if (x < clutter_actor_get_width ((ClutterActor*) self->priv->_view)) {
			if (unity_launcher_scroller_view_get_drag_indicator_space (self->priv->_view) != TRUE) {
				unity_launcher_scroller_view_set_drag_indicator_space (self->priv->_view, TRUE);
			}
		} else {
			gboolean _tmp8_ = FALSE;
			if (x > clutter_actor_get_width ((ClutterActor*) self->priv->_view)) {
				_tmp8_ = x < (clutter_actor_get_width ((ClutterActor*) self->priv->_view) + UNITY_LAUNCHER_SCROLLER_CONTROLLER_DRAG_SAFE_ZONE);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				if (unity_launcher_scroller_view_get_drag_indicator_space (self->priv->_view) != FALSE) {
					unity_launcher_scroller_view_set_drag_indicator_space (self->priv->_view, FALSE);
				}
				if (unity_launcher_scroller_view_get_drag_indicator_active (self->priv->_view) != TRUE) {
					unity_launcher_scroller_view_set_drag_indicator_active (self->priv->_view, TRUE);
				}
			}
		}
		model_index = unity_launcher_scroller_view_get_model_index_at_y_pos_no_anim (self->priv->_view, y - 24, TRUE);
		if (model_index < 0) {
			_g_object_unref0 (retcont);
			_g_object_unref0 (drag_controller);
			return;
		}
		if ((_tmp10_ = unity_launcher_scroller_child_get_group_type (_tmp9_ = unity_launcher_scroller_model_get (self->priv->_model, model_index)) != UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION, _g_object_unref0 (_tmp9_), _tmp10_)) {
			_g_object_unref0 (retcont);
			_g_object_unref0 (drag_controller);
			return;
		}
		if (unity_launcher_scroller_model_contains (self->priv->_model, retcont)) {
			unity_launcher_scroller_model_move (self->priv->_model, retcont, MAX (model_index, 0));
		} else {
			unity_launcher_scroller_model_insert (self->priv->_model, retcont, MAX (model_index, 0));
		}
		if (model_index != unity_launcher_scroller_view_get_drag_indicator_index (self->priv->_view)) {
			unity_launcher_scroller_view_set_drag_indicator_index (self->priv->_view, model_index);
			clutter_actor_queue_redraw ((ClutterActor*) self->priv->_view);
		}
	}
	_g_object_unref0 (retcont);
	_g_object_unref0 (drag_controller);
}


static void unity_launcher_scroller_controller_on_unity_drag_drop (UnityLauncherScrollerController* self, UnityDragModel* drag_model, float x, float y) {
	UnityDragController* drag_controller;
	UnityDragModel* _tmp0_;
	gboolean _tmp1_;
	UnityDragModel* _tmp2_;
	UnityLauncherScrollerChildController* model_controller;
	UnityLauncherScrollerChild* retcont;
	gboolean _tmp3_ = FALSE;
	guint _tmp9_;
	guint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drag_model != NULL);
	drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
	if ((_tmp1_ = !UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp0_ = unity_drag_controller_get_drag_model (drag_controller)), _g_object_unref0 (_tmp0_), _tmp1_)) {
		ctk_effect_cache_update_texture_cache (unity_launcher_scroller_view_get_cache (self->priv->_view));
		_g_object_unref0 (drag_controller);
		return;
	}
	unity_launcher_scroller_view_set_drag_indicator_active (self->priv->_view, FALSE);
	model_controller = (_tmp2_ = unity_drag_controller_get_drag_model (drag_controller), UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER (_tmp2_) ? ((UnityLauncherScrollerChildController*) _tmp2_) : NULL);
	retcont = _g_object_ref0 (unity_launcher_scroller_child_controller_get_child (model_controller));
	if (unity_launcher_scroller_child_get_group_type (retcont) == UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = unity_launcher_scroller_child_get_group_type (retcont) == UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_SYSTEM;
	}
	if (_tmp3_) {
		;
	} else {
		if (x > (clutter_actor_get_width ((ClutterActor*) self->priv->_view) + UNITY_LAUNCHER_SCROLLER_CONTROLLER_DRAG_SAFE_ZONE)) {
			gboolean _tmp6_ = FALSE;
			if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (retcont->controller)) {
				UnityLauncherScrollerChildController* _tmp4_;
				UnityLauncherScrollerChildController* _tmp5_;
				unity_launcher_application_controller_set_sticky ((_tmp4_ = retcont->controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp4_) ? ((UnityLauncherApplicationController*) _tmp4_) : NULL), FALSE);
				unity_launcher_application_controller_close_windows ((_tmp5_ = retcont->controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp5_) ? ((UnityLauncherApplicationController*) _tmp5_) : NULL));
			}
			if (unity_launcher_scroller_model_contains (self->priv->_model, retcont)) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = unity_launcher_scroller_child_get_group_type (retcont) == UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_DEVICE;
			}
			if (_tmp6_) {
				g_signal_emit_by_name (retcont, "drag-removed");
				unity_launcher_scroller_model_remove (self->priv->_model, retcont);
			}
			if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (model_controller)) {
				UnityLauncherScrollerChildController* _tmp7_;
				unity_launcher_application_controller_set_sticky ((_tmp7_ = model_controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp7_) ? ((UnityLauncherApplicationController*) _tmp7_) : NULL), FALSE);
			}
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->childcontrollers, model_controller)) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->childcontrollers, model_controller);
			}
		} else {
			if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (model_controller)) {
				UnityLauncherScrollerChildController* _tmp8_;
				unity_launcher_application_controller_set_sticky ((_tmp8_ = model_controller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp8_) ? ((UnityLauncherApplicationController*) _tmp8_) : NULL), TRUE);
			}
		}
	}
	clutter_actor_set_opacity ((ClutterActor*) retcont, (guint8) 255);
	retcont->do_not_render = FALSE;
	g_signal_parse_name ("drag-motion", UNITY_DRAG_TYPE_CONTROLLER, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (drag_controller, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _unity_launcher_scroller_controller_on_unity_drag_motion_unity_drag_controller_drag_motion, self);
	g_signal_parse_name ("drag-drop", UNITY_DRAG_TYPE_CONTROLLER, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (drag_controller, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _unity_launcher_scroller_controller_on_unity_drag_drop_unity_drag_controller_drag_drop, self);
	ctk_effect_cache_update_texture_cache (unity_launcher_scroller_view_get_cache (self->priv->_view));
	_g_object_unref0 (retcont);
	_g_object_unref0 (model_controller);
	_g_object_unref0 (drag_controller);
}


static UnityLauncherScrollerChildController* unity_launcher_scroller_controller_get_controller_for_view (UnityLauncherScrollerController* self, UnityLauncherScrollerChild* childview) {
	UnityLauncherScrollerChildController* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (childview != NULL, NULL);
	{
		GeeIterator* _childcontroller_it;
		_childcontroller_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->childcontrollers);
		while (TRUE) {
			UnityLauncherScrollerChildController* childcontroller;
			if (!gee_iterator_next (_childcontroller_it)) {
				break;
			}
			childcontroller = (UnityLauncherScrollerChildController*) gee_iterator_get (_childcontroller_it);
			if (unity_launcher_scroller_child_controller_get_child (childcontroller) == childview) {
				result = childcontroller;
				_g_object_unref0 (_childcontroller_it);
				return result;
			}
			_g_object_unref0 (childcontroller);
		}
		_g_object_unref0 (_childcontroller_it);
	}
	result = NULL;
	return result;
}


static void unity_launcher_scroller_controller_model_order_changed (UnityLauncherScrollerController* self) {
	float index;
	g_return_if_fail (self != NULL);
	index = 1.0f;
	{
		UnityLauncherScrollerModelIterator* _childview_it;
		_childview_it = unity_launcher_scroller_model_iterator (self->priv->_model);
		while (TRUE) {
			UnityLauncherScrollerChild* childview;
			UnityLauncherScrollerChildController* childcontroller;
			if (!unity_launcher_scroller_model_iterator_next (_childview_it)) {
				break;
			}
			childview = unity_launcher_scroller_model_iterator_get (_childview_it);
			childcontroller = unity_launcher_scroller_controller_get_controller_for_view (self, childview);
			if (UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (childcontroller)) {
				UnityLauncherScrollerChildController* _tmp0_;
				unity_launcher_application_controller_set_priority ((_tmp0_ = childcontroller, UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER (_tmp0_) ? ((UnityLauncherApplicationController*) _tmp0_) : NULL), index);
			}
			index = index + 1.0f;
			_g_object_unref0 (childcontroller);
			_g_object_unref0 (childview);
		}
		_unity_launcher_scroller_model_iterator_unref0 (_childview_it);
	}
}


UnityLauncherScrollerModel* unity_launcher_scroller_controller_get_model (UnityLauncherScrollerController* self) {
	UnityLauncherScrollerModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_model;
	return result;
}


static void unity_launcher_scroller_controller_set_model (UnityLauncherScrollerController* self, UnityLauncherScrollerModel* value) {
	UnityLauncherScrollerModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_model = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_model), _tmp0_);
	g_object_notify ((GObject *) self, "model");
}


UnityLauncherScrollerView* unity_launcher_scroller_controller_get_view (UnityLauncherScrollerController* self) {
	UnityLauncherScrollerView* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_view;
	return result;
}


static void unity_launcher_scroller_controller_set_view (UnityLauncherScrollerController* self, UnityLauncherScrollerView* value) {
	UnityLauncherScrollerView* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_view = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_view), _tmp0_);
	g_object_notify ((GObject *) self, "view");
}


static void _unity_launcher_scroller_controller_on_favorite_added_unity_favorites_favorite_added (UnityFavorites* _sender, const char* uid, gpointer self) {
	unity_launcher_scroller_controller_on_favorite_added (self, uid);
}


static void _unity_launcher_scroller_controller_handle_bamf_view_opened_bamf_matcher_view_opened (BamfMatcher* _sender, GObject* object, gpointer self) {
	unity_launcher_scroller_controller_handle_bamf_view_opened (self, object);
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _unity_launcher_scroller_controller_on_unity_drag_start_unity_drag_controller_drag_start (UnityDragController* _sender, UnityDragModel* model, gpointer self) {
	unity_launcher_scroller_controller_on_unity_drag_start (self, model);
}


static void _unity_launcher_scroller_controller_on_super_key_active_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_controller_on_super_key_active (self);
}


static void _unity_launcher_scroller_controller_on_super_key_modifier_release_unity_shell_super_key_modifier_release (UnityShell* _sender, guint keysym, gpointer self) {
	unity_launcher_scroller_controller_on_super_key_modifier_release (self, keysym);
}


static GObject * unity_launcher_scroller_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherScrollerController * self;
	parent_class = G_OBJECT_CLASS (unity_launcher_scroller_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_SCROLLER_CONTROLLER (obj);
	{
		GeeArrayList* _tmp0_;
		BamfMatcher* _tmp1_;
		UnityFavorites* _tmp2_;
		UnityDragController* drag_controller;
		g_signal_connect_object (self->priv->_model, "order-changed", (GCallback) _unity_launcher_scroller_controller_model_order_changed_unity_launcher_scroller_model_order_changed, self, 0);
		self->priv->childcontrollers = (_tmp0_ = gee_array_list_new (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->childcontrollers), _tmp0_);
		self->priv->matcher = (_tmp1_ = _g_object_ref0 (bamf_matcher_get_default ()), _g_object_unref0 (self->priv->matcher), _tmp1_);
		self->priv->favorites = (_tmp2_ = unity_favorites_get_default (), _g_object_unref0 (self->priv->favorites), _tmp2_);
		g_signal_connect_object (self->priv->favorites, "favorite-added", (GCallback) _unity_launcher_scroller_controller_on_favorite_added_unity_favorites_favorite_added, self, 0);
		g_signal_connect_object (self->priv->matcher, "view-opened", (GCallback) _unity_launcher_scroller_controller_handle_bamf_view_opened_bamf_matcher_view_opened, self, 0);
		unity_launcher_scroller_controller_build_favorites (self);
		{
			GList* object_collection;
			GList* object_it;
			object_collection = (GList*) bamf_matcher_get_running_applications (self->priv->matcher);
			for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
				GObject* object;
				object = _g_object_ref0 ((GObject*) ((BamfView*) object_it->data));
				{
					if (BAMF_IS_VIEW (object)) {
						unity_launcher_scroller_controller_handle_bamf_view_opened (self, object);
					} else {
						g_error ("scroller-controller.vala:62: Bamf returned a strange object");
					}
					_g_object_unref0 (object);
				}
			}
			__g_list_free_g_object_unref0 (object_collection);
		}
		drag_controller = _g_object_ref0 (unity_drag_controller_get_default ());
		g_signal_connect_object (drag_controller, "drag-start", (GCallback) _unity_launcher_scroller_controller_on_unity_drag_start_unity_drag_controller_drag_start, self, 0);
		g_signal_connect_object ((GObject*) unity_global_shell, "notify::super-key-active", (GCallback) _unity_launcher_scroller_controller_on_super_key_active_g_object_notify, self, 0);
		g_signal_connect_object (unity_global_shell, "super-key-modifier-release", (GCallback) _unity_launcher_scroller_controller_on_super_key_modifier_release_unity_shell_super_key_modifier_release, self, 0);
		_g_object_unref0 (drag_controller);
	}
	return obj;
}


static void unity_launcher_scroller_controller_class_init (UnityLauncherScrollerControllerClass * klass) {
	unity_launcher_scroller_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherScrollerControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_launcher_scroller_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_launcher_scroller_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_scroller_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_scroller_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CONTROLLER_MODEL, g_param_spec_object ("model", "model", "model", UNITY_LAUNCHER_TYPE_SCROLLER_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CONTROLLER_VIEW, g_param_spec_object ("view", "view", "view", UNITY_LAUNCHER_TYPE_SCROLLER_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void unity_launcher_scroller_controller_instance_init (UnityLauncherScrollerController * self) {
	self->priv = UNITY_LAUNCHER_SCROLLER_CONTROLLER_GET_PRIVATE (self);
	self->priv->super_key_source = (guint) 0;
	self->priv->last_drag_x = 0.0f;
	self->priv->last_drag_y = 0.0f;
}


static void unity_launcher_scroller_controller_finalize (GObject* obj) {
	UnityLauncherScrollerController * self;
	self = UNITY_LAUNCHER_SCROLLER_CONTROLLER (obj);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->childcontrollers);
	_g_object_unref0 (self->priv->matcher);
	_g_object_unref0 (self->priv->favorites);
	G_OBJECT_CLASS (unity_launcher_scroller_controller_parent_class)->finalize (obj);
}


GType unity_launcher_scroller_controller_get_type (void) {
	static volatile gsize unity_launcher_scroller_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherScrollerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_scroller_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherScrollerController), 0, (GInstanceInitFunc) unity_launcher_scroller_controller_instance_init, NULL };
		GType unity_launcher_scroller_controller_type_id;
		unity_launcher_scroller_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLauncherScrollerController", &g_define_type_info, 0);
		g_once_init_leave (&unity_launcher_scroller_controller_type_id__volatile, unity_launcher_scroller_controller_type_id);
	}
	return unity_launcher_scroller_controller_type_id__volatile;
}


static void unity_launcher_scroller_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerController * self;
	self = UNITY_LAUNCHER_SCROLLER_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_CONTROLLER_MODEL:
		g_value_set_object (value, unity_launcher_scroller_controller_get_model (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CONTROLLER_VIEW:
		g_value_set_object (value, unity_launcher_scroller_controller_get_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_launcher_scroller_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerController * self;
	self = UNITY_LAUNCHER_SCROLLER_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_CONTROLLER_MODEL:
		unity_launcher_scroller_controller_set_model (self, g_value_get_object (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CONTROLLER_VIEW:
		unity_launcher_scroller_controller_set_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




