/* places-place-search-sections-bar.c generated by valac 0.10.0, the Vala compiler
 * generated from places-place-search-sections-bar.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutk/clutk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dee.h>
#include <unity.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <cairo.h>


#define UNITY_PLACES_TYPE_SECTION_STYLE (unity_places_section_style_get_type ())

#define UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR (unity_places_place_search_sections_bar_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBar))
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBarClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_SECTIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR))
#define UNITY_PLACES_IS_PLACE_SEARCH_SECTIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR))
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBarClass))

typedef struct _UnityPlacesPlaceSearchSectionsBar UnityPlacesPlaceSearchSectionsBar;
typedef struct _UnityPlacesPlaceSearchSectionsBarClass UnityPlacesPlaceSearchSectionsBarClass;
typedef struct _UnityPlacesPlaceSearchSectionsBarPrivate UnityPlacesPlaceSearchSectionsBarPrivate;

#define UNITY_PLACES_TYPE_PLACE_ENTRY (unity_places_place_entry_get_type ())
#define UNITY_PLACES_PLACE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY, UnityPlacesPlaceEntry))
#define UNITY_PLACES_IS_PLACE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY))
#define UNITY_PLACES_PLACE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY, UnityPlacesPlaceEntryIface))

typedef struct _UnityPlacesPlaceEntry UnityPlacesPlaceEntry;
typedef struct _UnityPlacesPlaceEntryIface UnityPlacesPlaceEntryIface;

#define UNITY_PLACES_TYPE_PLACE (unity_places_place_get_type ())
#define UNITY_PLACES_PLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlace))
#define UNITY_PLACES_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlaceClass))
#define UNITY_PLACES_IS_PLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE))
#define UNITY_PLACES_IS_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE))
#define UNITY_PLACES_PLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlaceClass))

typedef struct _UnityPlacesPlace UnityPlacesPlace;
typedef struct _UnityPlacesPlaceClass UnityPlacesPlaceClass;

#define UNITY_PLACES_TYPE_SECTION (unity_places_section_get_type ())
#define UNITY_PLACES_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_SECTION, UnityPlacesSection))
#define UNITY_PLACES_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_SECTION, UnityPlacesSectionClass))
#define UNITY_PLACES_IS_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_SECTION))
#define UNITY_PLACES_IS_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_SECTION))
#define UNITY_PLACES_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_SECTION, UnityPlacesSectionClass))

typedef struct _UnityPlacesSection UnityPlacesSection;
typedef struct _UnityPlacesSectionClass UnityPlacesSectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityPlacesSectionPrivate UnityPlacesSectionPrivate;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

typedef enum  {
	UNITY_PLACES_SECTION_STYLE_BUTTONS,
	UNITY_PLACES_SECTION_STYLE_BREADCRUMB
} UnityPlacesSectionStyle;

struct _UnityPlacesPlaceSearchSectionsBar {
	CtkBox parent_instance;
	UnityPlacesPlaceSearchSectionsBarPrivate * priv;
	UnityPlacesSectionStyle _style;
	guint active_section_n;
};

struct _UnityPlacesPlaceSearchSectionsBarClass {
	CtkBoxClass parent_class;
};

struct _UnityPlacesPlaceEntryIface {
	GTypeInterface parent_iface;
	void (*connect) (UnityPlacesPlaceEntry* self);
	void (*set_search) (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
	void (*set_active_section) (UnityPlacesPlaceEntry* self, guint section_id);
	void (*set_global_search) (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
	const char* (*get_name) (UnityPlacesPlaceEntry* self);
	void (*set_name) (UnityPlacesPlaceEntry* self, const char* value);
	const char* (*get_icon) (UnityPlacesPlaceEntry* self);
	void (*set_icon) (UnityPlacesPlaceEntry* self, const char* value);
	const char* (*get_description) (UnityPlacesPlaceEntry* self);
	void (*set_description) (UnityPlacesPlaceEntry* self, const char* value);
	guint (*get_position) (UnityPlacesPlaceEntry* self);
	void (*set_position) (UnityPlacesPlaceEntry* self, guint value);
	char** (*get_mimetypes) (UnityPlacesPlaceEntry* self, int* result_length1);
	void (*set_mimetypes) (UnityPlacesPlaceEntry* self, char** value, int value_length1);
	gboolean (*get_sensitive) (UnityPlacesPlaceEntry* self);
	void (*set_sensitive) (UnityPlacesPlaceEntry* self, gboolean value);
	GeeHashMap* (*get_hints) (UnityPlacesPlaceEntry* self);
	void (*set_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	gboolean (*get_online) (UnityPlacesPlaceEntry* self);
	void (*set_online) (UnityPlacesPlaceEntry* self, gboolean value);
	gboolean (*get_active) (UnityPlacesPlaceEntry* self);
	void (*set_active) (UnityPlacesPlaceEntry* self, gboolean value);
	DeeModel* (*get_sections_model) (UnityPlacesPlaceEntry* self);
	void (*set_sections_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	const char* (*get_entry_renderer_name) (UnityPlacesPlaceEntry* self);
	void (*set_entry_renderer_name) (UnityPlacesPlaceEntry* self, const char* value);
	DeeModel* (*get_entry_groups_model) (UnityPlacesPlaceEntry* self);
	void (*set_entry_groups_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	DeeModel* (*get_entry_results_model) (UnityPlacesPlaceEntry* self);
	void (*set_entry_results_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	GeeHashMap* (*get_entry_renderer_hints) (UnityPlacesPlaceEntry* self);
	void (*set_entry_renderer_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	const char* (*get_global_renderer_name) (UnityPlacesPlaceEntry* self);
	void (*set_global_renderer_name) (UnityPlacesPlaceEntry* self, const char* value);
	DeeModel* (*get_global_groups_model) (UnityPlacesPlaceEntry* self);
	void (*set_global_groups_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	DeeModel* (*get_global_results_model) (UnityPlacesPlaceEntry* self);
	void (*set_global_results_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	GeeHashMap* (*get_global_renderer_hints) (UnityPlacesPlaceEntry* self);
	void (*set_global_renderer_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	UnityPlacesPlace* (*get_parent) (UnityPlacesPlaceEntry* self);
	void (*set_parent) (UnityPlacesPlaceEntry* self, UnityPlacesPlace* value);
};

struct _UnityPlacesPlaceSearchSectionsBarPrivate {
	UnityPlacesPlaceEntry* active_entry;
	UnityPlacesSection* active_section;
	UnityCairoCanvas* bg;
	DeeModel* sections_model;
};

struct _UnityPlacesSection {
	CtkBin parent_instance;
	UnityPlacesSectionPrivate * priv;
	CtkText* text;
	gboolean dirty;
};

struct _UnityPlacesSectionClass {
	CtkBinClass parent_class;
};

struct _UnityPlacesSectionPrivate {
	UnityCairoCanvas* bg;
	ClutterColor color;
	CtkEffectGlow* glow;
	gboolean _active;
	DeeModel* _model;
	DeeModelIter* _iter;
	float _destroy_factor;
	float _resize_factor;
	float _last_width;
	float _resize_width;
};


static gpointer unity_places_place_search_sections_bar_parent_class = NULL;
static gpointer unity_places_section_parent_class = NULL;

GType unity_places_section_style_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_sections_bar_get_type (void) G_GNUC_CONST;
GType unity_places_place_get_type (void) G_GNUC_CONST;
GType unity_places_place_entry_get_type (void) G_GNUC_CONST;
GType unity_places_section_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBarPrivate))
enum  {
	UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_DUMMY_PROPERTY,
	UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_STYLE
};
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_PADDING 0.0f
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING 10
UnityPlacesPlaceSearchSectionsBar* unity_places_place_search_sections_bar_new (void);
UnityPlacesPlaceSearchSectionsBar* unity_places_place_search_sections_bar_construct (GType object_type);
void unity_places_place_search_sections_bar_set_active_section (UnityPlacesPlaceSearchSectionsBar* self, guint section_id);
static void unity_places_place_search_sections_bar_on_section_clicked_real (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesSection* section);
void unity_places_place_search_sections_bar_set_active_entry (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesPlaceEntry* entry);
DeeModel* unity_places_place_entry_get_sections_model (UnityPlacesPlaceEntry* self);
static void unity_places_place_search_sections_bar_on_section_added (UnityPlacesPlaceSearchSectionsBar* self, DeeModel* model, DeeModelIter* iter);
static void _unity_places_place_search_sections_bar_on_section_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_places_place_search_sections_bar_on_section_changed (UnityPlacesPlaceSearchSectionsBar* self, DeeModel* model, DeeModelIter* iter);
static void _unity_places_place_search_sections_bar_on_section_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_places_place_search_sections_bar_on_section_removed (UnityPlacesPlaceSearchSectionsBar* self, DeeModel* model, DeeModelIter* iter);
static void _unity_places_place_search_sections_bar_on_section_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
GeeHashMap* unity_places_place_entry_get_hints (UnityPlacesPlaceEntry* self);
void unity_places_place_search_sections_bar_set_style (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesSectionStyle value);
void unity_places_section_set_model (UnityPlacesSection* self, DeeModel* value);
void unity_places_section_set_iter (UnityPlacesSection* self, DeeModelIter* value);
void unity_places_section_set_active (UnityPlacesSection* self, gboolean value);
void unity_places_section_start_destroy (UnityPlacesSection* self);
static gint unity_places_place_search_sections_bar_sort_sections (UnityPlacesSection* asec, UnityPlacesSection* bsec);
DeeModel* unity_places_section_get_model (UnityPlacesSection* self);
DeeModelIter* unity_places_section_get_iter (UnityPlacesSection* self);
UnityPlacesSection* unity_places_section_new (DeeModel* model, DeeModelIter* iter);
UnityPlacesSection* unity_places_section_construct (GType object_type, DeeModel* model, DeeModelIter* iter);
static gboolean unity_places_place_search_sections_bar_on_section_clicked (UnityPlacesPlaceSearchSectionsBar* self, ClutterActor* actor, ClutterEvent* e);
static gboolean _unity_places_place_search_sections_bar_on_section_clicked_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
void unity_places_place_entry_set_active_section (UnityPlacesPlaceEntry* self, guint section_id);
static UnityPlacesSection* unity_places_place_search_sections_bar_get_section_for_iter (UnityPlacesPlaceSearchSectionsBar* self, DeeModelIter* iter);
static void unity_places_place_search_sections_bar_paint_bg (UnityPlacesPlaceSearchSectionsBar* self, cairo_t* cr, gint width, gint height);
gboolean unity_places_section_get_active (UnityPlacesSection* self);
UnityPlacesSectionStyle unity_places_place_search_sections_bar_get_style (UnityPlacesPlaceSearchSectionsBar* self);
static void _unity_places_place_search_sections_bar_paint_bg_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self);
static GObject * unity_places_place_search_sections_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_place_search_sections_bar_finalize (GObject* obj);
static void unity_places_place_search_sections_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_place_search_sections_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLACES_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_SECTION, UnityPlacesSectionPrivate))
enum  {
	UNITY_PLACES_SECTION_DUMMY_PROPERTY,
	UNITY_PLACES_SECTION_NAME,
	UNITY_PLACES_SECTION_ACTIVE,
	UNITY_PLACES_SECTION_MODEL,
	UNITY_PLACES_SECTION_ITER,
	UNITY_PLACES_SECTION_DESTROY_FACTOR,
	UNITY_PLACES_SECTION_RESIZE_FACTOR
};
#define UNITY_PLACES_SECTION_PADDING 4.0f
static void unity_places_section_real_get_preferred_width (ClutterActor* base, float for_height, float* min_width, float* nat_width);
static gboolean unity_places_section_real_enter_event (ClutterActor* base, ClutterEvent* e);
static gboolean unity_places_section_real_leave_event (ClutterActor* base, ClutterEvent* e);
static gboolean unity_places_section_real_button_press_event (ClutterActor* base, ClutterEvent* e);
static gboolean unity_places_section_real_button_release_event (ClutterActor* base, ClutterEvent* e);
static void unity_places_section_paint_bg (UnityPlacesSection* self, cairo_t* cr, gint width, gint height);
const char* unity_places_section_get_name (UnityPlacesSection* self);
void unity_places_section_set_name (UnityPlacesSection* self, const char* value);
float unity_places_section_get_destroy_factor (UnityPlacesSection* self);
void unity_places_section_set_destroy_factor (UnityPlacesSection* self, float value);
float unity_places_section_get_resize_factor (UnityPlacesSection* self);
void unity_places_section_set_resize_factor (UnityPlacesSection* self, float value);
static void _unity_places_section_paint_bg_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self);
static void _lambda41_ (UnityPlacesSection* self);
static void __lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject * unity_places_section_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_section_finalize (GObject* obj);
static void unity_places_section_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_section_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



GType unity_places_section_style_get_type (void) {
	static volatile gsize unity_places_section_style_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_section_style_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_PLACES_SECTION_STYLE_BUTTONS, "UNITY_PLACES_SECTION_STYLE_BUTTONS", "buttons"}, {UNITY_PLACES_SECTION_STYLE_BREADCRUMB, "UNITY_PLACES_SECTION_STYLE_BREADCRUMB", "breadcrumb"}, {0, NULL, NULL}};
		GType unity_places_section_style_type_id;
		unity_places_section_style_type_id = g_enum_register_static ("UnityPlacesSectionStyle", values);
		g_once_init_leave (&unity_places_section_style_type_id__volatile, unity_places_section_style_type_id);
	}
	return unity_places_section_style_type_id__volatile;
}


UnityPlacesPlaceSearchSectionsBar* unity_places_place_search_sections_bar_construct (GType object_type) {
	UnityPlacesPlaceSearchSectionsBar * self;
	self = (UnityPlacesPlaceSearchSectionsBar*) g_object_new (object_type, "orientation", CTK_ORIENTATION_HORIZONTAL, "homogeneous", FALSE, "spacing", UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING, NULL);
	return self;
}


UnityPlacesPlaceSearchSectionsBar* unity_places_place_search_sections_bar_new (void) {
	return unity_places_place_search_sections_bar_construct (UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR);
}


void unity_places_place_search_sections_bar_set_active_section (UnityPlacesPlaceSearchSectionsBar* self, guint section_id) {
	GList* list;
	ClutterActor* _tmp0_;
	UnityPlacesSection* section;
	g_return_if_fail (self != NULL);
	list = clutter_container_get_children ((ClutterContainer*) self);
	section = (_tmp0_ = (ClutterActor*) g_list_nth_data (list, section_id), UNITY_PLACES_IS_SECTION (_tmp0_) ? ((UnityPlacesSection*) _tmp0_) : NULL);
	if (UNITY_PLACES_IS_SECTION (section)) {
		unity_places_place_search_sections_bar_on_section_clicked_real (self, section);
		self->active_section_n = section_id;
	}
	_g_list_free0 (list);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_places_place_search_sections_bar_on_section_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_place_search_sections_bar_on_section_added (self, _sender, iter);
}


static void _unity_places_place_search_sections_bar_on_section_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_place_search_sections_bar_on_section_changed (self, _sender, iter);
}


static void _unity_places_place_search_sections_bar_on_section_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_places_place_search_sections_bar_on_section_removed (self, _sender, iter);
}


void unity_places_place_search_sections_bar_set_active_entry (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesPlaceEntry* entry) {
	GList* children;
	UnityPlacesPlaceEntry* _tmp7_;
	DeeModel* model;
	DeeModelIter* iter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	children = clutter_container_get_children ((ClutterContainer*) self);
	if (entry == self->priv->active_entry) {
		if (self->priv->sections_model == unity_places_place_entry_get_sections_model (entry)) {
			_g_list_free0 (children);
			return;
		}
	}
	if (UNITY_PLACES_IS_PLACE_ENTRY (self->priv->active_entry)) {
		DeeModel* old_model;
		guint _tmp0_;
		guint _tmp1_;
		guint _tmp2_;
		UnityPlacesSection* _tmp3_;
		old_model = _g_object_ref0 (unity_places_place_entry_get_sections_model (self->priv->active_entry));
		g_signal_parse_name ("row-added", DEE_TYPE_MODEL, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (old_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_places_place_search_sections_bar_on_section_added_dee_model_row_added, self);
		g_signal_parse_name ("row-changed", DEE_TYPE_MODEL, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (old_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _unity_places_place_search_sections_bar_on_section_changed_dee_model_row_changed, self);
		g_signal_parse_name ("row-removed", DEE_TYPE_MODEL, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (old_model, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _unity_places_place_search_sections_bar_on_section_removed_dee_model_row_removed, self);
		self->priv->active_section = (_tmp3_ = NULL, _g_object_unref0 (self->priv->active_section), _tmp3_);
		_g_object_unref0 (old_model);
	}
	if (unity_places_place_entry_get_hints (entry) != NULL) {
		char* _tmp4_;
		gboolean _tmp5_;
		if ((_tmp5_ = _vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) unity_places_place_entry_get_hints (entry), "UnitySectionStyle"), "breadcrumb") == 0, _g_free0 (_tmp4_), _tmp5_)) {
			unity_places_place_search_sections_bar_set_style (self, UNITY_PLACES_SECTION_STYLE_BREADCRUMB);
		} else {
			unity_places_place_search_sections_bar_set_style (self, UNITY_PLACES_SECTION_STYLE_BUTTONS);
		}
	} else {
		unity_places_place_search_sections_bar_set_style (self, UNITY_PLACES_SECTION_STYLE_BUTTONS);
	}
	{
		GList* actor_collection;
		GList* actor_it;
		actor_collection = children;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
			actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
			{
				ClutterActor* _tmp6_;
				(_tmp6_ = actor, UNITY_PLACES_IS_SECTION (_tmp6_) ? ((UnityPlacesSection*) _tmp6_) : NULL)->dirty = TRUE;
				_g_object_unref0 (actor);
			}
		}
	}
	self->priv->active_entry = (_tmp7_ = _g_object_ref0 (entry), _g_object_unref0 (self->priv->active_entry), _tmp7_);
	model = _g_object_ref0 (unity_places_place_entry_get_sections_model (self->priv->active_entry));
	self->priv->sections_model = model;
	iter = dee_model_get_first_iter (model);
	while (TRUE) {
		gboolean _tmp8_ = FALSE;
		gboolean updated_local_entry;
		if (iter != NULL) {
			_tmp8_ = !dee_model_is_last (model, iter);
		} else {
			_tmp8_ = FALSE;
		}
		if (!_tmp8_) {
			break;
		}
		updated_local_entry = FALSE;
		{
			GList* actor_collection;
			GList* actor_it;
			actor_collection = children;
			for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
				ClutterActor* actor;
				actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
				{
					ClutterActor* _tmp9_;
					UnityPlacesSection* s;
					s = _g_object_ref0 ((_tmp9_ = actor, UNITY_PLACES_IS_SECTION (_tmp9_) ? ((UnityPlacesSection*) _tmp9_) : NULL));
					if (s->dirty) {
						unity_places_section_set_model (s, model);
						unity_places_section_set_iter (s, iter);
						clutter_text_set_text ((ClutterText*) s->text, dee_model_get_string (model, iter, (guint) 0));
						s->dirty = FALSE;
						updated_local_entry = TRUE;
						if (self->priv->active_section == NULL) {
							UnityPlacesSection* _tmp10_;
							self->priv->active_section = (_tmp10_ = _g_object_ref0 (s), _g_object_unref0 (self->priv->active_section), _tmp10_);
						}
						unity_places_section_set_active (s, self->priv->active_section == s);
						_g_object_unref0 (s);
						_g_object_unref0 (actor);
						break;
					}
					_g_object_unref0 (s);
					_g_object_unref0 (actor);
				}
			}
		}
		if (!updated_local_entry) {
			unity_places_place_search_sections_bar_on_section_added (self, model, iter);
		}
		iter = dee_model_next (model, iter);
	}
	{
		GList* actor_collection;
		GList* actor_it;
		actor_collection = children;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* actor;
			actor = _g_object_ref0 ((ClutterActor*) actor_it->data);
			{
				ClutterActor* _tmp11_;
				UnityPlacesSection* s;
				s = _g_object_ref0 ((_tmp11_ = actor, UNITY_PLACES_IS_SECTION (_tmp11_) ? ((UnityPlacesSection*) _tmp11_) : NULL));
				if (s->dirty) {
					unity_places_section_start_destroy (s);
				}
				_g_object_unref0 (s);
				_g_object_unref0 (actor);
			}
		}
	}
	g_signal_connect_object (model, "row-added", (GCallback) _unity_places_place_search_sections_bar_on_section_added_dee_model_row_added, self, 0);
	g_signal_connect_object (model, "row-changed", (GCallback) _unity_places_place_search_sections_bar_on_section_changed_dee_model_row_changed, self, 0);
	g_signal_connect_object (model, "row-removed", (GCallback) _unity_places_place_search_sections_bar_on_section_removed_dee_model_row_removed, self, 0);
	_g_object_unref0 (model);
	_g_list_free0 (children);
}


static gint unity_places_place_search_sections_bar_sort_sections (UnityPlacesSection* asec, UnityPlacesSection* bsec) {
	gint result = 0;
	g_return_val_if_fail (asec != NULL, 0);
	g_return_val_if_fail (bsec != NULL, 0);
	result = dee_model_get_position (unity_places_section_get_model (asec), unity_places_section_get_iter (asec)) - dee_model_get_position (unity_places_section_get_model (bsec), unity_places_section_get_iter (bsec));
	return result;
}


static gboolean _unity_places_place_search_sections_bar_on_section_clicked_clutter_actor_button_release_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = unity_places_place_search_sections_bar_on_section_clicked (self, _sender, event);
	return result;
}


static void unity_places_place_search_sections_bar_on_section_added (UnityPlacesPlaceSearchSectionsBar* self, DeeModel* model, DeeModelIter* iter) {
	UnityPlacesSection* section;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	section = g_object_ref_sink (unity_places_section_new (model, iter));
	ctk_box_pack ((CtkBox*) self, (ClutterActor*) section, FALSE, TRUE);
	clutter_actor_show ((ClutterActor*) section);
	g_signal_connect_object ((ClutterActor*) section, "button-release-event", (GCallback) _unity_places_place_search_sections_bar_on_section_clicked_clutter_actor_button_release_event, self, 0);
	if (self->priv->active_section == NULL) {
		_tmp0_ = self->_style == UNITY_PLACES_SECTION_STYLE_BUTTONS;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		UnityPlacesSection* _tmp1_;
		self->priv->active_section = (_tmp1_ = _g_object_ref0 (section), _g_object_unref0 (self->priv->active_section), _tmp1_);
		unity_places_section_set_active (section, TRUE);
		unity_places_place_entry_set_active_section (self->priv->active_entry, (guint) 0);
		self->active_section_n = (guint) 0;
	}
	ctk_box_sort_children ((CtkBox*) self, (GCompareFunc) unity_places_place_search_sections_bar_sort_sections);
	_g_object_unref0 (section);
}


static UnityPlacesSection* unity_places_place_search_sections_bar_get_section_for_iter (UnityPlacesPlaceSearchSectionsBar* self, DeeModelIter* iter) {
	UnityPlacesSection* result = NULL;
	GList* children;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	children = clutter_container_get_children ((ClutterContainer*) self);
	{
		GList* child_collection;
		GList* child_it;
		child_collection = children;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child;
			child = _g_object_ref0 ((ClutterActor*) child_it->data);
			{
				ClutterActor* _tmp0_;
				UnityPlacesSection* section;
				section = _g_object_ref0 ((_tmp0_ = child, UNITY_PLACES_IS_SECTION (_tmp0_) ? ((UnityPlacesSection*) _tmp0_) : NULL));
				if (unity_places_section_get_iter (section) == iter) {
					result = section;
					_g_object_unref0 (child);
					_g_list_free0 (children);
					return result;
				}
				_g_object_unref0 (section);
				_g_object_unref0 (child);
			}
		}
	}
	result = NULL;
	_g_list_free0 (children);
	return result;
}


static void unity_places_place_search_sections_bar_on_section_changed (UnityPlacesPlaceSearchSectionsBar* self, DeeModel* model, DeeModelIter* iter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
}


static void unity_places_place_search_sections_bar_on_section_removed (UnityPlacesPlaceSearchSectionsBar* self, DeeModel* model, DeeModelIter* iter) {
	UnityPlacesSection* section;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	section = unity_places_place_search_sections_bar_get_section_for_iter (self, iter);
	if (UNITY_PLACES_IS_SECTION (section)) {
		gboolean _tmp0_ = FALSE;
		if (section == self->priv->active_section) {
			_tmp0_ = self->_style == UNITY_PLACES_SECTION_STYLE_BUTTONS;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			UnityPlacesSection* _tmp1_;
			self->priv->active_section = (_tmp1_ = unity_places_place_search_sections_bar_get_section_for_iter (self, dee_model_get_first_iter (model)), _g_object_unref0 (self->priv->active_section), _tmp1_);
			unity_places_place_entry_set_active_section (self->priv->active_entry, (guint) 0);
			self->active_section_n = (guint) 0;
		}
		unity_places_section_start_destroy (section);
	}
	_g_object_unref0 (section);
}


static void unity_places_place_search_sections_bar_on_section_clicked_real (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesSection* section) {
	UnityPlacesSection* _tmp0_;
	gint pos;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	unity_places_section_set_active (self->priv->active_section, FALSE);
	self->priv->active_section = (_tmp0_ = _g_object_ref0 (section), _g_object_unref0 (self->priv->active_section), _tmp0_);
	unity_places_section_set_active (self->priv->active_section, TRUE);
	pos = dee_model_get_position (unity_places_section_get_model (self->priv->active_section), unity_places_section_get_iter (self->priv->active_section));
	unity_places_place_entry_set_active_section (self->priv->active_entry, (guint) pos);
	self->active_section_n = (guint) pos;
	unity_cairo_canvas_update (self->priv->bg);
}


static gboolean unity_places_place_search_sections_bar_on_section_clicked (UnityPlacesPlaceSearchSectionsBar* self, ClutterActor* actor, ClutterEvent* e) {
	gboolean result = FALSE;
	ClutterActor* _tmp0_;
	UnityPlacesSection* section;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	section = _g_object_ref0 ((_tmp0_ = actor, UNITY_PLACES_IS_SECTION (_tmp0_) ? ((UnityPlacesSection*) _tmp0_) : NULL));
	if (section == self->priv->active_section) {
		result = TRUE;
		_g_object_unref0 (section);
		return result;
	}
	if ((*e).button.button != 1) {
		result = FALSE;
		_g_object_unref0 (section);
		return result;
	}
	unity_places_place_search_sections_bar_on_section_clicked_real (self, section);
	result = TRUE;
	_g_object_unref0 (section);
	return result;
}


static void unity_places_place_search_sections_bar_paint_bg (UnityPlacesPlaceSearchSectionsBar* self, cairo_t* cr, gint width, gint height) {
	gint x;
	gint y;
	gint radius;
	gint point;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_translate (cr, 0.5, 0.5);
	cairo_set_line_width (cr, 1.0);
	x = 0;
	y = 0;
	width = width - 1;
	height = height - 1;
	radius = 5;
	point = x - 1;
	if (self->_style != UNITY_PLACES_SECTION_STYLE_BREADCRUMB) {
		GList* children;
		UnityPlacesSection* last_sec;
		children = clutter_container_get_children ((ClutterContainer*) self);
		last_sec = NULL;
		point = point - (UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING / 2);
		{
			GList* child_collection;
			GList* child_it;
			child_collection = children;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				ClutterActor* child;
				child = _g_object_ref0 ((ClutterActor*) child_it->data);
				{
					ClutterActor* _tmp0_;
					UnityPlacesSection* sec;
					gboolean _tmp1_ = FALSE;
					gboolean _tmp2_ = FALSE;
					sec = (_tmp0_ = child, UNITY_PLACES_IS_SECTION (_tmp0_) ? ((UnityPlacesSection*) _tmp0_) : NULL);
					if (point < (width - UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING)) {
						gboolean _tmp3_ = FALSE;
						if (last_sec == NULL) {
							_tmp3_ = TRUE;
						} else {
							_tmp3_ = unity_places_section_get_active (last_sec) == FALSE;
						}
						_tmp2_ = _tmp3_;
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						_tmp1_ = unity_places_section_get_active (sec) != TRUE;
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						cairo_pattern_t* pat;
						cairo_pattern_t* _tmp4_;
						cairo_rectangle (cr, (double) point, (double) y, 0.5, (double) height);
						pat = cairo_pattern_create_linear ((double) x, (double) y, (double) x, (double) (y + height));
						cairo_pattern_add_color_stop_rgba (pat, 0.0, 0.0, 0.0, 0.0, 0.0);
						cairo_pattern_add_color_stop_rgba (pat, 0.5, 0.0, 0.0, 0.0, 0.5);
						cairo_pattern_add_color_stop_rgba (pat, 1.0, 0.0, 0.0, 0.0, 0.0);
						cairo_set_source (cr, pat);
						cairo_fill (cr);
						cairo_rectangle (cr, (double) (point + 1), (double) y, 0.5, (double) height);
						pat = (_tmp4_ = cairo_pattern_create_linear ((double) x, (double) y, (double) x, (double) (y + height)), _cairo_pattern_destroy0 (pat), _tmp4_);
						cairo_pattern_add_color_stop_rgba (pat, 0.0, 1.0, 1.0, 1.0, 0.0);
						cairo_pattern_add_color_stop_rgba (pat, 0.5, 1.0, 1.0, 1.0, 0.5);
						cairo_pattern_add_color_stop_rgba (pat, 1.0, 1.0, 1.0, 1.0, 0.0);
						cairo_set_source (cr, pat);
						cairo_fill (cr);
						_cairo_pattern_destroy0 (pat);
					}
					point = point + (((gint) clutter_actor_get_width (child)) + UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING);
					last_sec = sec;
					_g_object_unref0 (child);
				}
			}
		}
		_g_list_free0 (children);
	} else {
		gint chevron;
		GList* children;
		cairo_line_to (cr, (double) x, (double) (y + radius));
		cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
		cairo_line_to (cr, (double) (width - radius), (double) y);
		cairo_curve_to (cr, (double) width, (double) y, (double) width, (double) y, (double) width, (double) (y + radius));
		cairo_line_to (cr, (double) width, (double) (height - radius));
		cairo_curve_to (cr, (double) width, (double) height, (double) width, (double) height, (double) (width - radius), (double) height);
		cairo_line_to (cr, (double) (x + radius), (double) height);
		cairo_curve_to (cr, (double) x, (double) height, (double) x, (double) height, (double) x, (double) (height - radius));
		cairo_close_path (cr);
		cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.25);
		cairo_fill_preserve (cr);
		cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.25);
		cairo_stroke (cr);
		chevron = 5;
		children = clutter_container_get_children ((ClutterContainer*) self);
		point = x;
		{
			GList* child_collection;
			GList* child_it;
			child_collection = children;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				ClutterActor* child;
				child = _g_object_ref0 ((ClutterActor*) child_it->data);
				{
					point = point + (((gint) clutter_actor_get_width (child)) + (UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING / 2));
					if (point < ((width - chevron) - UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING)) {
						cairo_move_to (cr, (double) (point - chevron), (double) y);
						cairo_line_to (cr, (double) (point + chevron), (double) (y + (height / 2)));
						cairo_line_to (cr, (double) (point - chevron), (double) (y + height));
						cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.5);
						cairo_stroke (cr);
					}
					point = point + (UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_SPACING / 2);
					_g_object_unref0 (child);
				}
			}
		}
		_g_list_free0 (children);
	}
}


UnityPlacesSectionStyle unity_places_place_search_sections_bar_get_style (UnityPlacesPlaceSearchSectionsBar* self) {
	UnityPlacesSectionStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->_style;
	return result;
}


void unity_places_place_search_sections_bar_set_style (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesSectionStyle value) {
	g_return_if_fail (self != NULL);
	if (self->_style != value) {
		self->_style = value;
		clutter_actor_queue_redraw ((ClutterActor*) self);
	}
	g_object_notify ((GObject *) self, "style");
}


static void _unity_places_place_search_sections_bar_paint_bg_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self) {
	unity_places_place_search_sections_bar_paint_bg (self, cr, width, height);
}


static GObject * unity_places_place_search_sections_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesPlaceSearchSectionsBar * self;
	parent_class = G_OBJECT_CLASS (unity_places_place_search_sections_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR (obj);
	{
		CtkPadding _tmp0_ = {0};
		CtkPadding _tmp1_;
		UnityCairoCanvas* _tmp2_;
		ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = 0.0f, _tmp0_.right = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_PADDING, _tmp0_.bottom = 0.0f, _tmp0_.left = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_PADDING, _tmp0_), &_tmp1_));
		self->priv->bg = (_tmp2_ = g_object_ref_sink (unity_cairo_canvas_new (_unity_places_place_search_sections_bar_paint_bg_unity_cairo_canvas_cairo_canvas_paint, self)), _g_object_unref0 (self->priv->bg), _tmp2_);
		ctk_actor_set_background ((CtkActor*) self, (ClutterActor*) self->priv->bg);
	}
	return obj;
}


static void unity_places_place_search_sections_bar_class_init (UnityPlacesPlaceSearchSectionsBarClass * klass) {
	unity_places_place_search_sections_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesPlaceSearchSectionsBarPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_places_place_search_sections_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_place_search_sections_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_place_search_sections_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_place_search_sections_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_STYLE, g_param_spec_enum ("style", "style", "style", UNITY_PLACES_TYPE_SECTION_STYLE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_places_place_search_sections_bar_instance_init (UnityPlacesPlaceSearchSectionsBar * self) {
	self->priv = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_GET_PRIVATE (self);
	self->_style = UNITY_PLACES_SECTION_STYLE_BUTTONS;
	self->priv->active_entry = NULL;
	self->priv->active_section = NULL;
	self->active_section_n = (guint) 0;
	self->priv->sections_model = NULL;
}


static void unity_places_place_search_sections_bar_finalize (GObject* obj) {
	UnityPlacesPlaceSearchSectionsBar * self;
	self = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR (obj);
	_g_object_unref0 (self->priv->active_entry);
	_g_object_unref0 (self->priv->active_section);
	_g_object_unref0 (self->priv->bg);
	G_OBJECT_CLASS (unity_places_place_search_sections_bar_parent_class)->finalize (obj);
}


GType unity_places_place_search_sections_bar_get_type (void) {
	static volatile gsize unity_places_place_search_sections_bar_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_place_search_sections_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesPlaceSearchSectionsBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_place_search_sections_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesPlaceSearchSectionsBar), 0, (GInstanceInitFunc) unity_places_place_search_sections_bar_instance_init, NULL };
		GType unity_places_place_search_sections_bar_type_id;
		unity_places_place_search_sections_bar_type_id = g_type_register_static (CTK_TYPE_BOX, "UnityPlacesPlaceSearchSectionsBar", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_place_search_sections_bar_type_id__volatile, unity_places_place_search_sections_bar_type_id);
	}
	return unity_places_place_search_sections_bar_type_id__volatile;
}


static void unity_places_place_search_sections_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceSearchSectionsBar * self;
	self = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_STYLE:
		g_value_set_enum (value, unity_places_place_search_sections_bar_get_style (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_place_search_sections_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceSearchSectionsBar * self;
	self = UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_STYLE:
		unity_places_place_search_sections_bar_set_style (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlacesSection* unity_places_section_construct (GType object_type, DeeModel* model, DeeModelIter* iter) {
	UnityPlacesSection * self;
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	self = (UnityPlacesSection*) g_object_new (object_type, "reactive", TRUE, "model", model, "iter", iter, NULL);
	return self;
}


UnityPlacesSection* unity_places_section_new (DeeModel* model, DeeModelIter* iter) {
	return unity_places_section_construct (UNITY_PLACES_TYPE_SECTION, model, iter);
}


void unity_places_section_start_destroy (UnityPlacesSection* self) {
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	clutter_container_remove_actor ((_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self), CLUTTER_IS_CONTAINER (_tmp0_) ? ((ClutterContainer*) _tmp0_) : NULL), (ClutterActor*) self);
}


static void unity_places_section_real_get_preferred_width (ClutterActor* base, float for_height, float* min_width, float* nat_width) {
	UnityPlacesSection * self;
	float mw = 0.0F;
	float nw = 0.0F;
	CtkPadding _tmp0_ = {0};
	CtkPadding _tmp1_ = {0};
	CtkPadding _tmp2_ = {0};
	CtkPadding _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	self = (UnityPlacesSection*) base;
	CLUTTER_ACTOR_CLASS (unity_places_section_parent_class)->get_preferred_width ((ClutterActor*) CTK_BIN (self), for_height, &mw, &nw);
	*min_width = ((mw + (ctk_actor_get_padding ((CtkActor*) self, &_tmp0_), _tmp0_.right)) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp1_), _tmp1_.left)) * self->priv->_destroy_factor;
	*nat_width = ((nw + (ctk_actor_get_padding ((CtkActor*) self, &_tmp2_), _tmp2_.right)) + (ctk_actor_get_padding ((CtkActor*) self, &_tmp3_), _tmp3_.left)) * self->priv->_destroy_factor;
	if (self->priv->_last_width == 0.0f) {
		self->priv->_last_width = *nat_width;
	}
	if (self->priv->_last_width != (*nat_width)) {
		_tmp4_ = self->priv->_resize_factor == 1.0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		self->priv->_resize_factor = 0.0f;
		clutter_actor_animate ((ClutterActor*) self, (gulong) CLUTTER_EASE_OUT_QUAD, (guint) 100, "resize_factor", 1.0f, NULL);
		self->priv->_resize_width = self->priv->_last_width;
		self->priv->_last_width = *nat_width;
	}
	if (self->priv->_resize_factor != 1.0f) {
		*min_width = self->priv->_resize_width + (((*min_width) - self->priv->_resize_width) * self->priv->_resize_factor);
		*nat_width = self->priv->_resize_width + (((*nat_width) - self->priv->_resize_width) * self->priv->_resize_factor);
	}
}


static gboolean unity_places_section_real_enter_event (ClutterActor* base, ClutterEvent* e) {
	UnityPlacesSection * self;
	gboolean result = FALSE;
	self = (UnityPlacesSection*) base;
	ctk_actor_set_state ((CtkActor*) self, CTK_STATE_PRELIGHT);
	unity_cairo_canvas_update (self->priv->bg);
	result = TRUE;
	return result;
}


static gboolean unity_places_section_real_leave_event (ClutterActor* base, ClutterEvent* e) {
	UnityPlacesSection * self;
	gboolean result = FALSE;
	self = (UnityPlacesSection*) base;
	ctk_actor_set_state ((CtkActor*) self, CTK_STATE_NORMAL);
	unity_cairo_canvas_update (self->priv->bg);
	result = TRUE;
	return result;
}


static gboolean unity_places_section_real_button_press_event (ClutterActor* base, ClutterEvent* e) {
	UnityPlacesSection * self;
	gboolean result = FALSE;
	self = (UnityPlacesSection*) base;
	ctk_actor_set_state ((CtkActor*) self, CTK_STATE_SELECTED);
	unity_cairo_canvas_update (self->priv->bg);
	result = FALSE;
	return result;
}


static gboolean unity_places_section_real_button_release_event (ClutterActor* base, ClutterEvent* e) {
	UnityPlacesSection * self;
	gboolean result = FALSE;
	self = (UnityPlacesSection*) base;
	ctk_actor_set_state ((CtkActor*) self, CTK_STATE_PRELIGHT);
	unity_cairo_canvas_update (self->priv->bg);
	result = FALSE;
	return result;
}


static void unity_places_section_paint_bg (UnityPlacesSection* self, cairo_t* cr, gint width, gint height) {
	gint x;
	gint y;
	gint radius;
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_line_width (cr, 1.0);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.0);
	x = 0;
	y = 0;
	radius = 7;
	if (unity_places_place_search_sections_bar_get_style ((_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self), UNITY_PLACES_IS_PLACE_SEARCH_SECTIONS_BAR (_tmp0_) ? ((UnityPlacesPlaceSearchSectionsBar*) _tmp0_) : NULL)) == UNITY_PLACES_SECTION_STYLE_BUTTONS) {
		gboolean _tmp1_ = FALSE;
		double _tmp2_ = 0.0;
		gboolean _tmp3_ = FALSE;
		cairo_move_to (cr, (double) x, (double) (y + radius));
		cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
		cairo_line_to (cr, (double) (width - radius), (double) y);
		cairo_curve_to (cr, (double) width, (double) y, (double) width, (double) y, (double) width, (double) (y + radius));
		cairo_line_to (cr, (double) width, (double) (height - radius));
		cairo_curve_to (cr, (double) width, (double) height, (double) width, (double) height, (double) (width - radius), (double) height);
		cairo_line_to (cr, (double) (x + radius), (double) height);
		cairo_curve_to (cr, (double) x, (double) height, (double) x, (double) height, (double) x, (double) (height - radius));
		cairo_close_path (cr);
		if (unity_places_section_get_active (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ctk_actor_get_state ((CtkActor*) self) == CTK_STATE_SELECTED;
		}
		if (_tmp1_) {
			cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 1.0);
			cairo_fill (cr);
		} else {
			if (ctk_actor_get_state ((CtkActor*) self) == CTK_STATE_PRELIGHT) {
				cairo_surface_t* pattern;
				cairo_t* context;
				cairo_pattern_t* pat;
				pattern = cairo_surface_create_similar (cairo_get_target (cr), CAIRO_CONTENT_COLOR_ALPHA, 4, 4);
				context = cairo_create (pattern);
				cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.1);
				cairo_fill_preserve (cr);
				cairo_set_operator (context, CAIRO_OPERATOR_CLEAR);
				cairo_paint (context);
				cairo_set_line_width (context, 0.2);
				cairo_set_operator (context, CAIRO_OPERATOR_OVER);
				cairo_set_source_rgba (context, 1.0, 1.0, 1.0, 0.85);
				cairo_move_to (context, (double) 0, (double) 0);
				cairo_line_to (context, (double) 4, (double) 4);
				cairo_stroke (context);
				pat = cairo_pattern_create_for_surface (pattern);
				cairo_pattern_set_extend (pat, CAIRO_EXTEND_REPEAT);
				cairo_set_source (cr, pat);
				cairo_fill (cr);
				_cairo_pattern_destroy0 (pat);
				_cairo_destroy0 (context);
				_cairo_surface_destroy0 (pattern);
			} else {
			}
		}
		cairo_translate (cr, 0.5, 0.5);
		width = width - 1;
		height = height - 1;
		cairo_move_to (cr, (double) x, (double) (y + radius));
		cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
		cairo_line_to (cr, (double) (width - radius), (double) y);
		cairo_curve_to (cr, (double) width, (double) y, (double) width, (double) y, (double) width, (double) (y + radius));
		cairo_line_to (cr, (double) width, (double) (height - radius));
		cairo_curve_to (cr, (double) width, (double) height, (double) width, (double) height, (double) (width - radius), (double) height);
		cairo_line_to (cr, (double) (x + radius), (double) height);
		cairo_curve_to (cr, (double) x, (double) height, (double) x, (double) height, (double) x, (double) (height - radius));
		cairo_close_path (cr);
		if (!unity_places_section_get_active (self)) {
			_tmp3_ = ctk_actor_get_state ((CtkActor*) self) == CTK_STATE_NORMAL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = 0.0;
		} else {
			_tmp2_ = 0.5;
		}
		cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, _tmp2_);
		cairo_stroke (cr);
	} else {
	}
}


const char* unity_places_section_get_name (UnityPlacesSection* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = clutter_text_get_text ((ClutterText*) self->text);
	return result;
}


void unity_places_section_set_name (UnityPlacesSection* self, const char* value) {
	g_return_if_fail (self != NULL);
	clutter_text_set_text ((ClutterText*) self->text, value);
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->glow, TRUE);
	g_object_notify ((GObject *) self, "name");
}


gboolean unity_places_section_get_active (UnityPlacesSection* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_places_section_set_active (UnityPlacesSection* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_active != value) {
		self->priv->_active = value;
		if (self->priv->_active) {
			ClutterColor _tmp0_ = {0};
			ClutterColor _tmp1_;
			clutter_text_set_color ((ClutterText*) self->text, (_tmp1_ = (_tmp0_.red = (guint8) 50, _tmp0_.green = (guint8) 50, _tmp0_.blue = (guint8) 50, _tmp0_.alpha = (guint8) 255, _tmp0_), &_tmp1_));
		} else {
			ClutterColor _tmp2_ = {0};
			ClutterColor _tmp3_;
			clutter_text_set_color ((ClutterText*) self->text, (_tmp3_ = (_tmp2_.red = (guint8) 255, _tmp2_.green = (guint8) 255, _tmp2_.blue = (guint8) 255, _tmp2_.alpha = (guint8) 255, _tmp2_), &_tmp3_));
		}
	}
	unity_cairo_canvas_update (self->priv->bg);
	g_object_notify ((GObject *) self, "active");
}


DeeModel* unity_places_section_get_model (UnityPlacesSection* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_model;
	return result;
}


void unity_places_section_set_model (UnityPlacesSection* self, DeeModel* value) {
	g_return_if_fail (self != NULL);
	self->priv->_model = value;
	g_object_notify ((GObject *) self, "model");
}


DeeModelIter* unity_places_section_get_iter (UnityPlacesSection* self) {
	DeeModelIter* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_iter;
	return result;
}


void unity_places_section_set_iter (UnityPlacesSection* self, DeeModelIter* value) {
	g_return_if_fail (self != NULL);
	self->priv->_iter = value;
	g_object_notify ((GObject *) self, "iter");
}


float unity_places_section_get_destroy_factor (UnityPlacesSection* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_destroy_factor;
	return result;
}


void unity_places_section_set_destroy_factor (UnityPlacesSection* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_destroy_factor = value;
	clutter_actor_queue_relayout ((ClutterActor*) self);
	g_object_notify ((GObject *) self, "destroy-factor");
}


float unity_places_section_get_resize_factor (UnityPlacesSection* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_resize_factor;
	return result;
}


void unity_places_section_set_resize_factor (UnityPlacesSection* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_resize_factor = value;
	clutter_actor_queue_relayout ((ClutterActor*) self);
	g_object_notify ((GObject *) self, "resize-factor");
}


static void _unity_places_section_paint_bg_unity_cairo_canvas_cairo_canvas_paint (cairo_t* cr, gint width, gint height, gpointer self) {
	unity_places_section_paint_bg (self, cr, width, height);
}


static void _lambda41_ (UnityPlacesSection* self) {
	if (unity_places_section_get_active (self)) {
		return;
	}
	if (ctk_actor_get_state ((CtkActor*) self) == CTK_STATE_SELECTED) {
		ClutterColor _tmp0_ = {0};
		ClutterColor _tmp1_;
		clutter_text_set_color ((ClutterText*) self->text, (_tmp1_ = (_tmp0_.red = (guint8) 50, _tmp0_.green = (guint8) 50, _tmp0_.blue = (guint8) 50, _tmp0_.alpha = (guint8) 200, _tmp0_), &_tmp1_));
	} else {
		ClutterColor _tmp2_ = {0};
		ClutterColor _tmp3_;
		clutter_text_set_color ((ClutterText*) self->text, (_tmp3_ = (_tmp2_.red = (guint8) 255, _tmp2_.green = (guint8) 255, _tmp2_.blue = (guint8) 255, _tmp2_.alpha = (guint8) 255, _tmp2_), &_tmp3_));
	}
}


static void __lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda41_ (self);
}


static GObject * unity_places_section_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesSection * self;
	parent_class = G_OBJECT_CLASS (unity_places_section_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_SECTION (obj);
	{
		CtkPadding _tmp0_ = {0};
		CtkPadding _tmp1_;
		UnityCairoCanvas* _tmp2_;
		CtkEffectGlow* _tmp3_;
		ClutterColor _tmp4_ = {0};
		ClutterColor _tmp5_;
		CtkText* _tmp6_;
		self->priv->color.alpha = (guint8) 255;
		ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = UNITY_PLACES_SECTION_PADDING, _tmp0_.right = UNITY_PLACES_SECTION_PADDING, _tmp0_.bottom = UNITY_PLACES_SECTION_PADDING, _tmp0_.left = UNITY_PLACES_SECTION_PADDING, _tmp0_), &_tmp1_));
		self->priv->bg = (_tmp2_ = g_object_ref_sink (unity_cairo_canvas_new (_unity_places_section_paint_bg_unity_cairo_canvas_cairo_canvas_paint, self)), _g_object_unref0 (self->priv->bg), _tmp2_);
		ctk_actor_set_background ((CtkActor*) self, (ClutterActor*) self->priv->bg);
		clutter_actor_show ((ClutterActor*) self->priv->bg);
		self->priv->glow = (_tmp3_ = g_object_ref_sink ((CtkEffectGlow*) ctk_effect_glow_new ()), _g_object_unref0 (self->priv->glow), _tmp3_);
		ctk_effect_glow_set_color (self->priv->glow, (_tmp5_ = (_tmp4_.red = (guint8) 255, _tmp4_.green = (guint8) 255, _tmp4_.blue = (guint8) 255, _tmp4_.alpha = (guint8) 255, _tmp4_), &_tmp5_));
		ctk_effect_glow_set_factor (self->priv->glow, 1.0f);
		ctk_effect_set_margin ((CtkEffect*) self->priv->glow, 5);
		self->text = (_tmp6_ = g_object_ref_sink ((CtkText*) ctk_text_new (dee_model_get_string (self->priv->_model, self->priv->_iter, (guint) 0))), _g_object_unref0 (self->text), _tmp6_);
		clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->text);
		clutter_actor_show ((ClutterActor*) self->text);
		g_signal_connect_object ((GObject*) self, "notify::state", (GCallback) __lambda41__g_object_notify, self, 0);
	}
	return obj;
}


static void unity_places_section_class_init (UnityPlacesSectionClass * klass) {
	unity_places_section_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesSectionPrivate));
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_width = unity_places_section_real_get_preferred_width;
	CLUTTER_ACTOR_CLASS (klass)->enter_event = unity_places_section_real_enter_event;
	CLUTTER_ACTOR_CLASS (klass)->leave_event = unity_places_section_real_leave_event;
	CLUTTER_ACTOR_CLASS (klass)->button_press_event = unity_places_section_real_button_press_event;
	CLUTTER_ACTOR_CLASS (klass)->button_release_event = unity_places_section_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = unity_places_section_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_section_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_section_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_section_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_SECTION_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_SECTION_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_SECTION_MODEL, g_param_spec_object ("model", "model", "model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_SECTION_ITER, g_param_spec_pointer ("iter", "iter", "iter", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_SECTION_DESTROY_FACTOR, g_param_spec_float ("destroy-factor", "destroy-factor", "destroy-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_SECTION_RESIZE_FACTOR, g_param_spec_float ("resize-factor", "resize-factor", "resize-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_places_section_instance_init (UnityPlacesSection * self) {
	self->priv = UNITY_PLACES_SECTION_GET_PRIVATE (self);
	self->dirty = FALSE;
	self->priv->_active = FALSE;
	self->priv->_destroy_factor = 1.0f;
	self->priv->_resize_factor = 1.0f;
	self->priv->_last_width = 0.0f;
	self->priv->_resize_width = 0.0f;
}


static void unity_places_section_finalize (GObject* obj) {
	UnityPlacesSection * self;
	self = UNITY_PLACES_SECTION (obj);
	_g_object_unref0 (self->priv->bg);
	_g_object_unref0 (self->text);
	_g_object_unref0 (self->priv->glow);
	G_OBJECT_CLASS (unity_places_section_parent_class)->finalize (obj);
}


GType unity_places_section_get_type (void) {
	static volatile gsize unity_places_section_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_section_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesSection), 0, (GInstanceInitFunc) unity_places_section_instance_init, NULL };
		GType unity_places_section_type_id;
		unity_places_section_type_id = g_type_register_static (CTK_TYPE_BIN, "UnityPlacesSection", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_section_type_id__volatile, unity_places_section_type_id);
	}
	return unity_places_section_type_id__volatile;
}


static void unity_places_section_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesSection * self;
	self = UNITY_PLACES_SECTION (object);
	switch (property_id) {
		case UNITY_PLACES_SECTION_NAME:
		g_value_set_string (value, unity_places_section_get_name (self));
		break;
		case UNITY_PLACES_SECTION_ACTIVE:
		g_value_set_boolean (value, unity_places_section_get_active (self));
		break;
		case UNITY_PLACES_SECTION_MODEL:
		g_value_set_object (value, unity_places_section_get_model (self));
		break;
		case UNITY_PLACES_SECTION_ITER:
		g_value_set_pointer (value, unity_places_section_get_iter (self));
		break;
		case UNITY_PLACES_SECTION_DESTROY_FACTOR:
		g_value_set_float (value, unity_places_section_get_destroy_factor (self));
		break;
		case UNITY_PLACES_SECTION_RESIZE_FACTOR:
		g_value_set_float (value, unity_places_section_get_resize_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_section_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesSection * self;
	self = UNITY_PLACES_SECTION (object);
	switch (property_id) {
		case UNITY_PLACES_SECTION_NAME:
		unity_places_section_set_name (self, g_value_get_string (value));
		break;
		case UNITY_PLACES_SECTION_ACTIVE:
		unity_places_section_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_PLACES_SECTION_MODEL:
		unity_places_section_set_model (self, g_value_get_object (value));
		break;
		case UNITY_PLACES_SECTION_ITER:
		unity_places_section_set_iter (self, g_value_get_pointer (value));
		break;
		case UNITY_PLACES_SECTION_DESTROY_FACTOR:
		unity_places_section_set_destroy_factor (self, g_value_get_float (value));
		break;
		case UNITY_PLACES_SECTION_RESIZE_FACTOR:
		unity_places_section_set_resize_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




