/* clutter-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Clutter", lower_case_cprefix = "clutter_")]
namespace Clutter {
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Actor : GLib.InitiallyUnowned, Clutter.Scriptable {
		public uint32 flags;
		public weak GLib.InitiallyUnowned parent_instance;
		public Clutter.ActorPrivate priv;
		public uint32 private_flags;
		public virtual void allocate (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public void allocate_available_size (float x, float y, float available_width, float available_height, Clutter.AllocationFlags flags);
		public void allocate_preferred_size (Clutter.AllocationFlags flags);
		public unowned Clutter.Animation animate (ulong mode, uint duration, string first_property_name, ...);
		public unowned Clutter.Animation animate_with_alpha (Clutter.Alpha alpha, string first_property_name, ...);
		public unowned Clutter.Animation animate_with_alphav (Clutter.Alpha alpha, [CCode (array_length_pos = 0)] string[] properties, [CCode (array_length = false)] GLib.Value[] values);
		public unowned Clutter.Animation animate_with_timeline (ulong mode, Clutter.Timeline timeline, string first_property_name, ...);
		public unowned Clutter.Animation animate_with_timelinev (ulong mode, Clutter.Timeline timeline, [CCode (array_length_pos = 0)] string[] properties, [CCode (array_length = false)] GLib.Value[] values);
		public unowned Clutter.Animation animatev (ulong mode, uint duration, [CCode (array_length_pos = 0)] string[] properties, [CCode (array_length = false)] GLib.Value[] values);
		public void apply_relative_transform_to_point (Clutter.Actor? ancestor, Clutter.Vertex point, Clutter.Vertex vertex);
		public virtual void apply_transform (Cogl.Matrix matrix);
		public void apply_transform_to_point (Clutter.Vertex point, Clutter.Vertex vertex);
		public Pango.Context create_pango_context ();
		public Pango.Layout create_pango_layout (string? text);
		public void get_abs_allocation_vertices ([CCode (array_length = false)] out Clutter.Vertex[] verts);
		public void get_allocation_box (out Clutter.ActorBox box);
		public void get_allocation_geometry (out Clutter.Geometry geom);
		public void get_allocation_vertices (Clutter.Actor? ancestor, [CCode (array_length = false)] out Clutter.Vertex[] verts);
		public void get_anchor_point (out float anchor_x, out float anchor_y);
		public Clutter.Gravity get_anchor_point_gravity ();
		public unowned Clutter.Animation get_animation ();
		public void get_clip (out float? xoff, out float? yoff, out float? width, out float? height);
		public float get_depth ();
		public bool get_fixed_position_set ();
		public Clutter.ActorFlags get_flags ();
		public void get_geometry (out Clutter.Geometry geometry);
		public uint32 get_gid ();
		public float get_height ();
		public unowned string get_name ();
		public uint8 get_opacity ();
		public uint8 get_paint_opacity ();
		public bool get_paint_visibility ();
		public unowned Pango.Context get_pango_context ();
		public unowned Clutter.Actor get_parent ();
		public void get_position (out float? x, out float? y);
		public virtual void get_preferred_height (float for_width, out float min_height_p, out float natural_height_p);
		public void get_preferred_size (out float? min_width_p, out float? min_height_p, out float? natural_width_p, out float? natural_height_p);
		public virtual void get_preferred_width (float for_height, out float min_width_p, out float natural_width_p);
		public bool get_reactive ();
		public double get_rotation (Clutter.RotateAxis axis, out float x, out float y, out float z);
		public void get_scale (out double? scale_x, out double? scale_y);
		public void get_scale_center (out float? center_x, out float? center_y);
		public Clutter.Gravity get_scale_gravity ();
		public unowned Clutter.Shader get_shader ();
		public void get_size (out float? width, out float? height);
		public unowned Clutter.Actor get_stage ();
		public void get_transformation_matrix (out Cogl.Matrix matrix);
		public void get_transformed_position (out float? x, out float? y);
		public void get_transformed_size (out float? width, out float? height);
		public float get_width ();
		public float get_x ();
		public float get_y ();
		public Clutter.Gravity get_z_rotation_gravity ();
		public void grab_key_focus ();
		public virtual void hide_all ();
		public bool is_in_clone_paint ();
		public bool is_rotated ();
		public bool is_scaled ();
		public void lower (Clutter.Actor? above);
		public void lower_bottom ();
		public virtual void map ();
		public void move_anchor_point (float anchor_x, float anchor_y);
		public void move_anchor_point_from_gravity (Clutter.Gravity gravity);
		public void move_by (float dx, float dy);
		public void queue_relayout ();
    [CCode (cname = "clutter_actor_queue_redraw")]
    public void do_queue_redraw ();
    [CCode (cname = "clutter_actor_event")]
    public void do_event (Clutter.Event e, bool capture_phase);

    public void raise (Clutter.Actor? below);
		public void raise_top ();
		public void remove_clip ();
		public void reparent (Clutter.Actor new_parent);
		public void set_anchor_point (float anchor_x, float anchor_y);
		public void set_anchor_point_from_gravity (Clutter.Gravity gravity);
		public void set_clip (float xoff, float yoff, float width, float height);
		public void set_depth (float depth);
		public void set_fixed_position_set (bool is_set);
		public void set_flags (Clutter.ActorFlags flags);
		public void set_geometry (Clutter.Geometry geometry);
		public void set_height (float height);
		public void set_name (string name);
		public void set_opacity (uint8 opacity);
		public void set_parent (Clutter.Actor parent);
		public void set_position (float x, float y);
		public void set_reactive (bool reactive);
		public void set_rotation (Clutter.RotateAxis axis, double angle, float x, float y, float z);
		public void set_scale (double scale_x, double scale_y);
		public void set_scale_full (double scale_x, double scale_y, float center_x, float center_y);
		public void set_scale_with_gravity (double scale_x, double scale_y, Clutter.Gravity gravity);
		public bool set_shader (Clutter.Shader? shader);
		public void set_shader_param (string param, GLib.Value value);
		public void set_shader_param_float (string param, float value);
		public void set_shader_param_int (string param, int value);
		public void set_size (float width, float height);
		public void set_width (float width);
		public void set_x (float x);
		public void set_y (float y);
		public void set_z_rotation_from_gravity (double angle, Clutter.Gravity gravity);
		public bool should_pick_paint ();
		public virtual void show_all ();
		public bool transform_stage_point (float x, float y, out float x_out, out float y_out);
		public virtual void unmap ();
		public void unparent ();
		public void unset_flags (Clutter.ActorFlags flags);
		public Clutter.ActorBox allocation { get; }
		public Clutter.Gravity anchor_gravity { get; set; }
		public float anchor_x { get; set; }
		public float anchor_y { get; set; }
		public Clutter.Geometry clip { get; set; }
		public bool clip_to_allocation { get; set; }
		public float depth { get; set; }
		public bool fixed_position_set { get; set; }
		public float fixed_x { get; set; }
		public float fixed_y { get; set; }
		public bool has_clip { get; }
		public float height { get; set; }
		public bool mapped { get; }
		public float min_height { get; set; }
		public bool min_height_set { get; set; }
		public float min_width { get; set; }
		public bool min_width_set { get; set; }
		public string name { get; set; }
		public float natural_height { get; set; }
		public bool natural_height_set { get; set; }
		public float natural_width { get; set; }
		public bool natural_width_set { get; set; }
		public uint8 opacity { get; set; }
		public bool reactive { get; set; }
		public bool realized { get; }
		public Clutter.RequestMode request_mode { get; set; }
		public double rotation_angle_x { get; set; }
		public double rotation_angle_y { get; set; }
		public double rotation_angle_z { get; set; }
		public Clutter.Vertex rotation_center_x { get; set; }
		public Clutter.Vertex rotation_center_y { get; set; }
		public Clutter.Vertex rotation_center_z { get; set; }
		public Clutter.Gravity rotation_center_z_gravity { get; set; }
		public float scale_center_x { get; set; }
		public float scale_center_y { get; set; }
    [NoAccessorMethod]
		public Clutter.Gravity scale_gravity { get; set; }
    [NoAccessorMethod]
		public double scale_x { get; set; }
    [NoAccessorMethod]
		public double scale_y { get; set; }
		public bool show_on_set_parent { get; set; }
		public bool visible { get; set; }
		public float width { get; set; }
		public float x { get; set; }
		public float y { get; set; }
		public signal void allocation_changed (Clutter.ActorBox box, Clutter.AllocationFlags flags);
		public virtual signal bool button_press_event (Clutter.Event event);
		public virtual signal bool button_release_event (Clutter.Event event);
		public virtual signal bool captured_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void destroy ();
		public virtual signal bool enter_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal bool event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void hide ();
		public virtual signal void key_focus_in ();
		public virtual signal void key_focus_out ();
		public virtual signal bool key_press_event (Clutter.Event event);
		public virtual signal bool key_release_event (Clutter.Event event);
		public virtual signal bool leave_event (Clutter.Event event);
		public virtual signal bool motion_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void paint ();
		public virtual signal void parent_set (Clutter.Actor old_parent);
		public virtual signal void pick (Clutter.Color color);
		[HasEmitter]
		public virtual signal void queue_redraw (Clutter.Actor origin);
		[HasEmitter]
		public virtual signal void realize ();
		public virtual signal bool scroll_event (Clutter.Event event);
		[HasEmitter]
		public virtual signal void show ();
		[HasEmitter]
		public virtual signal void unrealize ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Alpha : GLib.InitiallyUnowned {
		public weak GLib.InitiallyUnowned parent;
		public Clutter.AlphaPrivate priv;
		[CCode (has_construct_function = false)]
		public Alpha.full (Clutter.Timeline timeline, ulong mode);
		public double get_alpha ();
		public ulong get_mode ();
		public unowned Clutter.Timeline get_timeline ();
		[CCode (has_construct_function = false)]
		public Alpha ();
		public static ulong register_closure (GLib.Closure closure);
		public static ulong register_func ([CCode (delegate_target_pos = 0)] Clutter.AlphaFunc func);
		public void set_closure (GLib.Closure closure);
		public void set_func ([CCode (delegate_target_pos = 0)] Clutter.AlphaFunc func);
		public void set_mode (ulong mode);
		public void set_timeline (Clutter.Timeline timeline);
		[CCode (has_construct_function = false)]
		public Alpha.with_func (Clutter.Timeline timeline, Clutter.AlphaFunc func, void* data, GLib.DestroyNotify destroy);
		public double alpha { get; }
		public ulong mode { get; set construct; }
		public Clutter.Timeline timeline { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Animation : GLib.Object {
		public weak GLib.Object parent_instance;
		public Clutter.AnimationPrivate priv;
		public unowned Clutter.Animation bind (string property_name, GLib.Value final);
		public unowned Clutter.Animation bind_interval (string property_name, owned Clutter.Interval interval);
		[CCode (cname = "clutter_animation_completed")]
		public void send_completed ();
		public unowned Clutter.Alpha get_alpha ();
		public uint get_duration ();
		public unowned Clutter.Interval get_interval (string property_name);
		public bool get_loop ();
		public ulong get_mode ();
		public unowned GLib.Object get_object ();
		public unowned Clutter.Timeline get_timeline ();
		public bool has_property (string property_name);
		[CCode (has_construct_function = false)]
		public Animation ();
		public void set_alpha (Clutter.Alpha alpha);
		public void set_duration (int msecs);
		public void set_loop (bool loop);
		public void set_mode (ulong mode);
		public void set_object (GLib.Object object);
		public void set_timeline (Clutter.Timeline timeline);
		public void unbind_property (string property_name);
		public void update_interval (string property_name, Clutter.Interval interval);
		public Clutter.Alpha alpha { get; set; }
		public uint duration { get; set; }
		public bool loop { get; set; }
		public ulong mode { get; set; }
		public GLib.Object object { get; set; }
		public Clutter.Timeline timeline { get; set; }
		[HasEmitter]
		public virtual signal void completed ();
		public virtual signal void started ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Backend : GLib.Object {
		public weak GLib.Object parent_instance;
		public Clutter.BackendPrivate priv;
		public virtual void add_options (GLib.OptionGroup group);
		public virtual bool create_context (bool is_offscreen) throws GLib.Error;
		public virtual Clutter.Actor create_stage (Clutter.Stage wrapper) throws GLib.Error;
		public virtual void ensure_context (Clutter.Stage stage);
		public uint get_double_click_distance ();
		public uint get_double_click_time ();
		public virtual Clutter.FeatureFlags get_features ();
		public unowned string get_font_name ();
		public unowned Cairo.FontOptions get_font_options ();
		public double get_resolution ();
		public virtual void init_events ();
		public virtual void init_features ();
		public virtual bool post_parse () throws GLib.Error;
		public virtual bool pre_parse () throws GLib.Error;
		public virtual void redraw (Clutter.Stage stage);
		public void set_double_click_distance (uint distance);
		public void set_double_click_time (uint msec);
		public void set_font_name (string font_name);
		public void set_font_options (Cairo.FontOptions options);
		public void set_resolution (double dpi);
		public virtual signal void font_changed ();
		public virtual signal void resolution_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Behaviour : GLib.Object {
		public weak GLib.Object parent;
		public Clutter.BehaviourPrivate priv;
		public void actors_foreach ([CCode (delegate_target_pos = 0)] Clutter.BehaviourForeachFunc func);
		public virtual void alpha_notify (double alpha_value);
		public void apply (Clutter.Actor actor);
		public unowned GLib.SList get_actors ();
		public unowned Clutter.Alpha get_alpha ();
		public int get_n_actors ();
		public unowned Clutter.Actor get_nth_actor (int index_);
		public bool is_applied (Clutter.Actor actor);
		public void remove (Clutter.Actor actor);
		public void remove_all ();
		public void set_alpha (Clutter.Alpha alpha);
		public Clutter.Alpha alpha { get; set; }
		public virtual signal void applied (Clutter.Actor actor);
		public virtual signal void removed (Clutter.Actor actor);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourDepth : Clutter.Behaviour {
		public weak Clutter.Behaviour parent_instance;
		public Clutter.BehaviourDepthPrivate priv;
		public void get_bounds (out int depth_start, out int depth_end);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourDepth (Clutter.Alpha alpha, int depth_start, int depth_end);
		public void set_bounds (int depth_start, int depth_end);
		public int depth_end { get; set; }
		public int depth_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourEllipse : Clutter.Behaviour {
		public weak Clutter.Behaviour parent_instance;
		public Clutter.BehaviourEllipsePrivate priv;
		public double get_angle_end ();
		public double get_angle_start ();
		public double get_angle_tilt (Clutter.RotateAxis axis);
		public void get_center (out int x, out int y);
		public Clutter.RotateDirection get_direction ();
		public int get_height ();
		public void get_tilt (out double angle_tilt_x, out double angle_tilt_y, out double angle_tilt_z);
		public int get_width ();
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourEllipse (Clutter.Alpha alpha, int x, int y, int width, int height, Clutter.RotateDirection direction, double start, double end);
		public void set_angle_end (double angle_end);
		public void set_angle_start (double angle_start);
		public void set_angle_tilt (Clutter.RotateAxis axis, double angle_tilt);
		public void set_center (int x, int y);
		public void set_direction (Clutter.RotateDirection direction);
		public void set_height (int height);
		public void set_tilt (double angle_tilt_x, double angle_tilt_y, double angle_tilt_z);
		public void set_width (int width);
		public double angle_end { get; set; }
		public double angle_start { get; set; }
		public double angle_tilt_x { get; set; }
		public double angle_tilt_y { get; set; }
		public double angle_tilt_z { get; set; }
		public Clutter.Knot center { get; set; }
		public Clutter.RotateDirection direction { get; set; }
		public int height { get; set; }
		public int width { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourOpacity : Clutter.Behaviour {
		public weak Clutter.Behaviour parent;
		public Clutter.BehaviourOpacityPrivate priv;
		public void get_bounds ([CCode (array_length = false)] uint8[] opacity_start, [CCode (array_length = false)] uint8[] opacity_end);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourOpacity (Clutter.Alpha alpha, uint8 opacity_start, uint8 opacity_end);
		public void set_bounds (uint8 opacity_start, uint8 opacity_end);
		public uint opacity_end { get; set; }
		public uint opacity_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourPath : Clutter.Behaviour, Clutter.Scriptable {
		public weak Clutter.Behaviour parent;
		public Clutter.BehaviourPathPrivate priv;
		public unowned Clutter.Path get_path ();
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourPath (Clutter.Alpha alpha, Clutter.Path path);
		public void set_path (Clutter.Path path);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourPath.with_description (Clutter.Alpha alpha, string desc);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourPath.with_knots (Clutter.Alpha alpha, Clutter.Knot knots, uint n_knots);
		public Clutter.Path path { get; set; }
		public virtual signal void knot_reached (uint knot_num);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourRotate : Clutter.Behaviour {
		public weak Clutter.Behaviour parent_instance;
		public Clutter.BehaviourRotatePrivate priv;
		public Clutter.RotateAxis get_axis ();
		public void get_bounds (out double angle_start, out double angle_end);
		public void get_center (out int x, out int y, out int z);
		public Clutter.RotateDirection get_direction ();
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourRotate (Clutter.Alpha alpha, Clutter.RotateAxis axis, Clutter.RotateDirection direction, double angle_start, double angle_end);
		public void set_axis (Clutter.RotateAxis axis);
		public void set_bounds (double angle_start, double angle_end);
		public void set_center (int x, int y, int z);
		public void set_direction (Clutter.RotateDirection direction);
		public double angle_end { get; set; }
		public double angle_start { get; set; }
		public Clutter.RotateAxis axis { get; set; }
		public int center_x { get; set; }
		public int center_y { get; set; }
		public int center_z { get; set; }
		public Clutter.RotateDirection direction { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BehaviourScale : Clutter.Behaviour {
		public weak Clutter.Behaviour parent_instance;
		public Clutter.BehaviourScalePrivate priv;
		public void get_bounds (out double x_scale_start, out double y_scale_start, out double x_scale_end, out double y_scale_end);
		[CCode (type = "ClutterBehaviour*", has_construct_function = false)]
		public BehaviourScale (Clutter.Alpha alpha, double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end);
		public void set_bounds (double x_scale_start, double y_scale_start, double x_scale_end, double y_scale_end);
		public double x_scale_end { get; set; }
		public double x_scale_start { get; set; }
		public double y_scale_end { get; set; }
		public double y_scale_start { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class BindingPool : GLib.Object {
		public bool activate (uint key_val, Clutter.ModifierType modifiers, GLib.Object gobject);
		public void block_action (string action_name);
		public static unowned Clutter.BindingPool find (string name);
		public unowned string find_action (uint key_val, Clutter.ModifierType modifiers);
		public static unowned Clutter.BindingPool get_for_class (void* klass);
		public void install_action (string action_name, uint key_val, Clutter.ModifierType modifiers, GLib.Callback callback, void* data, GLib.DestroyNotify notify);
		public void install_closure (string action_name, uint key_val, Clutter.ModifierType modifiers, GLib.Closure closure);
		[CCode (has_construct_function = false)]
		public BindingPool (string name);
		public void override_action (uint key_val, Clutter.ModifierType modifiers, GLib.Callback callback, void* data, GLib.DestroyNotify notify);
		public void override_closure (uint key_val, Clutter.ModifierType modifiers, GLib.Closure closure);
		public void remove_action (uint key_val, Clutter.ModifierType modifiers);
		public void unblock_action (string action_name);
		public string name { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class CairoTexture : Clutter.Texture, Clutter.Scriptable {
		public weak Clutter.Texture parent_instance;
		public Clutter.CairoTexturePrivate priv;
		public void clear ();
		public Cairo.Context create ();
		public Cairo.Context create_region (int x_offset, int y_offset, int width, int height);
		public void get_surface_size (out uint width, out uint height);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public CairoTexture (uint width, uint height);
		public void set_surface_size (uint width, uint height);
		public uint surface_height { get; set; }
		public uint surface_width { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class ChildMeta : GLib.Object {
		public weak GLib.Object parent_instance;
		public unowned Clutter.Actor get_actor ();
		public unowned Clutter.Container get_container ();
		public Clutter.Actor actor { get; construct; }
		public Clutter.Container container { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Clone : Clutter.Actor, Clutter.Scriptable {
		public weak Clutter.Actor parent_instance;
		public Clutter.ClonePrivate priv;
		public unowned Clutter.Actor get_source ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Clone (Clutter.Actor source);
		public void set_source (Clutter.Actor source);
		public Clutter.Actor source { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Group : Clutter.Actor, Clutter.Container, Clutter.Scriptable {
		public weak Clutter.Actor parent_instance;
		public Clutter.GroupPrivate priv;
		public int get_n_children ();
		public unowned Clutter.Actor get_nth_child (int index_);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Group ();
		public void remove_all ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Interval : GLib.InitiallyUnowned {
		public weak GLib.InitiallyUnowned parent_instance;
		public Clutter.IntervalPrivate priv;
		public Clutter.Interval clone ();
		public virtual bool compute_value (double factor, GLib.Value value);
		public void get_final_value (GLib.Value value);
		public void get_initial_value (GLib.Value value);
		public void get_interval (...);
		public GLib.Type get_value_type ();
		[CCode (has_construct_function = false)]
		public Interval (GLib.Type gtype, ...);
		public GLib.Value peek_final_value ();
		public GLib.Value peek_initial_value ();
		public static void register_progress_func (GLib.Type value_type, Clutter.ProgressFunc func);
		public void set_final_value (GLib.Value value);
		public void set_initial_value (GLib.Value value);
		public void set_interval (...);
		public virtual bool validate (GLib.ParamSpec pspec);
		[CCode (has_construct_function = false)]
		public Interval.with_values (GLib.Type gtype, GLib.Value initial, GLib.Value final);
		public GLib.Type value_type { get; construct; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class ListModel : Clutter.Model {
		public weak Clutter.Model parent_instance;
		public Clutter.ListModelPrivate priv;
		[CCode (type = "ClutterModel*", has_construct_function = false)]
		public ListModel (uint n_columns, ...);
		[CCode (type = "ClutterModel*", has_construct_function = false)]
		public ListModel.newv (uint n_columns, out GLib.Type types, string names);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Model : GLib.Object {
		public weak GLib.Object parent_instance;
		public Clutter.ModelPrivate priv;
		public void append (...);
		public void appendv ([CCode (array_length_pos = 0.5)] uint[] columns, [CCode (array_length_pos = 0.5)] GLib.Value[] values);
		public bool filter_iter (Clutter.ModelIter iter);
		public bool filter_row (uint row);
		public void @foreach ([CCode (delegate_target_pos = 0)] Clutter.ModelForeachFunc func);
		public virtual unowned string get_column_name (uint column);
		public virtual GLib.Type get_column_type (uint column);
		public bool get_filter_set ();
		public Clutter.ModelIter get_first_iter ();
		public virtual Clutter.ModelIter get_iter_at_row (uint row);
		public Clutter.ModelIter get_last_iter ();
		public virtual uint get_n_columns ();
		public virtual uint get_n_rows ();
		public int get_sorting_column ();
		public void insert (uint row, ...);
		public virtual Clutter.ModelIter insert_row (int index_);
		public void insert_value (uint row, uint column, GLib.Value value);
		public void insertv (uint row, [CCode (array_length_pos = 0)] uint[] columns, [CCode (array_length_pos = 0)] GLib.Value[] values);
		public void prepend (...);
		public void prependv ([CCode (array_length_pos = 0.5)] uint[] columns, [CCode (array_length_pos = 0.5)] GLib.Value[] values);
		public void remove (uint row);
		public virtual void remove_row (uint row);
		public virtual void resort (Clutter.ModelSortFunc func, void* data);
		public void set_filter ([CCode (delegate_target_pos = 0)] Clutter.ModelFilterFunc func);
		public void set_names ([CCode (array_length_pos = 0.5)] int8[] names);
		public void set_sort (uint column, [CCode (delegate_target_pos = 0)] Clutter.ModelSortFunc func);
		public void set_sorting_column (int column);
		public void set_types ([CCode (array_length_pos = 0.5)] GLib.Type[] types);
		public bool filter_set { get; }
		public virtual signal void filter_changed ();
		public virtual signal void row_added (Clutter.ModelIter iter);
		public virtual signal void row_changed (Clutter.ModelIter iter);
		public virtual signal void row_removed (Clutter.ModelIter iter);
		public virtual signal void sort_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class ModelIter : GLib.Object {
		public weak GLib.Object parent_instance;
		public Clutter.ModelIterPrivate priv;
		public virtual Clutter.ModelIter copy ();
		public void @get (...);
		public virtual Clutter.Model get_model ();
		public virtual uint get_row ();
		public virtual void get_value (uint column, GLib.Value value);
		public virtual bool is_first ();
		public virtual bool is_last ();
		public virtual Clutter.ModelIter next ();
		public virtual Clutter.ModelIter prev ();
		public void @set (...);
		public virtual void set_value (uint column, GLib.Value value);
		public Clutter.Model model { get; set; }
		public uint row { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Path : GLib.InitiallyUnowned {
		public weak GLib.InitiallyUnowned parent;
		public Clutter.PathPrivate priv;
		public void add_cairo_path (Cairo.Path cpath);
		public void add_close ();
		public void add_curve_to (int x_1, int y_1, int x_2, int y_2, int x_3, int y_3);
		public void add_line_to (int x, int y);
		public void add_move_to (int x, int y);
		public void add_node (Clutter.PathNode node);
		public void add_rel_curve_to (int x_1, int y_1, int x_2, int y_2, int x_3, int y_3);
		public void add_rel_line_to (int x, int y);
		public void add_rel_move_to (int x, int y);
		public bool add_string (string str);
		public void clear ();
		public void @foreach ([CCode (delegate_target_pos = 0)] Clutter.PathCallback callback);
		public string get_description ();
		public uint get_length ();
		public uint get_n_nodes ();
		public void get_node (uint index_, Clutter.PathNode node);
		public unowned GLib.SList get_nodes ();
		public uint get_position (double progress, Clutter.Knot position);
		public void insert_node (int index_, Clutter.PathNode node);
		[CCode (has_construct_function = false)]
		public Path ();
		public void remove_node (uint index_);
		public void replace_node (uint index_, Clutter.PathNode node);
		public bool set_description (string str);
		public void to_cairo_path (Cairo.Context cr);
		[CCode (has_construct_function = false)]
		public Path.with_description (string desc);
		public string description { get; set; }
		public uint length { get; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Rectangle : Clutter.Actor, Clutter.Scriptable {
		public weak Clutter.Actor parent;
		public Clutter.RectanglePrivate priv;
		public void get_border_color (Clutter.Color color);
		public uint get_border_width ();
		public void get_color (Clutter.Color color);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Rectangle ();
		public void set_border_color (Clutter.Color color);
		public void set_border_width (uint width);
		public void set_color (Clutter.Color color);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Rectangle.with_color (Clutter.Color color);
		public Clutter.Color border_color { get; set; }
		public uint border_width { get; set; }
		public Clutter.Color color { get; set; }
		public bool has_border { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Score : GLib.Object {
		public weak GLib.Object parent;
		public Clutter.ScorePrivate priv;
		public ulong append (Clutter.Timeline parent, Clutter.Timeline timeline);
		public ulong append_at_marker (Clutter.Timeline parent, string marker_name, Clutter.Timeline timeline);
		public bool get_loop ();
		public unowned Clutter.Timeline get_timeline (ulong id);
		public bool is_playing ();
		public unowned GLib.SList list_timelines ();
		[CCode (has_construct_function = false)]
		public Score ();
		public void pause ();
		public void remove (ulong id);
		public void remove_all ();
		public void rewind ();
		public void set_loop (bool loop);
		public void start ();
		public void stop ();
		public bool loop { get; set; }
		public virtual signal void completed ();
		public virtual signal void paused ();
		public virtual signal void started ();
		public virtual signal void timeline_completed (Clutter.Timeline timeline);
		public virtual signal void timeline_started (Clutter.Timeline timeline);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Script : GLib.Object {
		public weak GLib.Object parent_instance;
		public Clutter.ScriptPrivate priv;
		public void add_search_paths (string paths, size_t n_paths);
		public void connect_signals (void* user_data);
		public void connect_signals_full ([CCode (delegate_target_pos = 0)] Clutter.ScriptConnectFunc func);
		public void ensure_objects ();
		public unowned GLib.Object get_object (string name);
		public int get_objects (string first_name, ...);
		public virtual GLib.Type get_type_from_name (string type_name);
		public unowned GLib.List list_objects ();
		public uint load_from_data (string data, ssize_t length) throws GLib.Error;
		public uint load_from_file (string filename) throws GLib.Error;
		public string lookup_filename (string filename);
		[CCode (has_construct_function = false)]
		public Script ();
		public void unmerge_objects (uint merge_id);
		public string filename { get; }
		public bool filename_set { get; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Shader : GLib.Object {
		public weak GLib.Object parent;
		public Clutter.ShaderPrivate priv;
		public bool compile () throws GLib.Error;
		public Cogl.Handle get_cogl_fragment_shader ();
		public Cogl.Handle get_cogl_program ();
		public Cogl.Handle get_cogl_vertex_shader ();
		public unowned string get_fragment_source ();
		public bool get_is_enabled ();
		public unowned string get_vertex_source ();
		public bool is_compiled ();
		[CCode (has_construct_function = false)]
		public Shader ();
		public void release ();
		public void set_fragment_source (string data, ssize_t length);
		public void set_is_enabled (bool enabled);
		public void set_uniform (string name, GLib.Value value);
		public void set_vertex_source (string data, ssize_t length);
		public bool compiled { get; }
		public bool enabled { get; set; }
		public string fragment_source { get; set; }
		public string vertex_source { get; set; }
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Stage : Clutter.Group, Clutter.Container, Clutter.Scriptable {
		public weak Clutter.Group parent_instance;
		public Clutter.StagePrivate priv;
		public void ensure_current ();
		public void ensure_redraw ();
		public void ensure_viewport ();
		public bool event (Clutter.Event event);
		public unowned Clutter.Actor get_actor_at_pos (Clutter.PickMode pick_mode, int x, int y);
		public void get_color (Clutter.Color color);
		public static unowned Clutter.Actor get_default ();
		public void get_fog (Clutter.Fog fog);
		public bool get_fullscreen ();
		public unowned Clutter.Actor get_key_focus ();
		public void get_perspective (Clutter.Perspective perspective);
		public bool get_throttle_motion_events ();
		public unowned string get_title ();
		public bool get_use_fog ();
		public bool get_user_resizable ();
		public void hide_cursor ();
		public bool is_default ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Stage ();
		public void queue_redraw ();
		public uint8[] read_pixels (int x, int y, int width, int height);
		public void set_color (Clutter.Color color);
		public void set_fog (Clutter.Fog fog);
		public void set_fullscreen (bool fullscreen);
		public void set_key_focus (Clutter.Actor actor);
		public void set_perspective (Clutter.Perspective perspective);
		public void set_throttle_motion_events (bool throttle);
		public void set_title (string title);
		public void set_use_fog (bool fog);
		public void set_user_resizable (bool resizable);
		public void show_cursor ();
		public Clutter.Color color { get; set; }
		public bool cursor_visible { get; set; }
		public Clutter.Fog fog { get; set; }
		public bool fullscreen_set { get; }
		public bool offscreen { get; set; }
		public Clutter.Perspective perspective { get; set; }
		public string title { get; set; }
		public bool use_fog { get; set; }
		public bool user_resizable { get; set; }
		public virtual signal void activate ();
		public virtual signal void deactivate ();
		public virtual signal void fullscreen ();
		public virtual signal void unfullscreen ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class StageManager : GLib.Object {
		public static unowned Clutter.StageManager get_default ();
		public unowned Clutter.Stage get_default_stage ();
		public GLib.SList list_stages ();
		public unowned GLib.SList peek_stages ();
		public void set_default_stage (Clutter.Stage stage);
		public Clutter.Stage default_stage { get; set; }
		public virtual signal void stage_added (Clutter.Stage object);
		public virtual signal void stage_removed (Clutter.Stage stage);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Text : Clutter.Actor, Clutter.Scriptable {
		public weak Clutter.Actor parent_instance;
		public Clutter.TextPrivate priv;
		public void delete_chars (uint n_chars);
		public bool delete_selection ();
		public void delete_text (ssize_t start_pos, ssize_t end_pos);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Text.full (string font_name, string text, Clutter.Color color);
		public bool get_activatable ();
		public unowned Pango.AttrList get_attributes ();
		public string get_chars (ssize_t start_pos, ssize_t end_pos);
		public void get_color (Clutter.Color color);
		public void get_cursor_color (Clutter.Color color);
		public int get_cursor_position ();
		public uint get_cursor_size ();
		public bool get_cursor_visible ();
		public bool get_editable ();
		public Pango.EllipsizeMode get_ellipsize ();
		public unowned string get_font_name ();
		public bool get_justify ();
		public unowned Pango.Layout get_layout ();
		public Pango.Alignment get_line_alignment ();
		public bool get_line_wrap ();
		public Pango.WrapMode get_line_wrap_mode ();
		public int get_max_length ();
		public unichar get_password_char ();
		public bool get_selectable ();
		public string get_selection ();
		public int get_selection_bound ();
		public void get_selection_color (Clutter.Color color);
		public bool get_single_line_mode ();
		public unowned string get_text ();
		public bool get_use_markup ();
		public void insert_text (string text, ssize_t position);
		public void insert_unichar (unichar wc);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Text ();
		public bool position_to_coords (int position, out float x, out float y, out float line_height);
		public void set_activatable (bool activatable);
		public void set_attributes (Pango.AttrList attrs);
		public void set_color (Clutter.Color color);
		public void set_cursor_color (Clutter.Color color);
		public void set_cursor_position (int position);
		public void set_cursor_size (int size);
		public void set_cursor_visible (bool cursor_visible);
		public void set_editable (bool editable);
		public void set_ellipsize (Pango.EllipsizeMode mode);
		public void set_font_name (string font_name);
		public void set_justify (bool justify);
		public void set_line_alignment (Pango.Alignment alignment);
		public void set_line_wrap (bool line_wrap);
		public void set_line_wrap_mode (Pango.WrapMode wrap_mode);
		public void set_markup (string markup);
		public void set_max_length (int max);
		public void set_password_char (unichar wc);
		public void set_selectable (bool selectable);
		public void set_selection (ssize_t start_pos, ssize_t end_pos);
		public void set_selection_bound (int selection_bound);
		public void set_selection_color (Clutter.Color color);
		public void set_single_line_mode (bool single_line);
		public void set_text (string text);
		public void set_use_markup (bool setting);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Text.with_text (string font_name, string text);
		public bool activatable { get; set; }
		public Pango.AttrList attributes { get; set; }
		public Clutter.Color color { get; set; }
		public Clutter.Color cursor_color { get; set; }
		public bool cursor_color_set { get; }
		public int cursor_size { get; set; }
		public bool cursor_visible { get; set; }
		public bool editable { get; set; }
		public Pango.EllipsizeMode ellipsize { get; set; }
		public string font_name { get; set; }
		public bool justify { get; set; }
		public Pango.Alignment line_alignment { get; set; }
		public bool line_wrap { get; set; }
		public Pango.WrapMode line_wrap_mode { get; set; }
		public int max_length { get; set; }
		public uint password_char { get; set; }
		public int position { get; set; }
		public bool selectable { get; set; }
		public int selection_bound { get; set; }
		public Clutter.Color selection_color { get; set; }
		public bool selection_color_set { get; }
		public bool single_line_mode { get; set; }
		public string text { get; set; }
		public bool use_markup { get; set; }
		[HasEmitter]
		public virtual signal void activate ();
		public virtual signal void cursor_event (Clutter.Geometry geometry);
		public virtual signal void text_changed ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Texture : Clutter.Actor, Clutter.Scriptable {
		public weak Clutter.Actor parent;
		public Clutter.TexturePrivate priv;
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Texture.from_actor (Clutter.Actor actor);
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Texture.from_file (string filename) throws GLib.Error;
		public void get_base_size (out int width, out int height);
		public Cogl.Handle get_cogl_material ();
		public Cogl.Handle get_cogl_texture ();
		public Clutter.TextureQuality get_filter_quality ();
		public bool get_keep_aspect_ratio ();
		public bool get_load_async ();
		public bool get_load_data_async ();
		public int get_max_tile_waste ();
		public Cogl.PixelFormat get_pixel_format ();
		public void get_repeat (out bool repeat_x, out bool repeat_y);
		public bool get_sync_size ();
		[CCode (type = "ClutterActor*", has_construct_function = false)]
		public Texture ();
		public bool set_area_from_rgb_data ([CCode (array_length = false)] uint8[] data, bool has_alpha, int x, int y, int width, int height, int rowstride, int bpp, Clutter.TextureFlags flags) throws GLib.Error;
		public void set_cogl_material (Cogl.Handle cogl_material);
		public void set_cogl_texture (Cogl.Handle cogl_tex);
		public void set_filter_quality (Clutter.TextureQuality filter_quality);
		public bool set_from_file (string filename) throws GLib.Error;
		public bool set_from_rgb_data ([CCode (array_length = false)] uint8[] data, bool has_alpha, int width, int height, int rowstride, int bpp, Clutter.TextureFlags flags) throws GLib.Error;
		public bool set_from_yuv_data ([CCode (array_length = false)] uint8[] data, int width, int height, Clutter.TextureFlags flags) throws GLib.Error;
		public void set_keep_aspect_ratio (bool keep_aspect);
		public void set_load_async (bool load_async);
		public void set_load_data_async (bool load_async);
		public void set_repeat (bool repeat_x, bool repeat_y);
		public void set_sync_size (bool sync_size);
		public Cogl.Handle cogl_material { get; set; }
		public Cogl.Handle cogl_texture { get; set; }
		public bool disable_slicing { get; construct; }
		public string filename { set; }
		public Clutter.TextureQuality filter_quality { get; set construct; }
		public bool keep_aspect_ratio { get; set; }
		public bool load_async { set; }
		public bool load_data_async { set; }
		public Cogl.PixelFormat pixel_format { get; }
		public bool repeat_x { get; set; }
		public bool repeat_y { get; set; }
		public bool sync_size { get; set; }
		public int tile_waste { get; }
		public virtual signal void load_finished (void* error);
		public virtual signal void pixbuf_change ();
		public virtual signal void size_change (int width, int height);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public class Timeline : GLib.Object {
		public weak GLib.Object parent;
		public Clutter.TimelinePrivate priv;
		public void add_marker_at_time (string marker_name, uint msecs);
		public void advance (uint msecs);
		public void advance_to_marker (string marker_name);
		public Clutter.Timeline clone ();
		public void do_tick (GLib.TimeVal tick_time);
		public uint get_delay ();
		public uint get_delta ();
		public Clutter.TimelineDirection get_direction ();
		public uint get_duration ();
		public uint get_elapsed_time ();
		public bool get_loop ();
		public double get_progress ();
		public bool has_marker (string marker_name);
		public bool is_playing ();
		public string[] list_markers (int msecs, out size_t n_markers);
		[CCode (has_construct_function = false)]
		public Timeline (uint msecs);
		public void pause ();
		public void remove_marker (string marker_name);
		public void rewind ();
		public void set_delay (uint msecs);
		public void set_direction (Clutter.TimelineDirection direction);
		public void set_duration (uint msecs);
		public void set_loop (bool loop);
		public void skip (uint msecs);
		public void start ();
		public void stop ();
		public uint delay { get; set; }
		public Clutter.TimelineDirection direction { get; set; }
		public uint duration { get; set; }
		public bool loop { get; set; }
		public virtual signal void completed ();
		public virtual signal void marker_reached (string marker_name, int msecs);
		public virtual signal void new_frame (int msecs);
		public virtual signal void paused ();
		public virtual signal void started ();
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Animatable {
		public abstract bool animate_property (Clutter.Animation animation, string property_name, GLib.Value initial_value, GLib.Value final_value, double progress, GLib.Value value);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Container {
		public abstract void add (Clutter.Actor actor);
		public void add_actor (Clutter.Actor actor);
		public void child_get (Clutter.Actor actor, string first_prop, ...);
		public void child_get_property (Clutter.Actor child, string property, GLib.Value value);
		public void child_set (Clutter.Actor actor, string first_prop, ...);
		public void child_set_property (Clutter.Actor child, string property, GLib.Value value);
		public abstract void create_child_meta (Clutter.Actor actor);
		public abstract void destroy_child_meta (Clutter.Actor actor);
		public unowned Clutter.Actor find_child_by_name (string child_name);
		public abstract void @foreach (Clutter.Callback callback, void *userdata);
		public abstract void foreach_with_internals (Clutter.Callback callback, void *userdata);
		public abstract Clutter.ChildMeta? get_child_meta (Clutter.Actor actor);
		public GLib.List<unowned Clutter.Actor> get_children ();
		public abstract void lower (Clutter.Actor actor, Clutter.Actor sibling);
		public void lower_child (Clutter.Actor actor, Clutter.Actor sibling);
		public abstract void raise (Clutter.Actor actor, Clutter.Actor sibling);
		public void raise_child (Clutter.Actor actor, Clutter.Actor? sibling);
		public abstract void remove (Clutter.Actor actor);
		public void remove_actor (Clutter.Actor actor);
		public abstract void sort_depth_order ();
		public virtual signal void actor_added (Clutter.Actor actor);
		public virtual signal void actor_removed (Clutter.Actor actor);
		public virtual signal void child_notify (Clutter.Actor actor, GLib.ParamSpec since);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Media {
		public double get_audio_volume ();
		public double get_buffer_fill ();
		public bool get_can_seek ();
		public double get_duration ();
		public bool get_playing ();
		public double get_progress ();
		public string get_uri ();
		public void set_audio_volume (double volume);
		public void set_filename (string filename);
		public void set_playing (bool playing);
		public void set_progress (double progress);
		public void set_uri (string uri);
		public double audio_volume { get; set; }
		public double buffer_fill { get; }
		public bool can_seek { get; }
		public double duration { get; }
		public bool playing { get; set; }
		public double progress { get; set; }
		public string uri { get; set; }
		public virtual signal void eos ();
		public virtual signal void error (void* error);
	}
	[CCode (cheader_filename = "clutter/clutter.h")]
	public interface Scriptable {
		public abstract unowned string get_id ();
		public abstract bool parse_custom_node (Clutter.Script script, GLib.Value value, string name, ClutterJson.JsonNode node);
		public abstract void set_custom_property (Clutter.Script script, string name, GLib.Value value);
		public abstract void set_id (string name);
	}
	[Immutable]
	[CCode (type_id = "CLUTTER_TYPE_ACTOR_BOX", cheader_filename = "clutter/clutter.h")]
	public struct ActorBox {
		public float x1;
		public float y1;
		public float x2;
		public float y2;
		public bool contains (float x, float y);
		public Clutter.ActorBox copy ();
		public bool equal (Clutter.ActorBox box_b);
		public void free ();
		public void from_vertices ([CCode (array_length = false)] Clutter.Vertex[] verts);
		public float get_area ();
		public float get_height ();
		public void get_origin (out float? x, out float? y);
		public void get_size (out float? width, out float? height);
		public float get_width ();
		public float get_x ();
		public float get_y ();
	}
	[CCode (type_id = "CLUTTER_TYPE_ACTOR_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ActorPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_ALPHA_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct AlphaPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_ANIMATION_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct AnimationPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_ANY_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct AnyEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
	}
	[CCode (type_id = "CLUTTER_TYPE_BACKEND_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BackendPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_DEPTH_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourDepthPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_ELLIPSE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourEllipsePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_OPACITY_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourOpacityPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_PATH_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourPathPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_ROTATE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourRotatePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BEHAVIOUR_SCALE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct BehaviourScalePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_BUTTON_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct ButtonEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ModifierType modifier_state;
		public uint32 button;
		public uint click_count;
		public void* axes;
		public Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_CAIRO_TEXTURE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct CairoTexturePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_CLONE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ClonePrivate {
	}
  [Immutable]
	[CCode (type_id = "CLUTTER_TYPE_COLOR", cheader_filename = "clutter/clutter.h")]
	public struct Color {
		public uint8 red;
		public uint8 green;
		public uint8 blue;
		public uint8 alpha;
		public void add (Clutter.Color b, out Clutter.Color result);
		public Clutter.Color copy ();
		public void darken (out Clutter.Color result);
		public void free ();
		public void from_hls (float hue, float luminance, float saturation);
		public void from_pixel (uint32 pixel);
		public bool from_string (string str);
		public void lighten (out Clutter.Color result);
		public void shade (double factor, out Clutter.Color result);
		public void subtract (Clutter.Color b, out Clutter.Color result);
		public void to_hls (out float hue, out float luminance, out float saturation);
		public uint32 to_pixel ();
		public string to_string ();
	}
	[CCode (type_id = "CLUTTER_TYPE_CROSSING_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct CrossingEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.InputDevice device;
		public weak Clutter.Actor related;
	}
	[CCode (type_id = "CLUTTER_TYPE_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct Event {
		public Clutter.EventType type;
		public Clutter.AnyEvent any;
		public Clutter.ButtonEvent button;
		public Clutter.KeyEvent key;
		public Clutter.MotionEvent motion;
		public Clutter.ScrollEvent scroll;
		public Clutter.StageStateEvent stage_state;
		public Clutter.CrossingEvent crossing;
		public Clutter.Event copy ();
		public void free ();
		public uint32 get_button ();
		public uint get_click_count ();
		public void get_coords (out float x, out float y);
		public Clutter.InputDevice get_device ();
		public int get_device_id ();
		public Clutter.InputDeviceType get_device_type ();
		public Clutter.EventFlags get_flags ();
		public uint16 get_key_code ();
		public uint get_key_symbol ();
		public uint32 get_key_unicode ();
		public unowned Clutter.Actor get_related ();
		public Clutter.ScrollDirection get_scroll_direction ();
		public unowned Clutter.Actor get_source ();
		public unowned Clutter.Stage get_stage ();
		public Clutter.ModifierType get_state ();
		public uint32 get_time ();
		public Clutter.EventType get_type ();
		public void put ();
	}
	[CCode (type_id = "CLUTTER_TYPE_FOG", cheader_filename = "clutter/clutter.h")]
	public struct Fog {
		public float z_near;
		public float z_far;
	}
	[CCode (type_id = "CLUTTER_TYPE_GEOMETRY", cheader_filename = "clutter/clutter.h")]
	public struct Geometry {
		public int x;
		public int y;
		public uint width;
		public uint height;
	}
	[CCode (type_id = "CLUTTER_TYPE_GROUP_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct GroupPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_INPUT_DEVICE", cheader_filename = "clutter/clutter.h")]
	public struct InputDevice {
		public int get_device_id ();
		public Clutter.InputDeviceType get_device_type ();
	}
	[CCode (type_id = "CLUTTER_TYPE_INTERVAL_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct IntervalPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_KEY_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct KeyEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public Clutter.ModifierType modifier_state;
		public uint keyval;
		public uint16 hardware_keycode;
		public unichar unicode_value;
		public Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_KNOT", cheader_filename = "clutter/clutter.h")]
	public struct Knot {
		public int x;
		public int y;
		public Clutter.Knot copy ();
		public bool equal (Clutter.Knot knot_b);
		public void free ();
	}
	[CCode (type_id = "CLUTTER_TYPE_LIST_MODEL_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ListModelPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_MODEL_ITER_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ModelIterPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_MODEL_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ModelPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_MOTION_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct MotionEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ModifierType modifier_state;
		public void* axes;
		public Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_PARAM_SPEC_COLOR", cheader_filename = "clutter/clutter.h")]
	public struct ParamSpecColor {
		public weak GLib.ParamSpec parent_instance;
		public Clutter.Color default_value;
	}
	[CCode (type_id = "CLUTTER_TYPE_PARAM_SPEC_FIXED", cheader_filename = "clutter/clutter.h")]
	public struct ParamSpecFixed {
		public weak GLib.ParamSpec parent_instance;
		public Cogl.Fixed minimum;
		public Cogl.Fixed maximum;
		public Cogl.Fixed default_value;
	}
	[CCode (type_id = "CLUTTER_TYPE_PARAM_SPEC_UNITS", cheader_filename = "clutter/clutter.h")]
	public struct ParamSpecUnits {
		public weak GLib.ParamSpec parent_instance;
		public Clutter.UnitType default_type;
		public float default_value;
		public float minimum;
		public float maximum;
	}
	[CCode (type_id = "CLUTTER_TYPE_PATH_NODE", cheader_filename = "clutter/clutter.h")]
	public struct PathNode {
		public Clutter.PathNodeType type;
		public weak Clutter.Knot[] points;
		public Clutter.PathNode copy ();
		public bool equal (Clutter.PathNode node_b);
		public void free ();
	}
	[CCode (type_id = "CLUTTER_TYPE_PATH_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct PathPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_PERSPECTIVE", cheader_filename = "clutter/clutter.h")]
	public struct Perspective {
		public float fovy;
		public float aspect;
		public float z_near;
		public float z_far;
	}
	[CCode (type_id = "CLUTTER_TYPE_RECTANGLE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct RectanglePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_SCORE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ScorePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_SCRIPT_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ScriptPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_SCROLL_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct ScrollEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public float x;
		public float y;
		public Clutter.ScrollDirection direction;
		public Clutter.ModifierType modifier_state;
		public void* axes;
		public Clutter.InputDevice device;
	}
	[CCode (type_id = "CLUTTER_TYPE_SHADER_FLOAT", cheader_filename = "clutter/clutter.h")]
	public struct ShaderFloat {
	}
	[CCode (type_id = "CLUTTER_TYPE_SHADER_INT", cheader_filename = "clutter/clutter.h")]
	public struct ShaderInt {
	}
	[CCode (type_id = "CLUTTER_TYPE_SHADER_MATRIX", cheader_filename = "clutter/clutter.h")]
	public struct ShaderMatrix {
	}
	[CCode (type_id = "CLUTTER_TYPE_SHADER_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct ShaderPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_STAGE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct StagePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_STAGE_STATE_EVENT", cheader_filename = "clutter/clutter.h")]
	public struct StageStateEvent {
		public Clutter.EventType type;
		public uint32 time;
		public Clutter.EventFlags flags;
		public weak Clutter.Stage stage;
		public weak Clutter.Actor source;
		public Clutter.StageState changed_mask;
		public Clutter.StageState new_state;
	}
	[CCode (type_id = "CLUTTER_TYPE_TEXT_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct TextPrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_TEXTURE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct TexturePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_TIMELINE_PRIVATE", cheader_filename = "clutter/clutter.h")]
	public struct TimelinePrivate {
	}
	[CCode (type_id = "CLUTTER_TYPE_TIMEOUT_POOL", cheader_filename = "clutter/clutter.h")]
	public struct TimeoutPool {
		public uint add (uint fps, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
		public void remove (uint id);
	}
	[CCode (type_id = "CLUTTER_TYPE_UNITS", cheader_filename = "clutter/clutter.h")]
	public struct Units {
		public Clutter.UnitType unit_type;
		public float value;
		public float _pixels;
		public uint pixels_set;
		public int64 __padding_1;
		public int64 __padding_2;
		public Clutter.Units copy ();
		public void em (float em);
		public void em_for_font (string font_name, float em);
		public void free ();
		public bool from_string (string str);
		public Clutter.UnitType get_unit_type ();
		public float get_unit_value ();
		public void mm (float mm);
		public void pixels (int px);
		public void pt (float pt);
		public float to_pixels ();
		public string to_string ();
	}
	[CCode (type_id = "CLUTTER_TYPE_VERTEX", cheader_filename = "clutter/clutter.h")]
	public struct Vertex {
		public float x;
		public float y;
		public float z;
		public Clutter.Vertex copy ();
		public bool equal (Clutter.Vertex vertex_b);
		public void free ();
	}
	[CCode (cprefix = "CLUTTER_ACTOR_FLAGS_", cheader_filename = "clutter/clutter.h")]
	public enum ActorFlags {
		[CCode (cname = "CLUTTER_ACTOR_MAPPED")]
		MAPPED,
		[CCode (cname = "CLUTTER_ACTOR_REALIZED")]
		REALIZED,
		[CCode (cname = "CLUTTER_ACTOR_REACTIVE")]
		REACTIVE,
		[CCode (cname = "CLUTTER_ACTOR_VISIBLE")]
		VISIBLE
	}
	[CCode (cprefix = "CLUTTER_ALLOCATION_FLAGS_", cheader_filename = "clutter/clutter.h")]
	public enum AllocationFlags {
		[CCode (cname = "CLUTTER_ALLOCATION_NONE")]
		ALLOCATION_NONE,
		[CCode (cname = "CLUTTER_ABSOLUTE_ORIGIN_CHANGED")]
		ABSOLUTE_ORIGIN_CHANGED
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum AnimationMode {
		CUSTOM_MODE,
		LINEAR,
		EASE_IN_QUAD,
		EASE_OUT_QUAD,
		EASE_IN_OUT_QUAD,
		EASE_IN_CUBIC,
		EASE_OUT_CUBIC,
		EASE_IN_OUT_CUBIC,
		EASE_IN_QUART,
		EASE_OUT_QUART,
		EASE_IN_OUT_QUART,
		EASE_IN_QUINT,
		EASE_OUT_QUINT,
		EASE_IN_OUT_QUINT,
		EASE_IN_SINE,
		EASE_OUT_SINE,
		EASE_IN_OUT_SINE,
		EASE_IN_EXPO,
		EASE_OUT_EXPO,
		EASE_IN_OUT_EXPO,
		EASE_IN_CIRC,
		EASE_OUT_CIRC,
		EASE_IN_OUT_CIRC,
		EASE_IN_ELASTIC,
		EASE_OUT_ELASTIC,
		EASE_IN_OUT_ELASTIC,
		EASE_IN_BACK,
		EASE_OUT_BACK,
		EASE_IN_OUT_BACK,
		EASE_IN_BOUNCE,
		EASE_OUT_BOUNCE,
		EASE_IN_OUT_BOUNCE,
		ANIMATION_LAST
	}
	[CCode (cprefix = "CLUTTER_EVENT_FLAGS_", cheader_filename = "clutter/clutter.h")]
	public enum EventFlags {
		[CCode (cname = "CLUTTER_EVENT_NONE")]
		NONE,
		[CCode (cname = "CLUTTER_EVENT_FLAG_SYNTHETIC")]
		FLAG_SYNTHETIC
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum EventType {
		NOTHING,
		KEY_PRESS,
		KEY_RELEASE,
		MOTION,
		ENTER,
		LEAVE,
		BUTTON_PRESS,
		BUTTON_RELEASE,
		SCROLL,
		STAGE_STATE,
		DESTROY_NOTIFY,
		CLIENT_MESSAGE,
		DELETE
	}
	[CCode (cprefix = "CLUTTER_FEATURE_FLAGS_", cheader_filename = "clutter/clutter.h")]
	public enum FeatureFlags {
		[CCode (cname = "CLUTTER_FEATURE_TEXTURE_NPOT")]
		TEXTURE_NPOT,
		[CCode (cname = "CLUTTER_FEATURE_SYNC_TO_VBLANK")]
		SYNC_TO_VBLANK,
		[CCode (cname = "CLUTTER_FEATURE_TEXTURE_YUV")]
		TEXTURE_YUV,
		[CCode (cname = "CLUTTER_FEATURE_TEXTURE_READ_PIXELS")]
		TEXTURE_READ_PIXELS,
		[CCode (cname = "CLUTTER_FEATURE_STAGE_STATIC")]
		STAGE_STATIC,
		[CCode (cname = "CLUTTER_FEATURE_STAGE_USER_RESIZE")]
		STAGE_USER_RESIZE,
		[CCode (cname = "CLUTTER_FEATURE_STAGE_CURSOR")]
		STAGE_CURSOR,
		[CCode (cname = "CLUTTER_FEATURE_SHADERS_GLSL")]
		SHADERS_GLSL,
		[CCode (cname = "CLUTTER_FEATURE_OFFSCREEN")]
		OFFSCREEN,
		[CCode (cname = "CLUTTER_FEATURE_STAGE_MULTIPLE")]
		STAGE_MULTIPLE
	}
	[CCode (cprefix = "CLUTTER_FONT_FLAGS_", cheader_filename = "clutter/clutter.h")]
	public enum FontFlags {
		[CCode (cname = "CLUTTER_FONT_MIPMAPPING")]
		MIPMAPPING,
		[CCode (cname = "CLUTTER_FONT_HINTING")]
		HINTING
	}
	[CCode (cprefix = "CLUTTER_GRAVITY_", cheader_filename = "clutter/clutter.h")]
	public enum Gravity {
		NONE,
		NORTH,
		NORTH_EAST,
		EAST,
		SOUTH_EAST,
		SOUTH,
		SOUTH_WEST,
		WEST,
		NORTH_WEST,
		CENTER
	}
	[CCode (cprefix = "CLUTTER_INIT_", cheader_filename = "clutter/clutter.h")]
	public enum InitError {
		SUCCESS,
		ERROR_UNKNOWN,
		ERROR_THREADS,
		ERROR_BACKEND,
		ERROR_INTERNAL
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum InputDeviceType {
		POINTER_DEVICE,
		KEYBOARD_DEVICE,
		EXTENSION_DEVICE,
		N_DEVICE_TYPES
	}
	[CCode (cprefix = "CLUTTER_MODIFIER_TYPE_", cheader_filename = "clutter/clutter.h")]
	public enum ModifierType {
		[CCode (cname = "CLUTTER_SHIFT_MASK")]
		SHIFT_MASK,
		[CCode (cname = "CLUTTER_LOCK_MASK")]
		LOCK_MASK,
		[CCode (cname = "CLUTTER_CONTROL_MASK")]
		CONTROL_MASK,
		[CCode (cname = "CLUTTER_MOD1_MASK")]
		MOD1_MASK,
		[CCode (cname = "CLUTTER_MOD2_MASK")]
		MOD2_MASK,
		[CCode (cname = "CLUTTER_MOD3_MASK")]
		MOD3_MASK,
		[CCode (cname = "CLUTTER_MOD4_MASK")]
		MOD4_MASK,
		[CCode (cname = "CLUTTER_MOD5_MASK")]
		MOD5_MASK,
		[CCode (cname = "CLUTTER_BUTTON1_MASK")]
		BUTTON1_MASK,
		[CCode (cname = "CLUTTER_BUTTON2_MASK")]
		BUTTON2_MASK,
		[CCode (cname = "CLUTTER_BUTTON3_MASK")]
		BUTTON3_MASK,
		[CCode (cname = "CLUTTER_BUTTON4_MASK")]
		BUTTON4_MASK,
		[CCode (cname = "CLUTTER_BUTTON5_MASK")]
		BUTTON5_MASK,
		[CCode (cname = "CLUTTER_SUPER_MASK")]
		SUPER_MASK,
		[CCode (cname = "CLUTTER_HYPER_MASK")]
		HYPER_MASK,
		[CCode (cname = "CLUTTER_META_MASK")]
		META_MASK,
		[CCode (cname = "CLUTTER_RELEASE_MASK")]
		RELEASE_MASK,
		[CCode (cname = "CLUTTER_MODIFIER_MASK")]
		MODIFIER_MASK
	}
	[CCode (cprefix = "CLUTTER_PATH_", cheader_filename = "clutter/clutter.h")]
	public enum PathNodeType {
		MOVE_TO,
		LINE_TO,
		CURVE_TO,
		CLOSE,
		REL_MOVE_TO,
		REL_LINE_TO,
		REL_CURVE_TO
	}
	[CCode (cprefix = "CLUTTER_PICK_", cheader_filename = "clutter/clutter.h")]
	public enum PickMode {
		NONE,
		REACTIVE,
		ALL
	}
	[CCode (cprefix = "CLUTTER_REQUEST_", cheader_filename = "clutter/clutter.h")]
	public enum RequestMode {
		HEIGHT_FOR_WIDTH,
		WIDTH_FOR_HEIGHT
	}
	[CCode (cprefix = "CLUTTER_", cheader_filename = "clutter/clutter.h")]
	public enum RotateAxis {
		X_AXIS,
		Y_AXIS,
		Z_AXIS
	}
	[CCode (cprefix = "CLUTTER_ROTATE_", cheader_filename = "clutter/clutter.h")]
	public enum RotateDirection {
		CW,
		CCW
	}
	[CCode (cprefix = "CLUTTER_SCRIPT_ERROR_INVALID_", cheader_filename = "clutter/clutter.h")]
	public enum ScriptError {
		TYPE_FUNCTION,
		PROPERTY,
		VALUE
	}
	[CCode (cprefix = "CLUTTER_SCROLL_", cheader_filename = "clutter/clutter.h")]
	public enum ScrollDirection {
		UP,
		DOWN,
		LEFT,
		RIGHT
	}
	[CCode (cprefix = "CLUTTER_SHADER_ERROR_", cheader_filename = "clutter/clutter.h")]
	public enum ShaderError {
		NO_ASM,
		NO_GLSL,
		COMPILE
	}
	[CCode (cprefix = "CLUTTER_STAGE_STATE_", cheader_filename = "clutter/clutter.h")]
	public enum StageState {
		FULLSCREEN,
		OFFSCREEN,
		ACTIVATED
	}
	[CCode (cprefix = "CLUTTER_TEXTURE_ERROR_", cheader_filename = "clutter/clutter.h")]
	public enum TextureError {
		OUT_OF_MEMORY,
		NO_YUV,
		BAD_FORMAT
	}
	[CCode (cprefix = "CLUTTER_TEXTURE_FLAGS_", cheader_filename = "clutter/clutter.h")]
	public enum TextureFlags {
		[CCode (cname = "CLUTTER_TEXTURE_NONE")]
		NONE,
		[CCode (cname = "CLUTTER_TEXTURE_RGB_FLAG_BGR")]
		RGB_FLAG_BGR,
		[CCode (cname = "CLUTTER_TEXTURE_RGB_FLAG_PREMULT")]
		RGB_FLAG_PREMULT,
		[CCode (cname = "CLUTTER_TEXTURE_YUV_FLAG_YUV2")]
		YUV_FLAG_YUV2
	}
	[CCode (cprefix = "CLUTTER_TEXTURE_QUALITY_", cheader_filename = "clutter/clutter.h")]
	public enum TextureQuality {
		LOW,
		MEDIUM,
		HIGH
	}
	[CCode (cprefix = "CLUTTER_TIMELINE_", cheader_filename = "clutter/clutter.h")]
	public enum TimelineDirection {
		FORWARD,
		BACKWARD
	}
	[CCode (cprefix = "CLUTTER_UNIT_", cheader_filename = "clutter/clutter.h")]
	public enum UnitType {
		PIXEL,
		EM,
		MM,
		POINT
	}
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate double AlphaFunc (Clutter.Alpha alpha, void* user_data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate void BehaviourForeachFunc (Clutter.Behaviour behaviour, Clutter.Actor actor, void* data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool BindingActionFunc (GLib.Object gobject, string action_name, uint key_val, Clutter.ModifierType modifiers);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate void Callback (Clutter.Actor actor, void* data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool ModelFilterFunc (Clutter.Model model, Clutter.ModelIter iter, void* user_data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool ModelForeachFunc (Clutter.Model model, Clutter.ModelIter iter, void* user_data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate int ModelSortFunc (Clutter.Model model, GLib.Value a, GLib.Value b, void* user_data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate void PathCallback (Clutter.PathNode node, void* data);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate bool ProgressFunc (GLib.Value a, GLib.Value b, double progress, GLib.Value retval);
	[CCode (cheader_filename = "clutter/clutter.h", has_target = false)]
	public delegate void ScriptConnectFunc (Clutter.Script script, GLib.Object object, string signal_name, string handler_name, GLib.Object connect_object, GLib.ConnectFlags flags, void* user_data);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @0;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_AltCursor;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Attn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_BackTab;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_ChangeScreen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Copy;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_CursorBlink;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_CursorSelect;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_DeleteWord;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Duplicate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Enter;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_EraseEOF;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_EraseInput;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_ExSelect;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_FieldMark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Ident;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Jump;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_KeyClick;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Left2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_PA1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_PA2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_PA3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Play;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_PrintScreen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Quit;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Record;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Reset;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Right2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Rule;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Setup;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @3270_Test;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int @9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int A;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int AE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Aacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abreveacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abrevebelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abrevegrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abrevehook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Abrevetilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int AccessX_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int AccessX_Feedback_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Acircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Acircumflexacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Acircumflexbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Acircumflexgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Acircumflexhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Acircumflextilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Adiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Agrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ahook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Alt_L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Alt_R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Amacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Aogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_0;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_ain;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_alef;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_alefmaksura;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_beh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_comma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_dad;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_dal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_damma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_dammatan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_ddal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_farsi_yeh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_fatha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_fathatan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_feh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_fullstop;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_gaf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_ghain;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_ha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hah;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamza;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamza_above;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamza_below;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamzaonalef;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamzaonwaw;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamzaonyeh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_hamzaunderalef;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_heh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_heh_doachashmee;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_heh_goal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_jeem;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_jeh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_kaf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_kasra;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_kasratan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_keheh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_khah;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_lam;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_madda_above;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_maddaonalef;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_meem;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_noon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_noon_ghunna;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_peh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_percent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_qaf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_question_mark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_ra;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_rreh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_sad;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_seen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_semicolon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_shadda;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_sheen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_sukun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_superscript_alef;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_tah;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_tatweel;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_tcheh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_teh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_tehmarbuta;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_thal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_theh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_tteh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_veh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_waw;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_yeh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_yeh_baree;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_zah;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Arabic_zain;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Aring;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_AT;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_AYB;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_BEN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_CHA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_DA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_DZA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_E;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_FE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_GHAT;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_GIM;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_HI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_HO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_INI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_JE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_KE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_KEN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_KHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_LYUN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_MEN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_NU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_O;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_PE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_PYUR;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_RA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_RE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_SE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_SHA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_TCHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_TO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_TSA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_TSO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_TYUN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_VEV;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_VO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_VYUN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_YECH;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ZA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ZHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_accent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_amanak;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_apostrophe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_at;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ayb;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ben;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_but;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_cha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_da;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_dza;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_e;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_exclam;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_fe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_full_stop;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ghat;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_gim;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_hi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_hyphen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ini;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_je;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ken;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_khe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ligature_ew;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_lyun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_men;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_nu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_o;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_paruyk;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_pe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_pyur;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_question;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_ra;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_re;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_se;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_separation_mark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_sha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_shesht;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_tche;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_to;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_tsa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_tso;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_tyun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_verjaket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_vev;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_vo;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_vyun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_yech;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_yentamna;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_za;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Armenian_zhe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Atilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int AudibleBell_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int B;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Babovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int BackSpace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Begin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int BounceKeys_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Break;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Byelorussian_SHORTU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Byelorussian_shortu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int C;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string COGL;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int CURRENT_TIME;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cancel;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Caps_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ccaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ccedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ccircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Clear;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Codeinput;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ColonSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Control_L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Control_R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int CruzeiroSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_A;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_BE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_CHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_CHE_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_CHE_vertstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_DE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_DZHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_E;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_EF;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_EL;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_EM;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_EN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_EN_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ER;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ES;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_GHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_GHE_bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_HA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_HARDSIGN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_HA_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_I;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_IE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_IO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_I_macron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_JE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_KA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_KA_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_KA_vertstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_LJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_NJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_O;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_O_bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_PE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_SCHWA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_SHA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_SHCHA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_SHHA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_SHORTI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_SOFTSIGN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_TE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_TSE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_U;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_U_macron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_U_straight;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_U_straight_bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_VE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_YA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_YERU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_YU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ZE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ZHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ZHE_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_a;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_be;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_che;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_che_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_che_vertstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_de;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_dzhe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_e;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ef;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_el;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_em;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_en;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_en_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_er;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_es;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ghe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ghe_bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ha_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_hardsign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_i;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_i_macron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ie;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_io;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_je;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ka;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ka_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ka_vertstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_lje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_nje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_o;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_o_bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_pe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_schwa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_sha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_shcha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_shha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_shorti;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_softsign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_te;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_tse;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_u;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_u_macron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_u_straight;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_u_straight_bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ya;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_yeru;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_yu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_ze;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_zhe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Cyrillic_zhe_descender;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int D;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Dabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Dcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Delete;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int DongSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Dstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int E;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ENG;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ETH;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Eabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Eacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ebelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecircumflexacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecircumflexbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecircumflexgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecircumflexhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ecircumflextilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int EcuSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ediaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Egrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ehook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Eisu_Shift;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Eisu_toggle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Emacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int End;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Eogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Escape;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Eth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Etilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int EuroSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Execute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F10;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F11;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F12;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F13;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F14;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F15;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F16;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F17;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F18;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F19;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F20;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F21;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F22;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F23;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F24;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F25;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F26;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F27;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F28;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F29;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F30;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F31;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F32;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F33;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F34;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F35;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int F9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int FFrancSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string FLAVOUR;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Fabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_0;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Farsi_yeh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Find;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int First_Virtual_Screen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int G;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Gabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Gbreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Gcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Gcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Gcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_an;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_ban;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_can;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_char;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_chin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_cil;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_don;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_en;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_fi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_gan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_ghan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_hae;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_har;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_he;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_hie;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_hoe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_in;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_jhan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_jil;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_kan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_khar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_las;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_man;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_nar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_on;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_par;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_phar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_qar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_rae;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_san;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_shin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_tan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_tar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_un;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_vin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_we;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_xan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_zen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Georgian_zhar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_ALPHA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_ALPHAaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_BETA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_CHI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_DELTA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_EPSILON;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_EPSILONaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_ETA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_ETAaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_GAMMA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_IOTA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_IOTAaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_IOTAdiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_IOTAdieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_KAPPA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_LAMBDA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_LAMDA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_MU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_NU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_OMEGA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_OMEGAaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_OMICRON;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_OMICRONaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_PHI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_PI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_PSI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_RHO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_SIGMA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_TAU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_THETA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_UPSILON;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_UPSILONaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_UPSILONdieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_XI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_ZETA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_accentdieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_alpha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_alphaaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_beta;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_chi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_delta;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_epsilon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_epsilonaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_eta;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_etaaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_finalsmallsigma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_gamma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_horizbar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_iota;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_iotaaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_iotaaccentdieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_iotadieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_kappa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_lambda;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_lamda;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_mu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_nu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_omega;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_omegaaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_omicron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_omicronaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_phi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_pi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_psi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_rho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_sigma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_tau;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_theta;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_upsilon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_upsilonaccent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_upsilonaccentdieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_upsilondieresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_xi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Greek_zeta;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int H;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_A;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_AE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_AraeA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_AraeAE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Banja;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Cieuc;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Codeinput;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Dikeud;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_E;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_EO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_EU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_End;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Hanja;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Hieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_I;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Ieung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Cieuc;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Dikeud;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Hieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Ieung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Jieuj;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Khieuq;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Kiyeog;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_KiyeogSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_KkogjiDalrinIeung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Mieum;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Nieun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_NieunHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_NieunJieuj;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_PanSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Phieuf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Pieub;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_PieubSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Rieul;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulKiyeog;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulMieum;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulPhieuf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulPieub;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_RieulTieut;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Sios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_SsangKiyeog;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_SsangSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_Tieut;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_J_YeorinHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Jamo;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Jeonja;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Jieuj;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Khieuq;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Kiyeog;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_KiyeogSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_KkogjiDalrinIeung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Mieum;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_MultipleCandidate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Nieun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_NieunHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_NieunJieuj;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_O;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_OE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_PanSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Phieuf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Pieub;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_PieubSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_PostHanja;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_PreHanja;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_PreviousCandidate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Rieul;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulKiyeog;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulMieum;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulPhieuf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulPieub;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulTieut;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_RieulYeorinHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Romaja;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SingleCandidate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Sios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Special;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SsangDikeud;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SsangJieuj;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SsangKiyeog;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SsangPieub;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SsangSios;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Start;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SunkyeongeumMieum;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SunkyeongeumPhieuf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_SunkyeongeumPieub;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_Tieut;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_U;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_WA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_WAE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_WE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_WEO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_WI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YAE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YEO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_YeorinHieuh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hangul_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hankaku;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hebrew_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Help;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Henkan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Henkan_Mode;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hiragana;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hiragana_Katakana;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Home;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hyper_L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Hyper_R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int I;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Center_Object;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Continuous_Underline;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Discontinuous_Underline;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Emphasize;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Enter;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Fast_Cursor_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Fast_Cursor_Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Fast_Cursor_Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Fast_Cursor_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_First_Group;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_First_Group_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Group_Latch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Group_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Group_Shift;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Last_Group;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Last_Group_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Left_Tab;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level2_Latch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level3_Latch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level3_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level3_Shift;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level5_Latch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level5_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Level5_Shift;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Move_Line_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Move_Line_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Next_Group;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Next_Group_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Partial_Line_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Partial_Line_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Partial_Space_Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Partial_Space_Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Prev_Group;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Prev_Group_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Release_Both_Margins;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Release_Margin_Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Release_Margin_Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Set_Margin_Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ISO_Set_Margin_Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Iabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Iacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ibelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ibreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Icircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Idiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Igrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ihook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Imacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Insert;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Iogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Itilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int J;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Jcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int K;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_0;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Add;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Begin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Decimal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Delete;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Divide;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_End;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Enter;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Equal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_F1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_F2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_F3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_F4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Home;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Insert;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Multiply;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Next;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Page_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Page_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Prior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Separator;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Space;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Subtract;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Tab;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int KP_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Kana_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Kana_Shift;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Kanji;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Kanji_Bangou;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Katakana;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Kcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Korean_Won;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L10;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int L9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Lacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Last_Virtual_Screen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Lbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Lcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Lcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Linefeed;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int LiraSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Lstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int M;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Mabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Macedonia_DSE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Macedonia_GJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Macedonia_KJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Macedonia_dse;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Macedonia_gje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Macedonia_kje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Mae_Koho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Massyo;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Menu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Meta_L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Meta_R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MillSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Mode_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MouseKeys_Accel_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MouseKeys_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Muhenkan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Multi_key;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int MultipleCandidate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int N;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Nacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int NairaSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ncaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ncedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int NewSheqelSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Next;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Next_Virtual_Screen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ntilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Num_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int O;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int OE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Oacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Obarred;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Obelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocircumflexacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocircumflexbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocircumflexgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocircumflexhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ocircumflextilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Odiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Odoubleacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ograve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohorn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohornacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohornbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohorngrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohornhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ohorntilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Omacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ooblique;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Oslash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Otilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Overlay1_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Overlay2_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int P;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PATH_RELATIVE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PRIORITY_REDRAW;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Page_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Page_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pause;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PesetaSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Accelerate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Button1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Button2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Button3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Button4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Button5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Button_Dflt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DblClick1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DblClick2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DblClick3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DblClick4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DblClick5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DblClick_Dflt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DfltBtnNext;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DfltBtnPrev;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Down;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DownLeft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_DownRight;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Drag1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Drag2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Drag3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Drag4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Drag5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Drag_Dflt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_EnableKeys;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Left;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_UpLeft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Pointer_UpRight;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Prev_Virtual_Screen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int PreviousCandidate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Print;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Prior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Q;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R10;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R11;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R12;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R13;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R14;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R15;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int R9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Racute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Rcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Rcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Redo;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int RepeatKeys_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Return;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Right;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Romaji;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int RupeeSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int S;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int SCHWA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Sabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Sacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Scaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Scedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Scircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Scroll_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Select;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_DJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_DZE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_JE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_LJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_NJE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_TSHE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_dje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_dze;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_je;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_lje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_nje;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Serbian_tshe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Shift_L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Shift_Lock;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Shift_R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int SingleCandidate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int SlowKeys_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int StickyKeys_Enable;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Super_L;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Super_R;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Sys_Req;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int T;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int THORN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Tab;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Tabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Tcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Tcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Terminate_Server;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_baht;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_bobaimai;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_chochan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_chochang;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_choching;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_chochoe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_dochada;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_dodek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_fofa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_fofan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_hohip;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_honokhuk;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_khokhai;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_khokhon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_khokhuat;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_khokhwai;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_khorakhang;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_kokai;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lakkhangyao;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lekchet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lekha;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lekhok;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lekkao;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_leknung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lekpaet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_leksam;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_leksi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_leksong;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_leksun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lochula;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_loling;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_lu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maichattawa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maiek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maihanakat;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maihanakat_maitho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maitaikhu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maitho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maitri;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_maiyamok;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_moma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_ngongu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_nikhahit;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_nonen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_nonu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_oang;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_paiyannoi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_phinthu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_phophan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_phophung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_phosamphao;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_popla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_rorua;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_ru;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraaa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraae;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraaimaimalai;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraaimaimuan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraam;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sarae;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sarai;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraii;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sarao;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sarau;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_saraue;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sarauee;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sarauu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sorusi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sosala;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_soso;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_sosua;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thanthakhat;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thonangmontho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thophuthao;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thothahan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thothan;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thothong;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_thothung;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_topatak;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_totao;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_wowaen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_yoyak;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thai_yoying;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Thorn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Touroku;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Tslash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int U;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ubelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ubreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ucircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Udiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Udoubleacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ugrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhorn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhornacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhornbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhorngrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhornhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uhorntilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_GHE_WITH_UPTURN;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_I;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_IE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_YI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_ghe_with_upturn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_i;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_ie;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukrainian_yi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukranian_I;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukranian_JE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukranian_YI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukranian_i;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukranian_je;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ukranian_yi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Umacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Undo;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Up;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Uring;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Utilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int V;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const double VERSION;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int VERSION_HEX;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const string VERSION_S;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int VoidSymbol;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int W;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Wacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Wcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Wdiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Wgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int WonSign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int X;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Xabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Y;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Yacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ybelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ycircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ydiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ygrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Yhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Ytilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Z;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zen_Koho;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zenkaku;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zenkaku_Hankaku;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int Zstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int a;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int aacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abreveacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abrevebelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abrevegrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abrevehook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int abrevetilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acircumflexacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acircumflexbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acircumflexgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acircumflexhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acircumflextilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int acute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int adiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ae;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int agrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ahook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int amacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ampersand;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int aogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int apostrophe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int approxeq;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int approximate;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int aring;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int asciicircum;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int asciitilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int asterisk;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int at;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int atilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int b;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int babovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int backslash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ballotcross;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int bar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int because;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int blank;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botintegral;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botleftparens;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botleftsqbracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botleftsummation;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botrightparens;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botrightsqbracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botrightsummation;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int bott;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int botvertsummationconnector;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braceleft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braceright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int bracketleft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int bracketright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_blank;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_10;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dot_9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1234;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12345;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1234567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12345678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1234568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1234578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12346;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1234678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12347;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12348;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1235;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12356;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1235678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12357;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12358;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1236;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12367;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_123678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12368;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1237;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12378;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1238;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_124;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1245;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_124567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1245678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_124568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_124578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1246;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_124678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1247;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1248;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_125;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1256;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_125678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1257;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1258;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_126;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1267;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_12678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1268;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_127;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1278;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_128;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_134;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1345;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_134567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1345678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_134568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_134578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1346;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_134678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1347;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1348;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_135;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1356;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_135678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1357;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1358;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_136;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1367;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_13678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1368;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_137;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1378;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_138;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_14;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_145;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_14567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_145678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_14568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_14578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_146;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_14678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_147;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_148;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_15;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_156;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_15678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_157;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_158;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_16;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_167;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_1678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_168;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_17;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_178;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_18;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_234;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2345;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_234567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2345678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_234568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_234578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2346;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_234678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2347;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2348;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_235;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2356;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_235678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2357;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2358;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_236;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2367;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_23678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2368;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_237;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2378;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_238;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_24;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_245;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_24567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_245678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_24568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_24578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_246;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_24678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_247;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_248;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_25;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_256;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_25678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_257;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_258;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_26;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_267;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_2678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_268;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_27;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_278;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_28;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_34;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_345;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_34567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_345678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_34568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_34578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_346;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_34678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_347;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_348;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_35;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_356;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_35678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_357;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_358;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_36;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_367;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_3678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_368;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_37;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_378;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_38;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_4;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_45;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_456;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_4567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_45678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_4568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_457;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_4578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_458;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_46;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_467;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_4678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_468;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_47;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_478;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_48;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_56;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_567;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_5678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_568;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_57;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_578;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_58;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_6;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_67;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_678;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_68;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_78;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int braille_dots_8;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int breve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int brokenbar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int c;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int careof;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int caret;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int caron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ccaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ccedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ccircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int checkerboard;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int checkmark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int circle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int club;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int colon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int comma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int containsas;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int copyright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cr;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int crossinglines;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cuberoot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int currency;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int cursor;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int d;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dagger;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_abovecomma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_abovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_abovereversedcomma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_abovering;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_acute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowbreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowdiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowmacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowring;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_belowtilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_breve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_caron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_cedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_circumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_dasia;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_diaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_doubleacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_grave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_hook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_horn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_iota;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_macron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_ogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_perispomeni;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_psili;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_semivoiced_sound;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_stroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_tilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dead_voiced_sound;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int decimalpoint;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int degree;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int diaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int diamond;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int digitspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dintegral;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int division;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dollar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int doubbaselinedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int doubleacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int doubledagger;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int doublelowquotemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int downarrow;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int downcaret;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int downshoe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int downstile;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int downtack;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int dstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int e;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ebelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecircumflexacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecircumflexbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecircumflexgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecircumflexhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ecircumflextilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ediaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int egrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ehook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eightsubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eightsuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int elementof;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ellipsis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int em3space;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int em4space;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emdash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emfilledcircle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emfilledrect;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emopencircle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emopenrectangle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emptyset;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int emspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int endash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int enfilledcircbullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int enfilledsqbullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eng;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int enopencircbullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int enopensquarebullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int enspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int equal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int eth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int etilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int exclam;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int exclamdown;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int f;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int femalesymbol;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ff;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int figdash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int filledlefttribullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int filledrectbullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int filledrighttribullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int filledtribulletdown;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int filledtribulletup;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fiveeighths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fivesixths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fivesubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fivesuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fourfifths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int foursubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int foursuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int fourthroot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int function;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int g;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int gabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int gbreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int gcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int gcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int gcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int grave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int greater;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int greaterthanequal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int guillemotleft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int guillemotright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int h;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hairspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int heart;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_aleph;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_ayin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_bet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_beth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_chet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_dalet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_daleth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_doublelowline;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_finalkaph;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_finalmem;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_finalnun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_finalpe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_finalzade;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_finalzadi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_gimel;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_gimmel;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_he;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_het;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_kaph;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_kuf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_lamed;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_mem;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_nun;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_pe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_qoph;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_resh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_samech;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_samekh;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_shin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_taf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_taw;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_tet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_teth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_waw;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_yod;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_zade;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_zadi;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_zain;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hebrew_zayin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hexagram;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int horizconnector;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int horizlinescan1;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int horizlinescan3;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int horizlinescan5;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int horizlinescan7;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int horizlinescan9;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ht;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int hyphen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int i;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int iacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ibelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ibreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int icircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int identical;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int idiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int idotless;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ifonlyif;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int igrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ihook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int imacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int implies;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int includedin;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int includes;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int infinity;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int integral;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int intersection;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int iogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int itilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int j;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int jcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int jot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int k;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_A;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_CHI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_E;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_FU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_HA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_HE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_HI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_HO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_HU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_I;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_KA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_KE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_KI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_KO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_KU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_MA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_ME;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_MI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_MO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_MU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_N;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_NA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_NE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_NI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_NO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_NU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_O;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_RA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_RE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_RI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_RO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_RU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_SA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_SE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_SHI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_SO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_SU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_TA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_TE;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_TI;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_TO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_TSU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_TU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_U;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_WA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_WO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_YA;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_YO;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_YU;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_a;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_closingbracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_comma;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_conjunctive;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_e;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_fullstop;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_i;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_middledot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_o;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_openingbracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_tsu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_tu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_u;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_ya;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_yo;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kana_yu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kappa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int kra;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int l;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int latincross;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftanglebracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftarrow;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftcaret;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftdoublequotemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftmiddlecurlybrace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftopentriangle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftpointer;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftradical;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftshoe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftsinglequotemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int leftt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lefttack;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int less;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lessthanequal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int logicaland;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int logicalor;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lowleftcorner;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lowrightcorner;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int lstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int m;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int mabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int macron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int malesymbol;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int maltesecross;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int marker;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int masculine;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int minus;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int minutes;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int mu;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int multiply;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int musicalflat;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int musicalsharp;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int n;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int nabla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int nacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ncaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ncedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ninesubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ninesuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int nl;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int nobreakspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int notapproxeq;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int notelementof;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int notequal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int notidentical;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int notsign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ntilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int numbersign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int numerosign;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int o;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int oacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int obarred;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int obelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocircumflexacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocircumflexbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocircumflexgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocircumflexhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ocircumflextilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int odiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int odoubleacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int oe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ograve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohorn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohornacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohornbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohorngrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohornhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ohorntilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int omacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int oneeighth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onefifth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onehalf;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onequarter;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onesixth;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onesubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onesuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int onethird;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ooblique;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int openrectbullet;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int openstar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int opentribulletdown;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int opentribulletup;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ordfeminine;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int oslash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int otilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int overbar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int overline;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int p;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int pabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int paragraph;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int parenleft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int parenright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int partdifferential;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int partialderivative;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int percent;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int period;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int periodcentered;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int phonographcopyright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int plus;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int plusminus;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int prescription;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int prolongedsound;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int punctspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int q;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int quad;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int question;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int questiondown;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int quotedbl;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int quoteleft;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int quoteright;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int r;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int racute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int radical;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int registered;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightanglebracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightarrow;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightcaret;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightdoublequotemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightmiddlecurlybrace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightmiddlesummation;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightopentriangle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightpointer;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightshoe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightsinglequotemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int rightt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int righttack;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int s;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int scaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int scedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int schwa;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int scircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int script_switch;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int seconds;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int section;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int semicolon;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int semivoicedsound;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int seveneighths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sevensubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sevensuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int signaturemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int signifblank;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int similarequal;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int singlelowquotemark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sixsubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sixsuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int slash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int soliddiamond;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int space;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int squareroot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ssharp;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int sterling;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int stricteq;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int t;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int tabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int tcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int tcedilla;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int telephone;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int telephonerecorder;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int therefore;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int thinspace;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int thorn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int threeeighths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int threefifths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int threequarters;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int threesubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int threesuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int tintegral;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topintegral;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topleftparens;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topleftradical;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topleftsqbracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topleftsummation;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int toprightparens;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int toprightsqbracket;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int toprightsummation;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int topvertsummationconnector;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int trademark;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int trademarkincircle;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int tslash;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int twofifths;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int twosubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int twosuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int twothirds;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int u;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ubelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ubreve;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ucircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int udiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int udoubleacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ugrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhorn;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhornacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhornbelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhorngrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhornhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uhorntilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int umacron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int underbar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int underscore;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int union;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uogonek;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uparrow;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int upcaret;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int upleftcorner;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uprightcorner;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int upshoe;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int upstile;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uptack;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int uring;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int utilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int v;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int variation;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int vertbar;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int vertconnector;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int voicedsound;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int vt;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int w;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int wacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int wcircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int wdiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int wgrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int x;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int xabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int y;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int yacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ybelowdot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ycircumflex;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ydiaeresis;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int yen;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ygrave;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int yhook;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int ytilde;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int z;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int zabovedot;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int zacute;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int zcaron;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int zerosubscript;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int zerosuperior;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public const int zstroke;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void base_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void cairo_set_source_color (Cairo.Context cr, Clutter.Color color);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void clear_glyph_cache ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool color_equal (void* v1, void* v2);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint color_hash (void* v);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned GLib.ParamSpec container_class_find_child_property (GLib.ObjectClass klass, string property_name);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned GLib.ParamSpec[] container_class_list_child_properties (GLib.ObjectClass klass, out uint n_properties);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void do_event (Clutter.Event event);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.Event event_get ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.Event event_peek ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool events_pending ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool feature_available (Clutter.FeatureFlags feature);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.FeatureFlags feature_get_all ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint frame_source_add (uint fps, GLib.SourceFunc func, void* data);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint frame_source_add_full (int priority, uint fps, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.Actor get_actor_by_gid (uint32 id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint32 get_current_event_time ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_debug_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Backend get_default_backend ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint get_default_frame_rate ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.FontFlags get_font_flags ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Pango.FontMap get_font_map ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InputDevice get_input_device_for_id (int id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Actor get_keyboard_grab ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_motion_events_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_gl_picking_enabled ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.OptionGroup get_option_group ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.OptionGroup get_option_group_without_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned Clutter.Actor get_pointer_grab ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned string get_script_id (GLib.Object gobject);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static bool get_show_fps ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static ulong get_timestamp ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_keyboard (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_pointer (Clutter.Actor actor);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void grab_pointer_for_device (Clutter.Actor actor, int id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InitError init ([CCode (array_length_pos = 0.5)] out string[]? argv);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.InitError init_with_args ([CCode (array_length_pos = 0.5)] ref string[]? argv, string? parameter_string, GLib.OptionEntry? entries, string? translation_domain) throws GLib.Error;
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint32 keysym_to_unicode (uint keyval);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void main ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static int main_level ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void main_quit ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.ParamSpec param_spec_color (string name, string nick, string blurb, Clutter.Color default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.ParamSpec param_spec_fixed (string name, string nick, string blurb, Cogl.Fixed minimum, Cogl.Fixed maximum, Cogl.Fixed default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static GLib.ParamSpec param_spec_units (string name, string nick, string blurb, Clutter.UnitType default_type, float minimum, float maximum, float default_value, GLib.ParamFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void redraw (Clutter.Stage stage);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_default_frame_rate (uint frames_per_sec);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_font_flags (Clutter.FontFlags flags);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_motion_events_enabled (bool enable);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void set_gl_picking_enabled (bool enable);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_frame_source (uint fps, GLib.SourceFunc func, void* data);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_frame_source_full (int priority, uint fps, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_idle (GLib.SourceFunc func, void* data);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_idle_full (int priority, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_repaint_func (GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_timeout (uint interval, GLib.SourceFunc func, void* data);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static uint threads_add_timeout_full (int priority, uint interval, GLib.SourceFunc func, void* data, GLib.DestroyNotify notify);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void threads_enter ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void threads_init ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void threads_leave ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void threads_remove_repaint_func (uint handle_id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void threads_set_lock_functions (GLib.Callback enter_fn, GLib.Callback leave_fn);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_keyboard ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_pointer ();
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void ungrab_pointer_for_device (int id);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static int util_next_p2 (int a);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.Color value_get_color (GLib.Value value);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Cogl.Fixed value_get_fixed (GLib.Value value);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static float value_get_shader_float (GLib.Value value, out size_t length);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static int value_get_shader_int (GLib.Value value, out size_t length);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static unowned float[] value_get_shader_matrix (GLib.Value value, out size_t length);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static Clutter.Units value_get_units (GLib.Value value);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void value_set_color (GLib.Value value, Clutter.Color color);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void value_set_fixed (GLib.Value value, Cogl.Fixed fixed_);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void value_set_shader_float (GLib.Value value, int size, out float floats);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void value_set_shader_int (GLib.Value value, int size, out int ints);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void value_set_shader_matrix (GLib.Value value, int size, out float matrix);
	[CCode (cheader_filename = "clutter/clutter.h")]
	public static void value_set_units (GLib.Value value, Clutter.Units units);
}
