/* launcher-0.3.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Launcher", lower_case_cprefix = "launcher_")]
namespace LibLauncher {
	[CCode (cheader_filename = "launcher/launcher.h")]
	public class Application : GLib.Object {
		[CCode (has_construct_function = false)]
		public Application ();
		public void close (uint32 timestamp);
		public void ensure_state ();
		[CCode (has_construct_function = false)]
		public Application.from_desktop_file (string desktop_file, bool dont_check_windows);
		[CCode (has_construct_function = false)]
		public Application.from_wnck_window (Wnck.Window window);
		public unowned string get_comment ();
		public unowned string get_desktop_file ();
		public unowned string get_exec_string ();
		public bool get_favorite ();
		public bool get_focused ();
		public unowned string get_icon_name ();
		public unowned string get_name ();
		public bool get_running ();
		public unowned string get_unique_string ();
		public bool get_urgent ();
		public unowned GLib.SList get_windows ();
		public bool has_gathered_windows ();
		public bool has_minimized ();
		public bool launch () throws GLib.Error;
		public void minimize ();
		public bool owns_window (Wnck.Window window);
		public void restore (uint32 timestamp);
		public void set_desktop_file (string desktop_file, bool dont_check_windows);
		public static void set_window_activate_func (LibLauncher.ApplicationWindowActivateFunc func, void* callback_d);
		public void show (uint32 timestamp);
		public void update_windows ();
		public void update_windows_with_callback (LibLauncher.ApplicationNotifyFinished notify);
		public string comment { get; }
		[NoAccessorMethod]
		public string desktop_file_path { owned get; set; }
		[NoAccessorMethod]
		public string exec { owned get; }
		public bool favorite { get; }
		[NoAccessorMethod]
		public bool focused { get; set; }
		public string icon_name { get; }
		public string name { get; }
		[NoAccessorMethod]
		public bool running { get; set; }
		public string unique_string { get; }
		public virtual signal void closed (Wnck.Window wnckwindow);
		public virtual signal void focus_changed ();
		public virtual signal void icon_changed ();
		public virtual signal void info_changed ();
		public virtual signal void opened (Wnck.Window wnckwindow);
		public virtual signal void running_changed ();
		public virtual signal void urgent_changed ();
	}
	[Compact]
	[CCode (cheader_filename = "launcher/launcher.h")]
	public class ApplicationWindow {
	}
	[CCode (cheader_filename = "launcher/launcher.h")]
	public class Appman : GLib.Object {
		public int add_file_watch (string path);
		public unowned LibLauncher.Application get_application_for_desktop_file (string desktop);
		public unowned LibLauncher.Application get_application_for_wnck_window (Wnck.Window wnck_window);
		public unowned GLib.Sequence get_applications ();
		public static unowned LibLauncher.Appman get_default ();
		public bool get_enable_window_checking ();
		public void rm_file_watch (int wd);
		public void set_enable_window_checking (bool enable_window_matching);
		public bool enable_window_checking { get; set; }
		public virtual signal void watch_file_modified (int p0);
	}
	[CCode (cheader_filename = "launcher/launcher.h")]
	public class Favorites : GLib.Object {
		public bool add_favorite (string uid);
		public bool get_bool (string uid, string key);
		public static unowned LibLauncher.Favorites get_default ();
		public unowned GLib.SList get_favorites ();
		public float get_float (string uid, string key);
		public int get_int (string uid, string key);
		public unowned GLib.SList get_list (string uid, string key, LibLauncher.FavoritesListValue value_type);
		public bool get_readonly (string uid, string key);
		public unowned string get_string (string uid, string key);
		public bool remove_favorite (string uid);
		public void set_bool (string uid, string key, bool value);
		public void set_favorites (GLib.SList list);
		public void set_float (string uid, string key, float value);
		public void set_int (string uid, string key, int value);
		public void set_list (string uid, string key, LibLauncher.FavoritesListValue value_type, GLib.SList value);
		public void set_string (string uid, string key, string value);
	}
	[Compact]
	[CCode (type_id = "LAUNCHER_TYPE_FOLDER", cheader_filename = "launcher/launcher.h")]
	public class Folder {
		[CCode (has_construct_function = false)]
		public Folder (string name, string uri);
		public void activate () throws GLib.Error;
		public unowned string get_icon_name ();
		public unowned string get_name ();
		public unowned string get_uri ();
	}
	[CCode (cheader_filename = "launcher/launcher.h")]
	public class FolderBookmarks : GLib.Object {
		public unowned GLib.SList get_bookmarks ();
		public static unowned LibLauncher.FolderBookmarks get_default ();
		public virtual signal void bookmarks_changed ();
	}
	[CCode (cheader_filename = "launcher/launcher.h")]
	public class Session : GLib.Object {
		public static unowned LibLauncher.Session get_default ();
		public void update_windows (Wnck.Window window);
		public virtual signal void application_launching (LibLauncher.Application application);
		public virtual signal void application_opened (LibLauncher.Application application);
	}
	[CCode (cprefix = "LAUNCHER_FAVORITES_", has_type_id = false, cheader_filename = "launcher/launcher.h")]
	public enum FavoritesListValue {
		STRING,
		INT,
		FLOAT,
		BOOL
	}
	[CCode (cheader_filename = "launcher/launcher.h")]
	public delegate void ApplicationNotifyFinished (LibLauncher.Application application);
	[CCode (cheader_filename = "launcher/launcher.h", has_target = false)]
	public delegate void ApplicationWindowActivateFunc (Wnck.Window window, uint32 timestamp, void* callback_d);
	[CCode (cheader_filename = "launcher/launcher.h")]
	public static unowned string icon_utils_icon_name_for_volume_uri (string uri);
}
